/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate4.support;

import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.hibernate4.SessionHolder;
import org.springframework.orm.hibernate4.support.OpenSessionInViewInterceptor;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;

public class GrailsOpenSessionInViewInterceptor
extends OpenSessionInViewInterceptor {
    protected FlushMode hibernateFlushMode = FlushMode.MANUAL;

    protected Session openSession() throws DataAccessResourceFailureException {
        Session session = super.openSession();
        this.applyFlushMode(session);
        return session;
    }

    protected void applyFlushMode(Session session) {
        session.setFlushMode(this.hibernateFlushMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postHandle(WebRequest request, ModelMap model) throws DataAccessException {
        SessionHolder sessionHolder = (SessionHolder)TransactionSynchronizationManager.getResource((Object)this.getSessionFactory());
        Session session = sessionHolder != null ? sessionHolder.getSession() : null;
        try {
            super.postHandle(request, model);
            if (session != null && session.getFlushMode() != FlushMode.MANUAL && session.getFlushMode() != FlushMode.COMMIT) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)"Eagerly flushing Hibernate session");
                }
                session.flush();
            }
        }
        finally {
            if (session != null) {
                session.setFlushMode(FlushMode.MANUAL);
            }
        }
    }

    public void setHibernateDatastore(AbstractHibernateDatastore hibernateDatastore) {
        String defaultFlushModeName = hibernateDatastore.getDefaultFlushModeName();
        this.hibernateFlushMode = hibernateDatastore.isOsivReadOnly() ? FlushMode.MANUAL : FlushMode.valueOf((String)defaultFlushModeName);
        this.setSessionFactory(hibernateDatastore.getSessionFactory());
    }
}

