/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.docx4j.Docx4J;
import org.docx4j.TextUtils;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.model.datastorage.OpenDoPEHandler;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsCustomPart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.ThemePart;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FontTablePart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.GlossaryDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.StyleDefinitionsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.WebSettingsPart;
import org.docx4j.openpackaging.parts.opendope.JaxbCustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.opendope.XPathsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.relationships.Relationships;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtDate;
import org.docx4j.wml.CTSdtText;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.R;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.Styles;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tc;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateXmlFromDocumentSurface {
    private static Logger log = LoggerFactory.getLogger(UpdateXmlFromDocumentSurface.class);
    private WordprocessingMLPackage pkg;
    private XPathsPart xPathsPart;
    private Map<String, CustomXmlPart> customXmlDataStorageParts;
    private List<CustomXmlPart> updatedParts = new ArrayList<CustomXmlPart>();
    private boolean supportStylesInWordAltChunkProcessing;

    public WordprocessingMLPackage getPkg() {
        return this.pkg;
    }

    public UpdateXmlFromDocumentSurface(WordprocessingMLPackage wordMLPackage, boolean supportStylesInWordAltChunkProcessing) throws Docx4JException {
        this.pkg = wordMLPackage;
        this.xPathsPart = this.pkg.getMainDocumentPart().getXPathsPart();
        if (this.xPathsPart == null) {
            throw new Docx4JException("OpenDoPE XPaths part missing");
        }
        this.customXmlDataStorageParts = this.pkg.getCustomXmlDataStorageParts();
        this.supportStylesInWordAltChunkProcessing = supportStylesInWordAltChunkProcessing;
    }

    public List<CustomXmlPart> updateCustomXmlParts() throws Docx4JException {
        SdtFinder sdtFinder = new SdtFinder();
        this.findSdts(sdtFinder);
        this.updateXmlFromSdts(sdtFinder.contentControls);
        for (CustomXmlPart cxp : this.updatedParts) {
            if (!(cxp instanceof JaxbCustomXmlDataStoragePart)) continue;
            ((JaxbCustomXmlDataStoragePart)cxp).updateJaxbElementFromDocument();
        }
        return this.updatedParts;
    }

    private CustomXmlPart getCustomXmlPart(Xpaths.Xpath xpath) {
        String storeItemId = xpath.getDataBinding().getStoreItemID();
        String xpathExp = xpath.getDataBinding().getXpath();
        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
        return this.customXmlDataStorageParts.get(storeItemId.toLowerCase());
    }

    private void updateXmlFromSdts(List<SdtElement> contentControls) {
        for (SdtElement sdt : contentControls) {
            this.handleSdt(sdt);
        }
    }

    private void handleSdt(SdtElement sdt) {
        log.debug(sdt.getParent().getClass().getName());
        SdtPr sdtPr = sdt.getSdtPr();
        if (sdtPr != null) {
            Tag tag = sdtPr.getTag();
            HashMap<String, String> map = null;
            if (tag != null) {
                log.info(tag.getVal());
                map = QueryString.parseQueryString(tag.getVal(), true);
            }
            SdtPr.Picture pic = (SdtPr.Picture)sdtPr.getByClass(SdtPr.Picture.class);
            if (sdtPr.getDataBinding() != null && pic != null) {
                log.warn("TODO: consider Picture handling {}", (Object)sdtPr.getId().getVal());
            } else if (map != null && map.containsKey("od:ContentType") && map.get("od:ContentType").equals("application/xhtml+xml")) {
                log.error("TODO: add HTML import support");
            } else if (map != null && map.containsKey("od:component")) {
                String componentId = map.get("od:component");
                log.warn("TODO: consider component handling {}", (Object)sdtPr.getId().getVal());
            } else if (map != null && map.containsKey("od:xpath")) {
                boolean isMultiline = this.isMultiline(sdtPr);
                if (isMultiline) {
                    log.warn("TODO: add multiline support");
                }
                String xpathId = map.get("od:xpath");
                if (sdtPr.getByClass(CTSdtDate.class) != null) {
                    log.warn("TODO: consider SdtDate handling {}", (Object)sdtPr.getId().getVal());
                } else {
                    String value = null;
                    if (sdtPr.getByClass(SdtPr.RichText.class) != null || map.containsKey("od:progid") && map.get("od:progid").equals("Word.Document")) {
                        log.info(XmlUtils.marshaltoString(sdt.getSdtContent()));
                        log.info("containing " + sdt.getClass().getName());
                        if (sdt instanceof SdtBlock || sdt instanceof CTSdtCell) {
                            try {
                                WordprocessingMLPackage blockPkg = this.getAsDocx(sdt);
                                this.trimParts(blockPkg, blockPkg.getRelationshipsPart(), false);
                                if (blockPkg != null) {
                                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                                    blockPkg.save(baos, 2);
                                    value = baos.toString("UTF-8");
                                }
                            }
                            catch (Docx4JException e) {
                                e.printStackTrace();
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                        } else {
                            log.warn("TODO: " + sdt.getClass().getName());
                        }
                    } else {
                        value = TextUtils.getText(sdt.getSdtContent());
                    }
                    try {
                        Xpaths.Xpath xpath = XPathsPart.getXPathById((Xpaths)this.xPathsPart.getJaxbElement(), xpathId);
                        if (xpath == null) {
                            throw new Docx4JException("Couldn't find xpath with id: " + xpathId);
                        }
                        String xpathExp = xpath.getDataBinding().getXpath();
                        String prefixMappings = xpath.getDataBinding().getPrefixMappings();
                        log.debug("Processing " + xpathExp);
                        CustomXmlPart cxp = this.getCustomXmlPart(xpath);
                        if (cxp == null) {
                            throw new Docx4JException("Couldn't find cxp with id: " + xpath.getDataBinding().getStoreItemID());
                        }
                        cxp.setNodeValueAtXPath(xpathExp, value, prefixMappings);
                        if (!this.updatedParts.contains(cxp)) {
                            this.updatedParts.add(cxp);
                        }
                    }
                    catch (Docx4JException e) {
                        log.error("Problems updating {}", (Object)xpathId);
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            } else if (sdtPr.getDataBinding() != null) {
                log.debug("Adding non-OpenDoPE databound control {}", (Object)sdtPr.getId().getVal());
            } else if (log.isDebugEnabled()) {
                log.debug("Ignoring control with tag {}", (Object)sdtPr.getTag().getVal());
                log.debug("Not processing " + XmlUtils.marshaltoString((Object)sdtPr, true));
            }
        }
    }

    private void findSdts(SdtFinder sdtPrFinder) throws Docx4JException {
        this.findSdtsInPart(this.pkg.getMainDocumentPart(), sdtPrFinder);
        RelationshipsPart rp = this.pkg.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                this.findSdtsInPart((HeaderPart)rp.getPart(r), sdtPrFinder);
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            this.findSdtsInPart((FooterPart)rp.getPart(r), sdtPrFinder);
        }
    }

    private void findSdtsInPart(ContentAccessor content, SdtFinder sdtFinder) throws Docx4JException {
        new TraversalUtil(content.getContent(), sdtFinder);
    }

    private boolean isMultiline(SdtPr sdtPr) {
        for (Object o : sdtPr.getRPrOrAliasOrLock()) {
            if (!((o = XmlUtils.unwrap(o)) instanceof CTSdtText)) continue;
            return ((CTSdtText)o).isMultiLine();
        }
        return false;
    }

    private WordprocessingMLPackage getAsDocx(SdtElement sdtBlock) throws InvalidFormatException {
        WordprocessingMLPackage clone = (WordprocessingMLPackage)this.pkg.clone();
        clone.getMainDocumentPart().getContent().clear();
        log.info("SdtContent: " + sdtBlock.getSdtContent().getContent().get(0).getClass().getName());
        if (sdtBlock.getSdtContent().getContent().size() == 1 && XmlUtils.unwrap(sdtBlock.getSdtContent().getContent().get(0)) instanceof Tc) {
            Tc tc = (Tc)XmlUtils.unwrap(sdtBlock.getSdtContent().getContent().get(0));
            clone.getMainDocumentPart().getContent().addAll(tc.getContent());
        } else {
            clone.getMainDocumentPart().getContent().addAll(sdtBlock.getSdtContent().getContent());
        }
        ((Document)clone.getMainDocumentPart().getJaxbElement()).getBody().setSectPr(null);
        ArrayList<Relationship> relsToRemove = new ArrayList<Relationship>();
        for (Relationship rel : ((Relationships)clone.getMainDocumentPart().getRelationshipsPart().getJaxbElement()).getRelationship()) {
            if (!rel.getType().contains("customXml")) continue;
            relsToRemove.add(rel);
        }
        for (Relationship rel : relsToRemove) {
            clone.getMainDocumentPart().getRelationshipsPart().removeRelationship(rel);
        }
        try {
            ArrayList<WordprocessingMLPackage> wmlPkgList = new ArrayList<WordprocessingMLPackage>();
            wmlPkgList.add(clone);
            Class<?> documentBuilder = Class.forName("com.plutext.merge.DocumentBuilder");
            Method[] methods = documentBuilder.getMethods();
            Method method = null;
            for (int j = 0; j < methods.length; ++j) {
                if (!methods[j].getName().equals("merge")) continue;
                method = methods[j];
                break;
            }
            if (method == null) {
                throw new NoSuchMethodException();
            }
            return (WordprocessingMLPackage)method.invoke(null, wmlPkgList);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.warn("MergeDocx not available; falling back...");
            return clone;
        }
    }

    private void trimParts(WordprocessingMLPackage output, RelationshipsPart rp, boolean modeDelete) throws Docx4JException {
        boolean stripPropertiesParts = true;
        ArrayList<Relationship> deletions = new ArrayList<Relationship>();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) continue;
            try {
                String resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
                resolvedPartUri = resolvedPartUri.substring(1);
                Part part = rp.getPart(r);
                if (part == null) continue;
                if (modeDelete) {
                    deletions.add(r);
                    if (part.getRelationshipsPart() == null) continue;
                    this.trimParts(output, part.getRelationshipsPart(), true);
                    continue;
                }
                if (part instanceof ThemePart || part instanceof FontTablePart) {
                    deletions.add(r);
                    continue;
                }
                if (part instanceof NumberingDefinitionsPart && !this.supportStylesInWordAltChunkProcessing) {
                    deletions.add(r);
                    continue;
                }
                if (part instanceof StyleDefinitionsPart) {
                    if (this.supportStylesInWordAltChunkProcessing) {
                        ((Styles)((StyleDefinitionsPart)part).getContents()).setLatentStyles(null);
                        continue;
                    }
                    deletions.add(r);
                    continue;
                }
                if (part.getPartName().getName().contains("stylesWithEffects")) {
                    deletions.add(r);
                    continue;
                }
                if (stripPropertiesParts && (part instanceof DocPropsExtendedPart || part instanceof DocPropsCorePart || part instanceof DocPropsCustomPart || part instanceof WebSettingsPart || part instanceof DocumentSettingsPart)) {
                    deletions.add(r);
                    continue;
                }
                if (part instanceof MainDocumentPart || part instanceof StyleDefinitionsPart || part instanceof HeaderPart) {
                    if (part.getRelationshipsPart() == null) continue;
                    this.trimParts(output, part.getRelationshipsPart(), false);
                    continue;
                }
                if (part instanceof JaxbCustomXmlDataStoragePart || part instanceof CustomXmlDataStoragePart) {
                    deletions.add(r);
                    continue;
                }
                if (part instanceof GlossaryDocumentPart) {
                    deletions.add(r);
                    this.trimParts(output, part.getRelationshipsPart(), true);
                    continue;
                }
                log.debug(part.getClass().getName());
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships", e);
            }
        }
        for (Relationship r : deletions) {
            rp.removeRelationship(r);
        }
    }

    public static void main(String[] args) throws Docx4JException {
        String input_DOCX = System.getProperty("user.dir") + "/Altered2010.docx";
        WordprocessingMLPackage wordMLPackage = Docx4J.load(new File(input_DOCX));
        UpdateXmlFromDocumentSurface updater = new UpdateXmlFromDocumentSurface(wordMLPackage, false);
        List<CustomXmlPart> parts = updater.updateCustomXmlParts();
        System.out.println(parts.get(0).getXML());
        updater.pkg.save(new File(System.getProperty("user.dir") + "/OUT_UpdateXmlFromDocumentSurface.docx"));
    }

    private static class SdtFinder
    extends TraversalUtil.CallbackImpl {
        List<SdtElement> contentControls = new ArrayList<SdtElement>();

        private SdtFinder() {
        }

        @Override
        public List<Object> apply(Object o) {
            SdtPr sdtPr;
            if (o instanceof SdtElement && (sdtPr = OpenDoPEHandler.getSdtPr(o)) != null) {
                log.debug("Processing " + OpenDoPEHandler.getSdtPr(o).getId().getVal());
                Tag tag = sdtPr.getTag();
                log.debug(tag.getVal());
                HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
                String conditionId = map.get("od:condition");
                String repeatId = map.get("od:repeat");
                String xpathId = map.get("od:xpath");
                String componentId = map.get("od:component");
                if (conditionId != null) {
                    log.debug("Ignoring condition {}", (Object)sdtPr.getId().getVal());
                } else if (repeatId != null) {
                    log.debug("Ignoring repeat {}", (Object)sdtPr.getId().getVal());
                } else if (xpathId != null) {
                    this.contentControls.add((SdtElement)o);
                } else if (componentId != null) {
                    log.warn("TODO: consider component handling {}", (Object)sdtPr.getId().getVal());
                } else if (sdtPr.getDataBinding() != null) {
                    log.debug("Adding non-OpenDoPE databound control {}", (Object)sdtPr.getId().getVal());
                    this.contentControls.add((SdtElement)o);
                } else {
                    log.debug("Ignoring control with tag {}", (Object)sdtPr.getTag().getVal());
                }
            }
            return null;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return !(o instanceof R);
        }
    }
}

