/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.queryresults;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.mariadb.jdbc.internal.protocol.Protocol;
import org.mariadb.jdbc.internal.queryresults.CmdInformation;
import org.mariadb.jdbc.internal.queryresults.resultset.MariaSelectResultSet;

public class CmdInformationBatch
implements CmdInformation {
    private Queue<Long> insertIds;
    private Queue<Integer> updateCounts;
    private int insertIdNumber = 0;
    private int expectedSize;
    private int autoIncrement;
    private boolean hasException;

    public CmdInformationBatch(int expectedSize, int autoIncrement) {
        this.expectedSize = expectedSize;
        this.insertIds = new ConcurrentLinkedQueue<Long>();
        this.updateCounts = new ConcurrentLinkedQueue<Integer>();
        this.autoIncrement = autoIncrement;
    }

    @Override
    public void addErrorStat() {
        this.hasException = true;
        this.updateCounts.add(-3);
    }

    @Override
    public void addResultSetStat() {
        this.updateCounts.add(-1);
    }

    @Override
    public void addSuccessStat(int updateCount, long insertId) {
        this.insertIds.add(insertId);
        this.insertIdNumber += updateCount;
        this.updateCounts.add(updateCount);
    }

    @Override
    public int[] getUpdateCounts() {
        int[] ret = new int[Math.max(this.updateCounts.size(), this.expectedSize)];
        Iterator iterator = this.updateCounts.iterator();
        int pos = 0;
        while (iterator.hasNext()) {
            ret[pos++] = (Integer)iterator.next();
        }
        while (pos < ret.length) {
            ret[pos++] = -3;
        }
        return ret;
    }

    @Override
    public int[] getRewriteUpdateCounts() {
        int[] ret = new int[this.expectedSize];
        Arrays.fill(ret, this.hasException ? -3 : -2);
        return ret;
    }

    @Override
    public int getUpdateCount() {
        Integer updateCount = this.updateCounts.peek();
        return updateCount == null ? -1 : updateCount;
    }

    @Override
    public ResultSet getBatchGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator idIterator = this.insertIds.iterator();
        Iterator updateIterator = this.updateCounts.iterator();
        while (updateIterator.hasNext()) {
            long insertId;
            int updateCount = (Integer)updateIterator.next();
            if (updateCount == -3 || updateCount == -1 || (insertId = ((Long)idIterator.next()).longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return MariaSelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public ResultSet getGeneratedKeys(Protocol protocol) {
        long[] ret = new long[this.insertIdNumber];
        int position = 0;
        Iterator idIterator = this.insertIds.iterator();
        Iterator updateIterator = this.updateCounts.iterator();
        while (updateIterator.hasNext()) {
            long insertId;
            int updateCount = (Integer)updateIterator.next();
            if (updateCount == -3 || updateCount == -1 || (insertId = ((Long)idIterator.next()).longValue()) <= 0L) continue;
            for (int i = 0; i < updateCount; ++i) {
                ret[position++] = insertId + (long)(i * this.autoIncrement);
            }
        }
        return MariaSelectResultSet.createGeneratedData(ret, protocol, true);
    }

    @Override
    public int getCurrentStatNumber() {
        return this.updateCounts.size();
    }

    @Override
    public boolean moreResults() {
        return false;
    }

    @Override
    public boolean isCurrentUpdateCount() {
        return false;
    }
}

