/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.query;

import java.lang.reflect.Method;
import java.util.Map;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.datastore.mapping.model.types.Association;
import org.grails.datastore.mapping.model.types.Embedded;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.orm.hibernate.cfg.AbstractGrailsDomainBinder;
import org.grails.orm.hibernate.cfg.Mapping;
import org.hibernate.Criteria;
import org.hibernate.FetchMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.criterion.Order;
import org.springframework.core.convert.ConversionService;
import org.springframework.util.ReflectionUtils;

public class GrailsHibernateQueryUtils {
    public static void populateArgumentsForCriteria(PersistentEntity entity, Criteria c, Map argMap, ConversionService conversionService, boolean useDefaultMapping) {
        block20: {
            Mapping m;
            block19: {
                int offset;
                Integer maxParam = null;
                Integer offsetParam = null;
                if (argMap.containsKey("max")) {
                    maxParam = (Integer)conversionService.convert(argMap.get("max"), Integer.class);
                }
                if (argMap.containsKey("offset")) {
                    offsetParam = (Integer)conversionService.convert(argMap.get("offset"), Integer.class);
                }
                if (argMap.containsKey("fetchSize")) {
                    c.setFetchSize(((Integer)conversionService.convert(argMap.get("fetchSize"), Integer.class)).intValue());
                }
                if (argMap.containsKey("timeout")) {
                    c.setTimeout(((Integer)conversionService.convert(argMap.get("timeout"), Integer.class)).intValue());
                }
                if (argMap.containsKey("flushMode")) {
                    c.setFlushMode(GrailsHibernateQueryUtils.convertFlushMode(argMap.get("flushMode")));
                }
                if (argMap.containsKey("readOnly")) {
                    c.setReadOnly(ClassUtils.getBooleanFromMap((String)"readOnly", (Map)argMap));
                }
                String orderParam = (String)argMap.get("order");
                Object fetchObj = argMap.get("fetch");
                if (fetchObj instanceof Map) {
                    Map fetch = (Map)fetchObj;
                    for (Object o : fetch.keySet()) {
                        String associationName = (String)o;
                        c.setFetchMode(associationName, GrailsHibernateQueryUtils.getFetchMode(fetch.get(associationName)));
                    }
                }
                int max = maxParam == null ? -1 : maxParam;
                int n = offset = offsetParam == null ? -1 : offsetParam;
                if (max > -1) {
                    c.setMaxResults(max);
                }
                if (offset > -1) {
                    c.setFirstResult(offset);
                }
                if (ClassUtils.getBooleanFromMap((String)"lock", (Map)argMap)) {
                    c.setLockMode(LockMode.PESSIMISTIC_WRITE);
                    c.setCacheable(false);
                } else if (argMap.containsKey("cache")) {
                    c.setCacheable(ClassUtils.getBooleanFromMap((String)"cache", (Map)argMap));
                } else {
                    GrailsHibernateQueryUtils.cacheCriteriaByMapping(entity.getJavaClass(), c);
                }
                Object sortObj = argMap.get("sort");
                if (sortObj == null) break block19;
                boolean ignoreCase = true;
                Object caseArg = argMap.get("ignoreCase");
                if (caseArg instanceof Boolean) {
                    ignoreCase = (Boolean)caseArg;
                }
                if (sortObj instanceof Map) {
                    Map sortMap = (Map)sortObj;
                    for (Object sort : sortMap.keySet()) {
                        String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                        GrailsHibernateQueryUtils.addOrderPossiblyNested(c, entity, (String)sort, order, ignoreCase);
                    }
                } else {
                    String sort = (String)sortObj;
                    String order = "desc".equalsIgnoreCase(orderParam) ? "desc" : "asc";
                    GrailsHibernateQueryUtils.addOrderPossiblyNested(c, entity, sort, order, ignoreCase);
                }
                break block20;
            }
            if (!useDefaultMapping || (m = AbstractGrailsDomainBinder.getMapping(entity.getJavaClass())) == null) break block20;
            Map sortMap = m.getSort().getNamesAndDirections();
            for (Object sort : sortMap.keySet()) {
                String order = "desc".equalsIgnoreCase((String)sortMap.get(sort)) ? "desc" : "asc";
                GrailsHibernateQueryUtils.addOrderPossiblyNested(c, entity, (String)sort, order, true);
            }
        }
    }

    private static void addOrderPossiblyNested(Criteria c, PersistentEntity entity, String sort, String order, boolean ignoreCase) {
        int firstDotPos = sort.indexOf(".");
        if (firstDotPos == -1) {
            GrailsHibernateQueryUtils.addOrder(c, sort, order, ignoreCase);
        } else {
            String sortHead = sort.substring(0, firstDotPos);
            String sortTail = sort.substring(firstDotPos + 1);
            PersistentProperty property = entity.getPropertyByName(sortHead);
            if (property instanceof Embedded) {
                GrailsHibernateQueryUtils.addOrder(c, sort, order, ignoreCase);
            } else if (property instanceof Association) {
                Association a = (Association)property;
                Criteria subCriteria = c.createCriteria(sortHead);
                PersistentEntity associatedEntity = a.getAssociatedEntity();
                Class propertyTargetClass = associatedEntity.getJavaClass();
                GrailsHibernateQueryUtils.cacheCriteriaByMapping(propertyTargetClass, subCriteria);
                GrailsHibernateQueryUtils.addOrderPossiblyNested(subCriteria, associatedEntity, sortTail, order, ignoreCase);
            }
        }
    }

    private static void cacheCriteriaByMapping(Class<?> targetClass, Criteria criteria) {
        Mapping m = AbstractGrailsDomainBinder.getMapping(targetClass);
        if (m != null && m.getCache() != null && m.getCache().getEnabled()) {
            criteria.setCacheable(true);
        }
    }

    private static FlushMode convertFlushMode(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof FlushMode) {
            return (FlushMode)object;
        }
        return FlushModeConverter.valueOf(object.toString());
    }

    private static void addOrder(Criteria c, String sort, String order, boolean ignoreCase) {
        if ("desc".equals(order)) {
            c.addOrder(ignoreCase ? Order.desc((String)sort).ignoreCase() : Order.desc((String)sort));
        } else {
            c.addOrder(ignoreCase ? Order.asc((String)sort).ignoreCase() : Order.asc((String)sort));
        }
    }

    public static FetchMode getFetchMode(Object object) {
        String name;
        String string = name = object != null ? object.toString() : "default";
        if (name.equalsIgnoreCase(FetchMode.JOIN.toString()) || name.equalsIgnoreCase("eager")) {
            return FetchMode.JOIN;
        }
        if (name.equalsIgnoreCase(FetchMode.SELECT.toString()) || name.equalsIgnoreCase("lazy")) {
            return FetchMode.SELECT;
        }
        return FetchMode.DEFAULT;
    }

    static class FlushModeConverter {
        static Method conversionMethod;

        FlushModeConverter() {
        }

        static FlushMode valueOf(String str) {
            try {
                return (FlushMode)conversionMethod.invoke(FlushMode.class, str);
            }
            catch (Throwable t) {
                return FlushMode.COMMIT;
            }
        }

        static {
            try {
                conversionMethod = ReflectionUtils.findMethod(FlushMode.class, (String)"parse", (Class[])new Class[]{String.class});
            }
            catch (Throwable t) {
                conversionMethod = ReflectionUtils.findMethod(FlushMode.class, (String)"valueOf", (Class[])new Class[]{String.class});
            }
            ReflectionUtils.makeAccessible((Method)conversionMethod);
        }
    }
}

