/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import javax.servlet.Servlet;
import javax.servlet.ServletRegistration;
import org.springframework.boot.actuate.autoconfigure.MetricFilterProperties;
import org.springframework.boot.actuate.autoconfigure.MetricRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.MetricsFilter;
import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.actuate.metrics.GaugeService;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.HandlerMapping;

@Configuration
@ConditionalOnBean(value={CounterService.class, GaugeService.class})
@ConditionalOnClass(value={Servlet.class, ServletRegistration.class, OncePerRequestFilter.class, HandlerMapping.class})
@AutoConfigureAfter(value={MetricRepositoryAutoConfiguration.class})
@ConditionalOnProperty(prefix="endpoints.metrics.filter", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={MetricFilterProperties.class})
public class MetricFilterAutoConfiguration {
    private final CounterService counterService;
    private final GaugeService gaugeService;
    private final MetricFilterProperties properties;

    public MetricFilterAutoConfiguration(CounterService counterService, GaugeService gaugeService, MetricFilterProperties properties) {
        this.counterService = counterService;
        this.gaugeService = gaugeService;
        this.properties = properties;
    }

    @Bean
    public MetricsFilter metricsFilter() {
        return new MetricsFilter(this.counterService, this.gaugeService, this.properties);
    }
}

