/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions.fat;

import org.multiverse.api.lifecycle.TxnEvent;
import org.multiverse.stms.gamma.GammaStm;
import org.multiverse.stms.gamma.Listeners;
import org.multiverse.stms.gamma.transactionalobjects.BaseGammaTxnRef;
import org.multiverse.stms.gamma.transactionalobjects.GammaObject;
import org.multiverse.stms.gamma.transactionalobjects.Tranlocal;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.GammaTxnConfig;
import org.multiverse.stms.gamma.transactions.SpeculativeGammaConfiguration;
import org.multiverse.utils.Bugshaker;

public final class FatVariableLengthGammaTxn
extends GammaTxn {
    public Tranlocal[] array;
    public int size = 0;
    public boolean hasReads = false;
    public long localConflictCount;

    public FatVariableLengthGammaTxn(GammaStm stm) {
        this(new GammaTxnConfig(stm));
    }

    public FatVariableLengthGammaTxn(GammaTxnConfig config) {
        super(config, 5);
        this.array = new Tranlocal[config.minimalArrayTreeSize];
    }

    @Override
    public final void commit() {
        if (this.status == 4) {
            return;
        }
        if (this.status != 1 && this.status != 2) {
            throw this.abortCommitOnBadStatus();
        }
        if (this.abortOnly) {
            throw this.abortCommitOnAbortOnly();
        }
        if (this.status == 1) {
            this.notifyListeners(TxnEvent.PrePrepare);
        }
        if (this.size > 0) {
            if (this.hasWrites) {
                Listeners[] listenersArray;
                GammaObject conflictingObject;
                if (this.status == 1 && (conflictingObject = this.doPrepare()) != null) {
                    throw this.abortOnReadWriteConflict(conflictingObject);
                }
                if (this.commitConflict) {
                    this.config.globalConflictCounter.signalConflict();
                }
                if ((listenersArray = this.commitArray()) != null) {
                    Listeners.openAll(listenersArray, this.pool);
                    this.pool.putListenersArray(listenersArray);
                }
            } else {
                this.releaseArray(true);
            }
        }
        this.status = 4;
        this.notifyListeners(TxnEvent.PostCommit);
    }

    private Listeners[] commitArray() {
        Listeners[] listenersArray = null;
        int listenersIndex = 0;
        int itemCount = 0;
        for (int k = 0; k < this.array.length; ++k) {
            Tranlocal tranlocal;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if ((tranlocal = this.array[k]) == null) continue;
            BaseGammaTxnRef owner = tranlocal.owner;
            Listeners listeners = owner.commit(tranlocal, this.pool);
            if (listeners != null) {
                if (listenersArray == null) {
                    listenersArray = this.pool.takeListenersArray(this.size - itemCount);
                }
                listenersArray[listenersIndex] = listeners;
                ++listenersIndex;
            }
            this.pool.put(tranlocal);
            ++itemCount;
        }
        return listenersArray;
    }

    private void releaseArray(boolean success) {
        for (int k = 0; k < this.array.length; ++k) {
            Tranlocal tranlocal = this.array[k];
            if (tranlocal == null) continue;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            this.array[k] = null;
            if (success) {
                tranlocal.owner.releaseAfterReading(tranlocal, this.pool);
            } else {
                tranlocal.owner.releaseAfterFailure(tranlocal, this.pool);
            }
            this.pool.put(tranlocal);
        }
    }

    @Override
    public final void prepare() {
        GammaObject conflictingObject;
        if (this.status == 2) {
            return;
        }
        if (this.status != 1) {
            throw this.abortPrepareOnBadStatus();
        }
        if (this.abortOnly) {
            throw this.abortPrepareOnAbortOnly();
        }
        this.notifyListeners(TxnEvent.PrePrepare);
        if (this.hasWrites && (conflictingObject = this.doPrepare()) != null) {
            throw this.abortOnReadWriteConflict(conflictingObject);
        }
        this.status = 2;
    }

    private GammaObject doPrepare() {
        if (this.skipPrepare()) {
            return null;
        }
        for (int k = 0; k < this.array.length; ++k) {
            BaseGammaTxnRef owner;
            Tranlocal tranlocal;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if ((tranlocal = this.array[k]) == null || (owner = tranlocal.owner).prepare(this, tranlocal)) continue;
            return owner;
        }
        return null;
    }

    @Override
    public final void abort() {
        if (this.status == 3) {
            return;
        }
        if (this.status == 4) {
            throw this.failAbortOnAlreadyCommitted();
        }
        if (this.size > 0) {
            this.releaseArray(false);
        }
        this.status = 3;
        this.notifyListeners(TxnEvent.PostAbort);
    }

    @Override
    public final Tranlocal locate(BaseGammaTxnRef o) {
        if (this.status != 1) {
            throw this.abortLocateOnBadStatus(o);
        }
        if (o == null) {
            throw this.abortLocateOnNullArgument();
        }
        return this.getRefTranlocal(o);
    }

    @Override
    public final Tranlocal getRefTranlocal(BaseGammaTxnRef ref) {
        int indexOf = this.indexOf(ref, ref.identityHashCode());
        return indexOf == -1 ? null : this.array[indexOf];
    }

    @Override
    public final void retry() {
        if (this.status != 1) {
            throw this.abortRetryOnBadStatus();
        }
        if (!this.config.isBlockingAllowed()) {
            throw this.abortRetryOnNoBlockingAllowed();
        }
        if (this.size == 0) {
            throw this.abortRetryOnNoRetryPossible();
        }
        this.retryListener.reset();
        long listenerEra = this.retryListener.getEra();
        boolean furtherRegistrationNeeded = true;
        boolean atLeastOneRegistration = false;
        for (int k = 0; k < this.array.length; ++k) {
            Tranlocal tranlocal = this.array[k];
            if (tranlocal == null) continue;
            this.array[k] = null;
            BaseGammaTxnRef owner = tranlocal.owner;
            if (furtherRegistrationNeeded) {
                switch (owner.registerChangeListener(this.retryListener, tranlocal, this.pool, listenerEra)) {
                    case 0: {
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 1: {
                        furtherRegistrationNeeded = false;
                        atLeastOneRegistration = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            owner.releaseAfterFailure(tranlocal, this.pool);
            this.pool.put(tranlocal);
        }
        this.status = 3;
        if (!atLeastOneRegistration) {
            throw this.abortRetryOnNoRetryPossible();
        }
        throw this.newRetryError();
    }

    @Override
    public final boolean softReset() {
        if (this.attempt >= this.config.getMaxRetries()) {
            return false;
        }
        this.status = 1;
        this.hasReads = false;
        this.hasWrites = false;
        this.size = 0;
        this.abortOnly = false;
        ++this.attempt;
        this.commitConflict = false;
        this.evaluatingCommute = false;
        if (this.listeners != null) {
            this.listeners.clear();
            this.pool.putArrayList(this.listeners);
            this.listeners = null;
        }
        return true;
    }

    @Override
    public final void hardReset() {
        this.status = 1;
        this.hasReads = false;
        this.hasWrites = false;
        this.size = 0;
        this.abortOnly = false;
        this.attempt = 1;
        this.remainingTimeoutNs = this.config.timeoutNs;
        if (this.array != null) {
            this.pool.putTranlocalArray(this.array);
        }
        this.array = this.pool.takeTranlocalArray(this.config.minimalArrayTreeSize);
        SpeculativeGammaConfiguration speculativeConfig = this.config.speculativeConfiguration.get();
        this.richmansMansConflictScan = speculativeConfig.richMansConflictScanRequired;
        this.commitConflict = false;
        this.evaluatingCommute = false;
        if (this.listeners != null) {
            this.listeners.clear();
            this.pool.putArrayList(this.listeners);
            this.listeners = null;
        }
    }

    @Override
    public void initLocalConflictCounter() {
        if (this.richmansMansConflictScan && !this.hasReads) {
            this.localConflictCount = this.config.globalConflictCounter.count();
        }
    }

    @Override
    public final boolean isReadConsistent(Tranlocal justAdded) {
        if (!this.hasReads) {
            return true;
        }
        if (this.config.readLockModeAsInt > 0) {
            return true;
        }
        if (this.config.inconsistentReadAllowed) {
            return true;
        }
        if (this.richmansMansConflictScan) {
            long conflictCount;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            if (this.localConflictCount == (conflictCount = this.config.globalConflictCounter.count())) {
                return true;
            }
            this.localConflictCount = conflictCount;
        } else if (this.size > this.config.maximumPoorMansConflictScanLength) {
            throw this.abortOnRichmanConflictScanDetected();
        }
        for (int k = 0; k < this.array.length; ++k) {
            Tranlocal tranlocal;
            boolean skip;
            if (SHAKE_BUGS) {
                Bugshaker.shakeBugs();
            }
            boolean bl = skip = (tranlocal = this.array[k]) == null || !this.richmansMansConflictScan && justAdded == tranlocal;
            if (skip || !tranlocal.owner.hasReadConflict(tranlocal)) continue;
            return false;
        }
        return true;
    }

    public final float getUsage() {
        return (float)this.size * 1.0f / (float)this.array.length;
    }

    public final int size() {
        return this.size;
    }

    public final int indexOf(BaseGammaTxnRef ref, int hash) {
        int jump = 0;
        boolean goLeft = true;
        do {
            int offset;
            int index;
            Tranlocal current;
            if ((current = this.array[index = (hash + (offset = goLeft ? -jump : jump)) % this.array.length]) == null || current.owner == null) {
                return -1;
            }
            if (current.owner == ref) {
                return index;
            }
            int currentHash = current.owner.identityHashCode();
            goLeft = currentHash > hash;
        } while ((jump = jump == 0 ? 1 : jump * 2) < this.array.length);
        return -1;
    }

    public final void attach(Tranlocal tranlocal, int hash) {
        int jump = 0;
        boolean goLeft = true;
        do {
            int offset;
            int index;
            Tranlocal current;
            if ((current = this.array[index = (hash + (offset = goLeft ? -jump : jump)) % this.array.length]) == null) {
                this.array[index] = tranlocal;
                return;
            }
            int currentHash = current.owner.identityHashCode();
            goLeft = currentHash > hash;
        } while ((jump = jump == 0 ? 1 : jump * 2) < this.array.length);
        this.expand();
        this.attach(tranlocal, hash);
    }

    private void expand() {
        Tranlocal[] oldArray = this.array;
        int newSize = oldArray.length * 2;
        this.array = this.pool.takeTranlocalArray(newSize);
        for (int k = 0; k < oldArray.length; ++k) {
            Tranlocal tranlocal = oldArray[k];
            if (tranlocal == null) continue;
            oldArray[k] = null;
            this.attach(tranlocal, tranlocal.owner.identityHashCode());
        }
        this.pool.putTranlocalArray(oldArray);
    }
}

