/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameter;
import org.mariadb.jdbc.internal.packet.dao.parameters.ParameterWriter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class ByteArrayParameter
extends NotLongDataParameter
implements Cloneable {
    private byte[] bytes;
    private boolean noBackslashEscapes;

    public ByteArrayParameter(byte[] bytes, boolean noBackslashEscapes) {
        this.bytes = bytes;
        this.noBackslashEscapes = noBackslashEscapes;
    }

    @Override
    public void writeTo(PacketOutputStream os) throws IOException {
        ParameterWriter.write((OutputStream)os, this.bytes, this.noBackslashEscapes);
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) throws IOException {
        ParameterWriter.writeUnsafe(os, this.bytes, this.noBackslashEscapes);
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return this.bytes.length * 2;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeByteArrayLength(this.bytes);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.VARSTRING;
    }

    @Override
    public String toString() {
        if (this.bytes.length > 1024) {
            return "<bytearray:" + new String(Arrays.copyOfRange(this.bytes, 0, 1024)) + "...>";
        }
        return "<bytearray:" + new String(this.bytes) + ">";
    }
}

