/*
 * Decompiled with CFR 0.152.
 */
package liquibase.datatype.core;

import java.util.Locale;
import liquibase.change.core.LoadDataChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.FirebirdDatabase;
import liquibase.database.core.InformixDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.datatype.DataTypeInfo;
import liquibase.datatype.DatabaseDataType;
import liquibase.datatype.LiquibaseDataType;
import liquibase.exception.DatabaseException;
import liquibase.statement.DatabaseFunction;

@DataTypeInfo(name="smallint", aliases={"java.sql.Types.SMALLINT", "int2"}, minParameters=0, maxParameters=1, priority=1)
public class SmallIntType
extends LiquibaseDataType {
    private boolean autoIncrement;

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    @Override
    public DatabaseDataType toDatabaseDataType(Database database) {
        if (database instanceof MSSQLDatabase) {
            return new DatabaseDataType(database.escapeDataTypeName("smallint"));
        }
        if (database instanceof MySQLDatabase) {
            DatabaseDataType type = new DatabaseDataType("SMALLINT");
            type.addAdditionalInformation(this.getAdditionalInformation());
            return type;
        }
        if (database instanceof AbstractDb2Database || database instanceof DerbyDatabase || database instanceof FirebirdDatabase || database instanceof InformixDatabase) {
            return new DatabaseDataType("SMALLINT");
        }
        if (database instanceof OracleDatabase) {
            return new DatabaseDataType("NUMBER", 5);
        }
        if (database instanceof PostgresDatabase) {
            if (this.isAutoIncrement()) {
                int majorVersion = 9;
                try {
                    majorVersion = database.getDatabaseMajorVersion();
                }
                catch (DatabaseException databaseException) {
                    // empty catch block
                }
                if (majorVersion < 10) {
                    return new DatabaseDataType("SMALLSERIAL");
                }
            }
            return new DatabaseDataType("SMALLINT");
        }
        return super.toDatabaseDataType(database);
    }

    @Override
    public String objectToSql(Object value, Database database) {
        if (value == null || "null".equals(value.toString().toLowerCase(Locale.US))) {
            return null;
        }
        if (value instanceof DatabaseFunction) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? "1" : "0";
        }
        return this.formatNumber(value.toString());
    }

    @Override
    public LoadDataChange.LOAD_DATA_TYPE getLoadTypeName() {
        return LoadDataChange.LOAD_DATA_TYPE.NUMERIC;
    }
}

