/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.RuntimeEnvironment;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.SkippedChangeSetVisitor;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.logging.Logger;
import liquibase.logging.LoggerContext;
import liquibase.util.StringUtils;

public class ChangeLogIterator {
    private static final Logger LOG = LogService.getLog(ChangeLogIterator.class);
    private DatabaseChangeLog databaseChangeLog;
    private List<ChangeSetFilter> changeSetFilters;
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_FIND_EXECUTOR = coreBundle.getString("no.executor.found");
    private Set<String> seenChangeSets = new HashSet<String>();

    public ChangeLogIterator(DatabaseChangeLog databaseChangeLog, ChangeSetFilter ... changeSetFilters) {
        this.databaseChangeLog = databaseChangeLog;
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    public ChangeLogIterator(List<RanChangeSet> changeSetList, DatabaseChangeLog changeLog, ChangeSetFilter ... changeSetFilters) {
        final ArrayList<ChangeSet> changeSets = new ArrayList<ChangeSet>();
        for (RanChangeSet ranChangeSet : changeSetList) {
            ChangeSet changeSet = changeLog.getChangeSet(ranChangeSet);
            if (changeSet == null) continue;
            if (changeLog.ignoreClasspathPrefix()) {
                changeSet.setFilePath(ranChangeSet.getChangeLog());
            }
            changeSets.add(changeSet);
        }
        this.databaseChangeLog = new DatabaseChangeLog(){

            @Override
            public List<ChangeSet> getChangeSets() {
                return changeSets;
            }

            @Override
            public String toString() {
                return "";
            }
        };
        this.changeSetFilters = Arrays.asList(changeSetFilters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(ChangeSetVisitor visitor, RuntimeEnvironment env) throws LiquibaseException {
        this.databaseChangeLog.setRuntimeEnvironment(env);
        try (LoggerContext ignored = LogService.pushContext("databaseChangeLog", this.databaseChangeLog);){
            ArrayList<ChangeSet> changeSetList = new ArrayList<ChangeSet>(this.databaseChangeLog.getChangeSets());
            if (visitor.getDirection().equals((Object)ChangeSetVisitor.Direction.REVERSE)) {
                Collections.reverse(changeSetList);
            }
            for (ChangeSet changeSet : changeSetList) {
                boolean shouldVisit = true;
                HashSet<ChangeSetFilterResult> reasonsAccepted = new HashSet<ChangeSetFilterResult>();
                HashSet<ChangeSetFilterResult> reasonsDenied = new HashSet<ChangeSetFilterResult>();
                if (this.changeSetFilters != null) {
                    for (ChangeSetFilter filter : this.changeSetFilters) {
                        ChangeSetFilterResult acceptsResult = filter.accepts(changeSet);
                        if (acceptsResult.isAccepted()) {
                            reasonsAccepted.add(acceptsResult);
                            continue;
                        }
                        shouldVisit = false;
                        reasonsDenied.add(acceptsResult);
                        break;
                    }
                }
                LoggerContext ignored2 = LogService.pushContext("changeSet", changeSet);
                Throwable throwable = null;
                try {
                    if (shouldVisit && !this.alreadySaw(changeSet)) {
                        this.validateChangeSetExecutor(changeSet, env);
                        visitor.visit(changeSet, this.databaseChangeLog, env.getTargetDatabase(), reasonsAccepted);
                        this.markSeen(changeSet);
                        continue;
                    }
                    if (!(visitor instanceof SkippedChangeSetVisitor)) continue;
                    ((SkippedChangeSetVisitor)((Object)visitor)).skipped(changeSet, this.databaseChangeLog, env.getTargetDatabase(), reasonsDenied);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored2 == null) continue;
                    if (throwable != null) {
                        try {
                            ignored2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored2.close();
                }
            }
        }
        finally {
            this.databaseChangeLog.setRuntimeEnvironment(null);
        }
    }

    private void validateChangeSetExecutor(ChangeSet changeSet, RuntimeEnvironment env) throws LiquibaseException {
        Executor executor;
        if (changeSet.getRunWith() == null) {
            return;
        }
        String executorName = changeSet.getRunWith();
        try {
            executor = ExecutorService.getInstance().getExecutor(executorName, env.getTargetDatabase());
        }
        catch (UnexpectedLiquibaseException ule) {
            String message = String.format(MSG_COULD_NOT_FIND_EXECUTOR, executorName, changeSet.toString());
            LOG.severe(LogType.LOG, message);
            throw new LiquibaseException(message);
        }
        executor.modifyChangeSet(changeSet);
        ValidationErrors errors = executor.validate(changeSet);
        if (errors.hasErrors()) {
            String message = errors.toString();
            LOG.severe(LogType.LOG, message);
            throw new LiquibaseException(message);
        }
    }

    protected void markSeen(ChangeSet changeSet) {
        if (changeSet.key == null) {
            changeSet.key = this.createKey(changeSet);
        }
        this.seenChangeSets.add(changeSet.key);
    }

    protected String createKey(ChangeSet changeSet) {
        Labels labels = changeSet.getLabels();
        ContextExpression contexts = changeSet.getContexts();
        return changeSet.toString(true) + ":" + (labels == null ? null : labels.toString()) + ":" + (contexts == null ? null : contexts.toString()) + ":" + StringUtils.join(changeSet.getDbmsSet(), ",");
    }

    protected boolean alreadySaw(ChangeSet changeSet) {
        if (changeSet.key == null) {
            changeSet.key = this.createKey(changeSet);
        }
        return this.seenChangeSets.contains(changeSet.key);
    }

    public List<ChangeSetFilter> getChangeSetFilters() {
        return Collections.unmodifiableList(this.changeSetFilters);
    }
}

