/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.formattedsql;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Labels;
import liquibase.change.AbstractSQLChange;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.parser.ChangeLogParser;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.precondition.core.SqlPrecondition;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.UtfBomAwareReader;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class FormattedSqlChangeLogParser
implements ChangeLogParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        BufferedReader reader = null;
        try {
            if (changeLogFile.endsWith(".sql")) {
                InputStream fileStream = this.openChangeLogFile(changeLogFile, resourceAccessor);
                if (fileStream == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                reader = new BufferedReader(new UtfBomAwareReader(fileStream));
                String line = reader.readLine();
                boolean e2 = line != null && line.matches("\\-\\-\\s*liquibase formatted.*");
                return e2;
            }
            boolean fileStream = false;
            return fileStream;
        }
        catch (IOException e3) {
            LogService.getLog(this.getClass()).debug(LogType.LOG, "Exception reading " + changeLogFile, e3);
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e4) {
                    LogService.getLog(this.getClass()).debug(LogType.LOG, "Exception closing " + changeLogFile, e4);
                }
            }
        }
    }

    @Override
    public int getPriority() {
        return 6;
    }

    @Override
    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog changeLog = new DatabaseChangeLog();
        changeLog.setChangeLogParameters(changeLogParameters);
        changeLog.setPhysicalFilePath(physicalChangeLogLocation);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new UtfBomAwareReader(this.openChangeLogFile(physicalChangeLogLocation, resourceAccessor)));
            StringBuffer currentSql = new StringBuffer();
            StringBuffer currentRollbackSql = new StringBuffer();
            ChangeSet changeSet = null;
            AbstractSQLChange change = null;
            Pattern changeLogPattern = Pattern.compile("\\-\\-\\s*liquibase formatted.*", 2);
            Pattern changeSetPattern = Pattern.compile("\\-\\-[\\s]*changeset\\s+([^:]+):(\\S+).*", 2);
            Pattern rollbackPattern = Pattern.compile("\\s*\\-\\-[\\s]*rollback (.*)", 2);
            Pattern preconditionsPattern = Pattern.compile("\\s*\\-\\-[\\s]*preconditions(.*)", 2);
            Pattern preconditionPattern = Pattern.compile("\\s*\\-\\-[\\s]*precondition\\-([a-zA-Z0-9-]+) (.*)", 2);
            Pattern stripCommentsPattern = Pattern.compile(".*stripComments:(\\w+).*", 2);
            Pattern splitStatementsPattern = Pattern.compile(".*splitStatements:(\\w+).*", 2);
            Pattern rollbackSplitStatementsPattern = Pattern.compile(".*rollbackSplitStatements:(\\w+).*", 2);
            Pattern endDelimiterPattern = Pattern.compile(".*endDelimiter:(\\S*).*", 2);
            Pattern rollbackEndDelimiterPattern = Pattern.compile(".*rollbackEndDelimiter:(\\S*).*", 2);
            Pattern commentPattern = Pattern.compile("\\-\\-[\\s]*comment:? (.*)", 2);
            Pattern validCheckSumPattern = Pattern.compile("\\-\\-[\\s]*validCheckSum:? (.*)", 2);
            Pattern ignoreLinesPattern = Pattern.compile("\\-\\-[\\s]*ignoreLines:(\\w+)", 2);
            Pattern runWithPattern = Pattern.compile(".*runWith:(\\w+).*", 2);
            Pattern runOnChangePattern = Pattern.compile(".*runOnChange:(\\w+).*", 2);
            Pattern runAlwaysPattern = Pattern.compile(".*runAlways:(\\w+).*", 2);
            Pattern contextPattern = Pattern.compile(".*context:(\".*\"|\\S*).*", 2);
            Pattern logicalFilePathPattern = Pattern.compile(".*logicalFilePath:(\\S*).*", 2);
            Pattern labelsPattern = Pattern.compile(".*labels:(\\S*).*", 2);
            Pattern runInTransactionPattern = Pattern.compile(".*runInTransaction:(\\w+).*", 2);
            Pattern dbmsPattern = Pattern.compile(".*dbms:([^,][\\w!,]+).*", 2);
            Pattern failOnErrorPattern = Pattern.compile(".*failOnError:(\\w+).*", 2);
            Pattern onFailPattern = Pattern.compile(".*onFail:(\\w+).*", 2);
            Pattern onErrorPattern = Pattern.compile(".*onError:(\\w+).*", 2);
            Pattern onUpdateSqlPattern = Pattern.compile(".*onUpdateSQL:(\\w+).*", 2);
            Matcher rollbackSplitStatementsPatternMatcher = null;
            boolean rollbackSplitStatements = true;
            String rollbackEndDelimiter = null;
            while ((line = reader.readLine()) != null) {
                Matcher ignoreLinesMatcher;
                Matcher changeLogPatterMatcher = changeLogPattern.matcher(line);
                if (changeLogPatterMatcher.matches()) {
                    Matcher logicalFilePathMatcher = logicalFilePathPattern.matcher(line);
                    changeLog.setLogicalFilePath(this.parseString(logicalFilePathMatcher));
                }
                if ((ignoreLinesMatcher = ignoreLinesPattern.matcher(line)).matches()) {
                    if ("start".equals(ignoreLinesMatcher.group(1))) {
                        while (!((line = reader.readLine()) == null || (ignoreLinesMatcher = ignoreLinesPattern.matcher(line)).matches() && "end".equals(ignoreLinesMatcher.group(1)))) {
                        }
                        continue;
                    }
                    try {
                        for (long ignoreCount = Long.parseLong(ignoreLinesMatcher.group(1)); ignoreCount > 0L && (line = reader.readLine()) != null; --ignoreCount) {
                        }
                        continue;
                    }
                    catch (NullPointerException | NumberFormatException nfe) {
                        throw new ChangeLogParseException("Unknown ignoreLines syntax in changeset " + changeSet.toString(false));
                    }
                }
                Matcher changeSetPatternMatcher = changeSetPattern.matcher(line);
                if (changeSetPatternMatcher.matches()) {
                    String finalCurrentSql = changeLogParameters.expandExpressions(StringUtils.trimToNull(currentSql.toString()), changeLog);
                    if (changeSet != null) {
                        if (finalCurrentSql == null) {
                            throw new ChangeLogParseException("No SQL for changeset " + changeSet.toString(false));
                        }
                        change.setSql(finalCurrentSql);
                        if (StringUtils.trimToNull(currentRollbackSql.toString()) != null) {
                            if (currentRollbackSql.toString().trim().toLowerCase().matches("^not required.*")) {
                                changeSet.addRollbackChange(new EmptyChange());
                            } else {
                                RawSQLChange rollbackChange = new RawSQLChange();
                                rollbackChange.setSql(changeLogParameters.expandExpressions(currentRollbackSql.toString(), changeLog));
                                if (rollbackSplitStatementsPatternMatcher.matches()) {
                                    rollbackChange.setSplitStatements(rollbackSplitStatements);
                                }
                                if (rollbackEndDelimiter != null) {
                                    rollbackChange.setEndDelimiter(rollbackEndDelimiter);
                                }
                                changeSet.addRollbackChange(rollbackChange);
                            }
                        }
                    }
                    Matcher stripCommentsPatternMatcher = stripCommentsPattern.matcher(line);
                    Matcher splitStatementsPatternMatcher = splitStatementsPattern.matcher(line);
                    Matcher runWithMatcher = runWithPattern.matcher(line);
                    rollbackSplitStatementsPatternMatcher = rollbackSplitStatementsPattern.matcher(line);
                    Matcher endDelimiterPatternMatcher = endDelimiterPattern.matcher(line);
                    Matcher rollbackEndDelimiterPatternMatcher = rollbackEndDelimiterPattern.matcher(line);
                    Matcher logicalFilePathMatcher = logicalFilePathPattern.matcher(line);
                    Matcher runOnChangePatternMatcher = runOnChangePattern.matcher(line);
                    Matcher runAlwaysPatternMatcher = runAlwaysPattern.matcher(line);
                    Matcher contextPatternMatcher = contextPattern.matcher(line);
                    Matcher labelsPatternMatcher = labelsPattern.matcher(line);
                    Matcher runInTransactionPatternMatcher = runInTransactionPattern.matcher(line);
                    Matcher dbmsPatternMatcher = dbmsPattern.matcher(line);
                    Matcher failOnErrorPatternMatcher = failOnErrorPattern.matcher(line);
                    boolean stripComments = this.parseBoolean(stripCommentsPatternMatcher, changeSet, true);
                    boolean splitStatements = this.parseBoolean(splitStatementsPatternMatcher, changeSet, true);
                    rollbackSplitStatements = this.parseBoolean(rollbackSplitStatementsPatternMatcher, changeSet, true);
                    boolean runOnChange = this.parseBoolean(runOnChangePatternMatcher, changeSet, false);
                    boolean runAlways = this.parseBoolean(runAlwaysPatternMatcher, changeSet, false);
                    boolean runInTransaction = this.parseBoolean(runInTransactionPatternMatcher, changeSet, true);
                    boolean failOnError = this.parseBoolean(failOnErrorPatternMatcher, changeSet, true);
                    String runWith = this.parseString(runWithMatcher);
                    String endDelimiter = this.parseString(endDelimiterPatternMatcher);
                    rollbackEndDelimiter = this.parseString(rollbackEndDelimiterPatternMatcher);
                    String context = StringUtils.trimToNull(StringUtils.trimToEmpty(this.parseString(contextPatternMatcher)).replaceFirst("^\"", "").replaceFirst("\"$", ""));
                    String labels = this.parseString(labelsPatternMatcher);
                    String logicalFilePath = this.parseString(logicalFilePathMatcher);
                    if (logicalFilePath == null || "".equals(logicalFilePath)) {
                        logicalFilePath = changeLog.getLogicalFilePath();
                    }
                    String dbms = this.parseString(dbmsPatternMatcher);
                    changeSet = new ChangeSet(changeSetPatternMatcher.group(2), changeSetPatternMatcher.group(1), runAlways, runOnChange, logicalFilePath, context, dbms, runWith, runInTransaction, changeLog.getObjectQuotingStrategy(), changeLog);
                    changeSet.setLabels(new Labels(labels));
                    changeSet.setFailOnError(failOnError);
                    changeLog.addChangeSet(changeSet);
                    change = new RawSQLChange();
                    change.setSql(finalCurrentSql);
                    change.setResourceAccessor(resourceAccessor);
                    if (splitStatementsPatternMatcher.matches()) {
                        change.setSplitStatements(splitStatements);
                    }
                    change.setStripComments(stripComments);
                    change.setEndDelimiter(endDelimiter);
                    changeSet.addChange(change);
                    currentSql = new StringBuffer();
                    currentRollbackSql = new StringBuffer();
                    continue;
                }
                if (changeSet == null) continue;
                Matcher commentMatcher = commentPattern.matcher(line);
                Matcher rollbackMatcher = rollbackPattern.matcher(line);
                Matcher preconditionsMatcher = preconditionsPattern.matcher(line);
                Matcher preconditionMatcher = preconditionPattern.matcher(line);
                Matcher validCheckSumMatcher = validCheckSumPattern.matcher(line);
                if (commentMatcher.matches()) {
                    if (commentMatcher.groupCount() != 1) continue;
                    changeSet.setComments(commentMatcher.group(1));
                    continue;
                }
                if (validCheckSumMatcher.matches()) {
                    if (validCheckSumMatcher.groupCount() != 1) continue;
                    changeSet.addValidCheckSum(validCheckSumMatcher.group(1));
                    continue;
                }
                if (rollbackMatcher.matches()) {
                    if (rollbackMatcher.groupCount() != 1) continue;
                    currentRollbackSql.append(rollbackMatcher.group(1)).append(System.lineSeparator());
                    continue;
                }
                if (preconditionsMatcher.matches()) {
                    if (preconditionsMatcher.groupCount() != 1) continue;
                    String body = preconditionsMatcher.group(1);
                    Matcher onFailMatcher = onFailPattern.matcher(body);
                    Matcher onErrorMatcher = onErrorPattern.matcher(body);
                    Matcher onUpdateSqlMatcher = onUpdateSqlPattern.matcher(body);
                    PreconditionContainer pc = new PreconditionContainer();
                    pc.setOnFail(StringUtils.trimToNull(this.parseString(onFailMatcher)));
                    pc.setOnError(StringUtils.trimToNull(this.parseString(onErrorMatcher)));
                    pc.setOnSqlOutput(StringUtils.trimToNull(this.parseString(onUpdateSqlMatcher)));
                    changeSet.setPreconditions(pc);
                    continue;
                }
                if (preconditionMatcher.matches()) {
                    String name;
                    if (changeSet.getPreconditions() == null) {
                        changeSet.setPreconditions(new PreconditionContainer());
                    }
                    if (preconditionMatcher.groupCount() != 2 || (name = StringUtils.trimToNull(preconditionMatcher.group(1))) == null) continue;
                    String body = preconditionMatcher.group(2).trim();
                    if ("sql-check".equals(name)) {
                        changeSet.getPreconditions().addNestedPrecondition(this.parseSqlCheckCondition(changeLogParameters.expandExpressions(StringUtils.trimToNull(body), changeSet.getChangeLog())));
                        continue;
                    }
                    throw new ChangeLogParseException("The '" + name + "' precondition type is not supported.");
                }
                currentSql.append(line).append(System.lineSeparator());
            }
            if (changeSet != null) {
                change.setSql(changeLogParameters.expandExpressions(StringUtils.trimToNull(currentSql.toString()), changeSet.getChangeLog()));
                if (change.getEndDelimiter() == null && StringUtils.trimToEmpty(((RawSQLChange)change).getSql()).endsWith("\n/")) {
                    change.setEndDelimiter("\n/$");
                }
                if (StringUtils.trimToNull(currentRollbackSql.toString()) != null) {
                    if (currentRollbackSql.toString().trim().toLowerCase().matches("^not required.*")) {
                        changeSet.addRollbackChange(new EmptyChange());
                    } else {
                        RawSQLChange rollbackChange = new RawSQLChange();
                        rollbackChange.setSql(changeLogParameters.expandExpressions(currentRollbackSql.toString(), changeSet.getChangeLog()));
                        if (rollbackSplitStatementsPatternMatcher.matches()) {
                            rollbackChange.setSplitStatements(rollbackSplitStatements);
                        }
                        if (rollbackEndDelimiter != null) {
                            rollbackChange.setEndDelimiter(rollbackEndDelimiter);
                        }
                        changeSet.addRollbackChange(rollbackChange);
                    }
                }
            }
        }
        catch (IOException e2) {
            throw new ChangeLogParseException(e2);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return changeLog;
    }

    private SqlPrecondition parseSqlCheckCondition(String body) throws ChangeLogParseException {
        Pattern[] patterns;
        for (Pattern pattern : patterns = new Pattern[]{Pattern.compile("^(?:expectedResult:)?(\\w+) (.*)", 2), Pattern.compile("^(?:expectedResult:)?'([^']+)' (.*)", 2), Pattern.compile("^(?:expectedResult:)?\"([^\"]+)\" (.*)", 2)}) {
            Matcher matcher = pattern.matcher(body);
            if (!matcher.matches() || matcher.groupCount() != 2) continue;
            SqlPrecondition p2 = new SqlPrecondition();
            p2.setExpectedResult(matcher.group(1));
            p2.setSql(matcher.group(2));
            return p2;
        }
        throw new ChangeLogParseException("Could not parse a SqlCheck precondition from '" + body + "'.");
    }

    private String parseString(Matcher matcher) {
        String endDelimiter = null;
        if (matcher.matches()) {
            endDelimiter = matcher.group(1);
        }
        return endDelimiter;
    }

    private boolean parseBoolean(Matcher matcher, ChangeSet changeSet, boolean defaultValue) throws ChangeLogParseException {
        boolean stripComments = defaultValue;
        if (matcher.matches()) {
            try {
                stripComments = Boolean.parseBoolean(matcher.group(1));
            }
            catch (Exception e2) {
                throw new ChangeLogParseException("Cannot parse " + changeSet + " " + matcher.toString().replaceAll("\\.*", "") + " as a boolean");
            }
        }
        return stripComments;
    }

    protected InputStream openChangeLogFile(String physicalChangeLogLocation, ResourceAccessor resourceAccessor) throws IOException {
        InputStream resourceAsStream = StreamUtil.singleInputStream(physicalChangeLogLocation, resourceAccessor);
        if (resourceAsStream == null) {
            File physicalChangeLogFile = new File(physicalChangeLogLocation);
            throw new IOException("File does not exist: " + physicalChangeLogFile.getAbsolutePath());
        }
        return resourceAsStream;
    }
}

