/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.openxmlformats.styles.paragraph;

import fr.opensagres.poi.xwpf.converter.core.openxmlformats.styles.ValueProviderHelper;
import fr.opensagres.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTbl;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;

public abstract class AbstractParagraphValueProvider<Value> {
    public Value getValue(CTP paragraph, CTTbl parentTable, XWPFStylesDocument document) {
        CTTblPr tblPr;
        Value value = null;
        CTPPr pPr = paragraph.getPPr();
        if (pPr != null) {
            value = this.getValue((CTPPrBase)pPr, document);
            if (value != null) {
                return value;
            }
            value = this.getValueFromStyle(pPr.getPStyle(), document);
            if (value != null) {
                return value;
            }
        }
        if (parentTable != null && (tblPr = parentTable.getTblPr()) != null && (value = (Value)this.getValueFromStyle(tblPr.getTblStyle(), document)) != null) {
            return value;
        }
        value = this.getValueFromStyle(document.getDefaultParagraphStyle(), document);
        if (value != null) {
            return value;
        }
        CTDocDefaults docDefaults = document.getDocDefaults();
        if (docDefaults == null) {
            return null;
        }
        value = this.getValueFromDocDefaultsStyle(docDefaults, document);
        if (value != null) {
            return value;
        }
        return null;
    }

    private Value getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument document) {
        return this.getValue(this.getCTPPr(docDefaults), document);
    }

    public CTPPrBase getCTPPr(CTDocDefaults docDefaults) {
        CTPPrDefault prDefault = docDefaults.getPPrDefault();
        if (prDefault == null) {
            return null;
        }
        return prDefault.getPPr();
    }

    private Value getValueFromStyle(CTString styleId, XWPFStylesDocument document) {
        if (styleId == null) {
            return null;
        }
        String key = ValueProviderHelper.getKey(this.getClass(), document, styleId.getVal(), null);
        Object v = document.getValue(key);
        if (v != null && v != XWPFStylesDocument.EMPTY_VALUE) {
            return (Value)v;
        }
        CTStyle style = document.getStyle(styleId);
        Value value = this.getValueFromStyle(style, document);
        if (value == null) {
            document.setValue(key, XWPFStylesDocument.EMPTY_VALUE);
            return null;
        }
        document.setValue(key, value);
        if (value.equals(XWPFStylesDocument.EMPTY_VALUE)) {
            return null;
        }
        return value;
    }

    private Value getValueFromStyle(CTStyle style, XWPFStylesDocument document) {
        if (style != null) {
            Value value = this.getValue((CTPPrBase)style.getPPr(), document);
            if (value != null) {
                return value;
            }
            return this.getValueFromStyle(style.getBasedOn(), document);
        }
        return null;
    }

    public abstract Value getValue(CTPPrBase var1, XWPFStylesDocument var2);
}

