/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.common.writer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractSimpleWriter;
import org.docx4j.model.fields.FieldValueException;
import org.docx4j.model.fields.FldSimpleModel;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.fields.docproperty.DocPropertyResolver;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.wml.CTSimpleField;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class AbstractFldSimpleWriter
extends AbstractSimpleWriter {
    public static final String WRITER_ID = "w:fldSimple";
    private static Logger log = LoggerFactory.getLogger(AbstractFldSimpleWriter.class);
    protected Map<String, FldSimpleWriterHandler> handlers = new HashMap<String, FldSimpleWriterHandler>();
    protected FldSimpleNodeWriterHandler defaultHandler = null;
    protected String elementNs = null;
    protected String elementName = null;

    protected AbstractFldSimpleWriter(String elementNs, String elementName) {
        super(WRITER_ID);
        this.registerHandlers();
        this.defaultHandler = this.createDefaultHandler();
        this.elementNs = elementNs;
        this.elementName = elementName;
    }

    protected void registerHandlers() {
        this.registerHandler(new DateHandler());
        this.registerHandler(new TimeHandler());
        this.registerHandler(new PrintdateHandler());
        this.registerHandler(new DocPropertyHandler());
    }

    protected void registerHandler(FldSimpleWriterHandler handler) {
        this.handlers.put(handler.getName(), handler);
    }

    protected FldSimpleNodeWriterHandler createDefaultHandler() {
        return new FldSimpleNodeWriterHandler(){

            @Override
            public String getName() {
                return "*";
            }

            @Override
            public Node toNode(AbstractWmlConversionContext context, FldSimpleModel model, Document doc) throws TransformerException {
                return model.getContent();
            }

            @Override
            public int getProcessType() {
                return 0;
            }
        };
    }

    @Override
    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node content, Writer.TransformState state, Document doc) throws TransformerException {
        FldSimpleModel fldSimpleModel = new FldSimpleModel();
        fldSimpleModel.build((CTSimpleField)unmarshalledNode, content);
        log.debug("looking for handler for " + fldSimpleModel.getFldName());
        FldSimpleWriterHandler handler = this.handlers.get(fldSimpleModel.getFldName());
        FldSimpleNodeWriterHandler nodeHandler = null;
        Node ret = null;
        String value = null;
        if (handler == null) {
            handler = this.defaultHandler;
            log.debug(".. using  defaultHandler");
        } else {
            log.debug(".. got it .. " + handler.getClass().getName());
        }
        if (handler instanceof FldSimpleNodeWriterHandler) {
            nodeHandler = (FldSimpleNodeWriterHandler)handler;
            ret = nodeHandler.toNode(context, fldSimpleModel, doc);
            switch (nodeHandler.getProcessType()) {
                case 0: {
                    break;
                }
                case 1: {
                    this.applyStyle(context, fldSimpleModel, ret);
                    break;
                }
                case 2: {
                    ret = this.wrap(context, ret, doc);
                    this.applyStyle(context, fldSimpleModel, ret);
                }
            }
        } else {
            value = ((FldSimpleStringWriterHandler)handler).toString(context, fldSimpleModel);
            ret = this.wrap(context, value, doc);
            this.applyStyle(context, fldSimpleModel, ret);
        }
        return ret;
    }

    protected Node wrap(AbstractWmlConversionContext context, String result, Document doc) {
        Object rPr = null;
        Node node = null;
        if (result != null) {
            node = this.createNode(doc);
            if (result.length() > 0) {
                node.setTextContent(result);
            }
        }
        return node;
    }

    protected Node wrap(AbstractWmlConversionContext context, Node node, Document doc) {
        Node wrapper = null;
        if (node != null) {
            wrapper = this.createNode(doc);
            wrapper.appendChild(node);
        }
        return wrapper;
    }

    protected void applyStyle(AbstractWmlConversionContext context, FldSimpleModel fldSimpleModel, Node node) {
        List<Property> properties;
        CTSimpleField ctSimpleField = fldSimpleModel.getFldSimple();
        RPr rPr = null;
        if (node != null && (rPr = this.getRPr(ctSimpleField.getContent())) != null && (properties = PropertyFactory.createProperties((OpcPackage)context.getWmlPackage(), rPr)) != null && !properties.isEmpty()) {
            this.applyProperties(properties, node);
        }
    }

    private Node createNode(Document doc) {
        return this.elementNs != null && this.elementNs.length() > 0 ? doc.createElementNS(this.elementNs, this.elementName) : doc.createElement(this.elementName);
    }

    private RPr getRPr(List<Object> content) {
        for (int i = 0; i < content.size(); ++i) {
            if (!(content.get(i) instanceof R)) continue;
            return ((R)content.get(i)).getRPr();
        }
        return null;
    }

    protected abstract void applyProperties(List<Property> var1, Node var2);

    protected static class DocPropertyHandler
    implements FldSimpleStringWriterHandler {
        protected DocPropertyHandler() {
        }

        @Override
        public String getName() {
            return "DOCPROPERTY";
        }

        @Override
        public String toString(AbstractWmlConversionContext context, FldSimpleModel model) throws TransformerException {
            DocPropertyResolver dpr = new DocPropertyResolver(context.getWmlPackage());
            String key = model.getFldArgument();
            try {
                String value = dpr.getValue(key).toString();
                log.debug("= " + value);
                return FormattingSwitchHelper.applyFormattingSwitch(context.getWmlPackage(), model, value);
            }
            catch (FieldValueException e) {
                if (e.getMessage().contains("No value found for DOCPROPERTY PAGES")) {
                    // empty if block
                }
                throw new TransformerException(e);
            }
            catch (Docx4JException e) {
                throw new TransformerException(e);
            }
        }
    }

    protected static class PrintdateHandler
    implements FldSimpleStringWriterHandler {
        protected PrintdateHandler() {
        }

        @Override
        public String getName() {
            return "PRINTDATE";
        }

        @Override
        public String toString(AbstractWmlConversionContext context, FldSimpleModel model) throws TransformerException {
            return FormattingSwitchHelper.formatDate(model);
        }
    }

    protected static class TimeHandler
    implements FldSimpleStringWriterHandler {
        protected TimeHandler() {
        }

        @Override
        public String getName() {
            return "TIME";
        }

        @Override
        public String toString(AbstractWmlConversionContext context, FldSimpleModel model) throws TransformerException {
            return FormattingSwitchHelper.formatDate(model);
        }
    }

    protected static class DateHandler
    implements FldSimpleStringWriterHandler {
        protected DateHandler() {
        }

        @Override
        public String getName() {
            return "DATE";
        }

        @Override
        public String toString(AbstractWmlConversionContext context, FldSimpleModel model) throws TransformerException {
            return FormattingSwitchHelper.formatDate(model);
        }
    }

    public static interface FldSimpleStringWriterHandler
    extends FldSimpleWriterHandler {
        public String toString(AbstractWmlConversionContext var1, FldSimpleModel var2) throws TransformerException;
    }

    public static interface FldSimpleNodeWriterHandler
    extends FldSimpleWriterHandler {
        public static final int PROCESS_NONE = 0;
        public static final int PROCESS_APPLY_STYLE = 1;
        public static final int PROCESS_WRAP_APPLY_STYLE = 2;

        public int getProcessType();

        public Node toNode(AbstractWmlConversionContext var1, FldSimpleModel var2, Document var3) throws TransformerException;
    }

    public static interface FldSimpleWriterHandler {
        public String getName();
    }
}

