/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure;

import java.lang.annotation.Annotation;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;

abstract class OnEnabledEndpointElementCondition
extends SpringBootCondition {
    private final String prefix;
    private final Class<? extends Annotation> annotationType;

    OnEnabledEndpointElementCondition(String prefix, Class<? extends Annotation> annotationType) {
        this.prefix = prefix;
        this.annotationType = annotationType;
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        AnnotationAttributes annotationAttributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationType.getName()));
        String endpointName = annotationAttributes.getString("value");
        ConditionOutcome outcome = this.getEndpointOutcome(context, endpointName);
        if (outcome != null) {
            return outcome;
        }
        return this.getDefaultEndpointsOutcome(context);
    }

    protected ConditionOutcome getEndpointOutcome(ConditionContext context, String endpointName) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), this.prefix + endpointName + ".");
        if (resolver.containsProperty("enabled")) {
            boolean match = (Boolean)resolver.getProperty("enabled", Boolean.class, (Object)true);
            return new ConditionOutcome(match, ConditionMessage.forCondition(this.annotationType, (Object[])new Object[0]).because(this.prefix + endpointName + ".enabled is " + match));
        }
        return null;
    }

    protected ConditionOutcome getDefaultEndpointsOutcome(ConditionContext context) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), this.prefix + "defaults.");
        boolean match = Boolean.valueOf(resolver.getProperty("enabled", "true"));
        return new ConditionOutcome(match, ConditionMessage.forCondition(this.annotationType, (Object[])new Object[0]).because(this.prefix + "defaults.enabled is considered " + match));
    }
}

