/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.context.extended;

import java.util.EnumSet;
import org.terracotta.context.extended.RegisteredCompoundOperationStatistic;
import org.terracotta.context.extended.RegistrationType;
import org.terracotta.statistics.extended.CompoundOperation;
import org.terracotta.statistics.extended.SampledStatistic;

public class RegisteredRatioStatistic<T extends Enum<T>>
extends RegisteredCompoundOperationStatistic<T> {
    private final EnumSet<T> numerator;
    private final EnumSet<T> denominator;

    public RegisteredRatioStatistic(CompoundOperation<T> compoundOperation, EnumSet<T> numerator, EnumSet<T> denominator) {
        super(compoundOperation);
        this.numerator = numerator;
        this.denominator = denominator;
    }

    @Override
    public RegistrationType getType() {
        return RegistrationType.RATIO;
    }

    public EnumSet<T> getNumerator() {
        return this.numerator;
    }

    public EnumSet<T> getDenominator() {
        return this.denominator;
    }

    public SampledStatistic<Double> getSampledStatistic() {
        CompoundOperation<T> operation = this.getCompoundOperation();
        return operation.ratioOf(this.getNumerator(), this.getDenominator());
    }
}

