/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles.paragraph;

import fr.opensagres.poi.xwpf.converter.core.ParagraphLineSpacing;
import fr.opensagres.poi.xwpf.converter.core.styles.paragraph.AbstractSpacingParagraphValueProvider;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSignedTwipsMeasure;

public class ParagraphLineSpacingValueProvider
extends AbstractSpacingParagraphValueProvider<ParagraphLineSpacing> {
    protected static final float LINE_SPACING_FACTOR = 240.0f;
    public static final ParagraphLineSpacingValueProvider INSTANCE = new ParagraphLineSpacingValueProvider();

    @Override
    protected ParagraphLineSpacing getValue(CTSpacing spacing) {
        Float lineHeight = null;
        Float lineMultiple = null;
        STSignedTwipsMeasure line = spacing.xgetLine();
        if (line == null) {
            return null;
        }
        STLineSpacingRule.Enum lineRule = spacing.getLineRule();
        if (lineRule == null) {
            lineRule = STLineSpacingRule.AUTO;
        }
        if (lineRule == STLineSpacingRule.AUTO) {
            lineMultiple = Float.valueOf(XWPFUtils.floatValue(line) / 240.0f);
        } else {
            lineHeight = Float.valueOf(DxaUtil.dxa2points(line));
        }
        return new ParagraphLineSpacing(null, null, lineHeight, lineMultiple);
    }
}

