/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.PropertySetFactory;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.hpsf.WritingNotSupportedException;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.Encryptor;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptor;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public abstract class POIDocument
implements Closeable {
    private SummaryInformation sInf;
    private DocumentSummaryInformation dsInf;
    private DirectoryNode directory;
    private static final POILogger logger = POILogFactory.getLogger(POIDocument.class);
    private boolean initialized;

    protected POIDocument(DirectoryNode dir) {
        this.directory = dir;
    }

    protected POIDocument(OPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(NPOIFSFileSystem fs) {
        this(fs.getRoot());
    }

    protected POIDocument(POIFSFileSystem fs) {
        this(fs.getRoot());
    }

    public DocumentSummaryInformation getDocumentSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.dsInf;
    }

    public SummaryInformation getSummaryInformation() {
        if (!this.initialized) {
            this.readProperties();
        }
        return this.sInf;
    }

    public void createInformationProperties() {
        if (!this.initialized) {
            this.readProperties();
        }
        if (this.sInf == null) {
            this.sInf = PropertySetFactory.newSummaryInformation();
        }
        if (this.dsInf == null) {
            this.dsInf = PropertySetFactory.newDocumentSummaryInformation();
        }
    }

    protected void readProperties() {
        SummaryInformation si;
        if (this.initialized) {
            return;
        }
        DocumentSummaryInformation dsi = this.readPropertySet(DocumentSummaryInformation.class, "\u0005DocumentSummaryInformation");
        if (dsi != null) {
            this.dsInf = dsi;
        }
        if ((si = this.readPropertySet(SummaryInformation.class, "\u0005SummaryInformation")) != null) {
            this.sInf = si;
        }
        this.initialized = true;
    }

    private <T> T readPropertySet(Class<T> clazz, String name) {
        String localName = clazz.getName().substring(clazz.getName().lastIndexOf(46) + 1);
        try {
            PropertySet ps = this.getPropertySet(name);
            if (clazz.isInstance(ps)) {
                return (T)ps;
            }
            if (ps != null) {
                logger.log(5, localName + " property set came back with wrong class - " + ps.getClass().getName());
            } else {
                logger.log(5, localName + " property set came back as null");
            }
        }
        catch (IOException e) {
            logger.log(7, "can't retrieve property set", e);
        }
        return null;
    }

    protected PropertySet getPropertySet(String setName) throws IOException {
        return this.getPropertySet(setName, this.getEncryptionInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected PropertySet getPropertySet(String setName, EncryptionInfo encryptionInfo) throws IOException {
        String step;
        POIFSFileSystem encPoifs;
        DirectoryNode dirNode;
        block11: {
            String encryptedStream;
            dirNode = this.directory;
            encPoifs = null;
            step = "getting";
            if (encryptionInfo != null && encryptionInfo.isDocPropsEncrypted()) {
                step = "getting encrypted";
                encryptedStream = this.getEncryptedPropertyStreamName();
                if (!dirNode.hasEntry(encryptedStream)) {
                    throw new EncryptedDocumentException("can't find encrypted property stream '" + encryptedStream + "'");
                }
                CryptoAPIDecryptor dec = (CryptoAPIDecryptor)encryptionInfo.getDecryptor();
                encPoifs = dec.getSummaryEntries(dirNode, encryptedStream);
                dirNode = encPoifs.getRoot();
            }
            if (dirNode != null && dirNode.hasEntry(setName)) break block11;
            encryptedStream = null;
            IOUtils.closeQuietly(encPoifs);
            return encryptedStream;
        }
        step = "getting";
        DocumentInputStream dis = dirNode.createDocumentInputStream(dirNode.getEntry(setName));
        step = "creating";
        PropertySet propertySet = PropertySetFactory.create(dis);
        dis.close();
        IOUtils.closeQuietly(encPoifs);
        return propertySet;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        dis.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new IOException("Error " + step + " property set with name " + setName, e);
                    }
                }
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(encPoifs);
                    throw throwable2;
                }
            }
        }
    }

    protected void writeProperties() throws IOException {
        this.validateInPlaceWritePossible();
        this.writeProperties(this.directory.getFileSystem(), null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS) throws IOException {
        this.writeProperties(outFS, null);
    }

    protected void writeProperties(NPOIFSFileSystem outFS, List<String> writtenEntries) throws IOException {
        Encryptor encGen;
        DocumentSummaryInformation dsi;
        EncryptionInfo ei = this.getEncryptionInfo();
        boolean encryptProps = ei != null && ei.isDocPropsEncrypted();
        NPOIFSFileSystem fs = encryptProps ? new NPOIFSFileSystem() : outFS;
        SummaryInformation si = this.getSummaryInformation();
        if (si != null) {
            this.writePropertySet("\u0005SummaryInformation", si, fs);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005SummaryInformation");
            }
        }
        if ((dsi = this.getDocumentSummaryInformation()) != null) {
            this.writePropertySet("\u0005DocumentSummaryInformation", dsi, fs);
            if (writtenEntries != null) {
                writtenEntries.add("\u0005DocumentSummaryInformation");
            }
        }
        if (!encryptProps) {
            return;
        }
        dsi = PropertySetFactory.newDocumentSummaryInformation();
        this.writePropertySet("\u0005DocumentSummaryInformation", dsi, outFS);
        if (outFS.getRoot().hasEntry("\u0005SummaryInformation")) {
            outFS.getRoot().getEntry("\u0005SummaryInformation").delete();
        }
        if (!((encGen = ei.getEncryptor()) instanceof CryptoAPIEncryptor)) {
            throw new EncryptedDocumentException("Using " + (Object)((Object)ei.getEncryptionMode()) + " encryption. Only CryptoAPI encryption supports encrypted property sets!");
        }
        CryptoAPIEncryptor enc = (CryptoAPIEncryptor)encGen;
        try {
            enc.setSummaryEntries(outFS.getRoot(), this.getEncryptedPropertyStreamName(), fs);
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
        finally {
            fs.close();
        }
    }

    protected void writePropertySet(String name, PropertySet set, NPOIFSFileSystem outFS) throws IOException {
        try {
            PropertySet mSet = new PropertySet(set);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            mSet.write(bOut);
            byte[] data = bOut.toByteArray();
            ByteArrayInputStream bIn = new ByteArrayInputStream(data);
            outFS.createOrUpdateDocument(bIn, name);
            logger.log(3, "Wrote property set " + name + " of size " + data.length);
        }
        catch (WritingNotSupportedException wnse) {
            logger.log(7, "Couldn't write property set with name " + name + " as not supported by HPSF yet");
        }
    }

    protected void validateInPlaceWritePossible() throws IllegalStateException {
        if (this.directory == null) {
            throw new IllegalStateException("Newly created Document, cannot save in-place");
        }
        if (this.directory.getParent() != null) {
            throw new IllegalStateException("This is not the root Document, cannot save embedded resource in-place");
        }
        if (this.directory.getFileSystem() == null || !this.directory.getFileSystem().isInPlaceWriteable()) {
            throw new IllegalStateException("Opened read-only or via an InputStream, a Writeable File is required");
        }
    }

    public abstract void write() throws IOException;

    public abstract void write(File var1) throws IOException;

    public abstract void write(OutputStream var1) throws IOException;

    @Override
    public void close() throws IOException {
        if (this.directory != null && this.directory.getNFileSystem() != null) {
            this.directory.getNFileSystem().close();
            this.clearDirectory();
        }
    }

    @Internal
    public DirectoryNode getDirectory() {
        return this.directory;
    }

    @Internal
    protected void clearDirectory() {
        this.directory = null;
    }

    @Internal
    protected boolean initDirectory() {
        if (this.directory == null) {
            this.directory = new NPOIFSFileSystem().getRoot();
            return true;
        }
        return false;
    }

    @Internal
    protected DirectoryNode replaceDirectory(DirectoryNode newDirectory) {
        DirectoryNode dn = this.directory;
        this.directory = newDirectory;
        return dn;
    }

    protected String getEncryptedPropertyStreamName() {
        return "encryption";
    }

    public EncryptionInfo getEncryptionInfo() throws IOException {
        return null;
    }
}

