/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.taglib;

import groovy.lang.Closure;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class LayoutWriterStack {
    private static final String ATTRIBUTE_NAME_WRITER_STACK = "be.ixor.grails.gsptaglib.WRITER_STACK";
    private Stack<Map<String, Object>> stack = new Stack();

    public static Writer currentWriter(String name) {
        Map<String, Object> writers = LayoutWriterStack.currentStack().stack.peek();
        if (writers != null) {
            Writer result = (Writer)writers.get(name);
            if (result == null) {
                result = new StringWriter();
                writers.put(name, result);
            }
            return result;
        }
        return null;
    }

    public static Map<String, Object> writeParts(Closure<?> body) {
        LayoutWriterStack stack = LayoutWriterStack.currentStack();
        stack.push();
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("body", body.call());
        result.putAll(stack.pop());
        return result;
    }

    private static LayoutWriterStack currentStack() {
        RequestAttributes attributes = RequestContextHolder.currentRequestAttributes();
        if (attributes != null) {
            LayoutWriterStack stack = (LayoutWriterStack)attributes.getAttribute(ATTRIBUTE_NAME_WRITER_STACK, 0);
            if (stack == null) {
                stack = new LayoutWriterStack();
                attributes.setAttribute(ATTRIBUTE_NAME_WRITER_STACK, (Object)stack, 0);
            }
            return stack;
        }
        return null;
    }

    private void push() {
        this.stack.push(new HashMap());
    }

    private Map<String, Object> pop() {
        return this.stack.pop();
    }
}

