/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties.paragraph;

import org.docx4j.UnitsOfMeasurement;
import org.docx4j.model.properties.paragraph.AbstractParagraphProperty;
import org.docx4j.wml.CTBorder;
import org.docx4j.wml.PPr;
import org.docx4j.wml.STBorder;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSValue;

public abstract class AbstractPBorder
extends AbstractParagraphProperty {
    public String CSS_NAME_BASE;
    public String CSS_NAME__STYLE;
    public String CSS_NAME__WIDTH;
    public String CSS_NAME__COLOR;

    public AbstractPBorder(CTBorder val, String css_name) {
        this.init(css_name);
        this.setObject(val);
    }

    private void init(String css_name) {
        this.CSS_NAME_BASE = css_name;
        this.CSS_NAME__STYLE = this.CSS_NAME_BASE + "-style";
        this.CSS_NAME__WIDTH = this.CSS_NAME_BASE + "-width";
        this.CSS_NAME__COLOR = this.CSS_NAME_BASE + "-color";
    }

    public AbstractPBorder(CSSValue value, String css_name) {
        this.init(css_name);
    }

    @Override
    public String getCssProperty() {
        CTBorder border = (CTBorder)this.getObject();
        if (border == null) {
            return "";
        }
        String val = "";
        if (border.getVal() != null) {
            STBorder stBorder = border.getVal();
            log.debug("border: " + stBorder);
            if (stBorder.equals((Object)STBorder.NIL) || stBorder == STBorder.NONE) {
                val = AbstractPBorder.composeCss(this.CSS_NAME__STYLE, "none");
            } else if (stBorder == STBorder.SINGLE) {
                val = AbstractPBorder.composeCss(this.CSS_NAME__STYLE, "solid");
            } else if (stBorder == STBorder.DOUBLE || stBorder == STBorder.DOTTED || stBorder == STBorder.DASHED || stBorder == STBorder.OUTSET || stBorder == STBorder.INSET) {
                val = AbstractPBorder.composeCss(this.CSS_NAME__STYLE, stBorder.value());
            } else {
                log.warn("Falling back to solid");
                val = AbstractPBorder.composeCss(this.CSS_NAME__STYLE, "solid");
            }
        }
        String sz = "";
        if (border.getSz() != null) {
            float mm = this.eighthsToMM(border.getSz().intValue());
            sz = (double)mm < 0.262 ? AbstractPBorder.composeCss(this.CSS_NAME__WIDTH, "1px") : AbstractPBorder.composeCss(this.CSS_NAME__WIDTH, UnitsOfMeasurement.format2DP.format(mm) + "mm");
        }
        String color = "";
        if (border.getColor() != null) {
            color = border.getColor().equals("auto") ? AbstractPBorder.composeCss(this.CSS_NAME__COLOR, "#000000") : AbstractPBorder.composeCss(this.CSS_NAME__COLOR, "#" + border.getColor());
        }
        return val + sz + color;
    }

    public float eighthsToMM(int eighths) {
        float inches = (float)eighths / 576.0f;
        return inches / 0.0394f;
    }

    @Override
    public void setXslFO(Element foElement) {
        CTBorder border = (CTBorder)this.getObject();
        if (border == null) {
            return;
        }
        if (border.getVal() != null) {
            STBorder stBorder = border.getVal();
            log.debug("border: " + stBorder);
            if (stBorder.equals((Object)STBorder.NIL) || stBorder == STBorder.NONE) {
                foElement.setAttribute(this.CSS_NAME__STYLE, "none");
            } else if (stBorder == STBorder.SINGLE) {
                foElement.setAttribute(this.CSS_NAME__STYLE, "solid");
            } else if (stBorder == STBorder.DOUBLE || stBorder == STBorder.DOTTED || stBorder == STBorder.DASHED || stBorder == STBorder.OUTSET || stBorder == STBorder.INSET) {
                foElement.setAttribute(this.CSS_NAME__STYLE, stBorder.value());
            } else {
                log.warn("Falling back to solid");
                foElement.setAttribute(this.CSS_NAME__STYLE, "solid");
            }
        }
        if (border.getSz() != null) {
            float mm = this.eighthsToMM(border.getSz().intValue());
            foElement.setAttribute(this.CSS_NAME__WIDTH, UnitsOfMeasurement.format2DP.format(mm) + "mm");
        }
        if (border.getColor() != null) {
            if (border.getColor().equals("auto")) {
                foElement.setAttribute(this.CSS_NAME__COLOR, "#000000");
            } else {
                foElement.setAttribute(this.CSS_NAME__COLOR, "#" + border.getColor());
            }
        }
    }

    @Override
    public abstract void set(PPr var1);
}

