/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.support;

import grails.persistence.support.PersistenceContextInterceptor;
import java.util.ArrayList;
import java.util.List;
import org.grails.datastore.mapping.core.connections.ConnectionSource;
import org.grails.datastore.mapping.core.connections.ConnectionSources;
import org.grails.orm.hibernate.AbstractHibernateDatastore;
import org.grails.orm.hibernate.support.SessionFactoryAwarePersistenceContextInterceptor;

public abstract class AbstractMultipleDataSourceAggregatePersistenceContextInterceptor
implements PersistenceContextInterceptor {
    protected final List<PersistenceContextInterceptor> interceptors = new ArrayList<PersistenceContextInterceptor>();
    protected final AbstractHibernateDatastore hibernateDatastore;

    public AbstractMultipleDataSourceAggregatePersistenceContextInterceptor(AbstractHibernateDatastore hibernateDatastore) {
        this.hibernateDatastore = hibernateDatastore;
        ConnectionSources connectionSources = hibernateDatastore.getConnectionSources();
        Iterable allConnectionSources = connectionSources.getAllConnectionSources();
        for (ConnectionSource connectionSource : allConnectionSources) {
            SessionFactoryAwarePersistenceContextInterceptor interceptor = this.createPersistenceContextInterceptor(connectionSource.getName());
            this.interceptors.add(interceptor);
        }
    }

    public boolean isOpen() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            if (!interceptor.isOpen()) continue;
            return true;
        }
        return false;
    }

    public void reconnect() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.reconnect();
        }
    }

    public void destroy() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            try {
                if (!interceptor.isOpen()) continue;
                interceptor.destroy();
            }
            catch (Exception exception) {}
        }
    }

    public void clear() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.clear();
        }
    }

    public void disconnect() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.disconnect();
        }
    }

    public void flush() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.flush();
        }
    }

    public void init() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.init();
        }
    }

    public void setReadOnly() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.setReadOnly();
        }
    }

    public void setReadWrite() {
        for (PersistenceContextInterceptor interceptor : this.interceptors) {
            interceptor.setReadWrite();
        }
    }

    protected abstract SessionFactoryAwarePersistenceContextInterceptor createPersistenceContextInterceptor(String var1);
}

