/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.utils;

import fr.opensagres.poi.xwpf.converter.core.Color;
import fr.opensagres.poi.xwpf.converter.core.PageOrientation;
import java.math.BigInteger;
import org.apache.xmlbeans.SimpleValue;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STOnOff1;
import org.openxmlformats.schemas.officeDocument.x2006.sharedTypes.STTwipsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectType;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHpsMeasure;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STMeasurementOrPercent;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STPageOrientation;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSectionMark;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STSignedTwipsMeasure;

public class XWPFUtils {
    public static boolean isContinuousSection(CTSectPr sectPr) {
        if (sectPr == null) {
            return false;
        }
        CTSectType sectType = sectPr.getType();
        if (sectType == null) {
            return false;
        }
        return sectType.getVal() == STSectionMark.CONTINUOUS;
    }

    public static PageOrientation getPageOrientation(STPageOrientation.Enum orientation) {
        if (orientation != null) {
            if (STPageOrientation.LANDSCAPE.equals(orientation)) {
                return PageOrientation.Landscape;
            }
            return PageOrientation.Portrait;
        }
        return null;
    }

    public static String toHexString(Color color) {
        String hexaWith8Digits = Integer.toHexString(color.getRGB());
        return "#" + hexaWith8Digits.substring(2, hexaWith8Digits.length());
    }

    public static Color darken(int r, int g, int b, double percent) throws IllegalArgumentException {
        return new Color(Math.max((int)((double)r * (1.0 - percent)), 0), Math.max((int)((double)g * (1.0 - percent)), 0), Math.max((int)((double)b * (1.0 - percent)), 0));
    }

    public static Color lighten(int r, int g, int b, double percent) throws IllegalArgumentException {
        int r2 = r + (int)((double)(255 - r) * percent);
        int g2 = g + (int)((double)(255 - g) * percent);
        int b2 = b + (int)((double)(255 - b) * percent);
        return new Color(r2, g2, b2);
    }

    public static boolean isCTOnOff(CTOnOff onoff) {
        if (onoff == null) {
            return false;
        }
        if (!onoff.isSetVal()) {
            return true;
        }
        return XWPFUtils.isOn(onoff.xgetVal());
    }

    public static boolean isOn(STOnOff onoff) {
        if (onoff == null || onoff.getObjectValue() == null) {
            return false;
        }
        Object value = onoff.getObjectValue();
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return 1 == ((STOnOff1)onoff).getEnumValue().intValue();
    }

    public static float floatValue(STTwipsMeasure dxa) {
        return ((SimpleValue)dxa).getFloatValue();
    }

    public static float floatValue(STSignedTwipsMeasure dxa) {
        return ((SimpleValue)dxa).getFloatValue();
    }

    public static float floatValue(STMeasurementOrPercent dxa) {
        return ((SimpleValue)dxa).getFloatValue();
    }

    public static BigInteger bigIntegerValue(STHpsMeasure dxa) {
        return ((SimpleValue)dxa).getBigIntegerValue();
    }
}

