/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache.management.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.hibernate.management.api.EhcacheStats;
import org.hibernate.cache.ehcache.management.impl.AbstractEmitterBean;

public class EhcacheStatsImpl
extends AbstractEmitterBean
implements EhcacheStats {
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final MBeanNotificationInfo NOTIFICATION_INFO;
    private final CacheManager cacheManager;
    private long statsSince = System.currentTimeMillis();

    public EhcacheStatsImpl(CacheManager manager) throws NotCompliantMBeanException {
        super(EhcacheStats.class);
        this.cacheManager = manager;
    }

    public void flushRegionCache(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.flush();
        }
    }

    public void flushRegionCaches() {
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            cache.flush();
        }
    }

    public String generateActiveConfigDeclaration() {
        return this.cacheManager.getActiveConfigurationText();
    }

    public String generateActiveConfigDeclaration(String region) {
        return this.cacheManager.getActiveConfigurationText(region);
    }

    public long getCacheHitCount() {
        long count = 0L;
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            count += cache.getStatistics().cacheHitCount();
        }
        return count;
    }

    public double getCacheHitRate() {
        long now = System.currentTimeMillis();
        double deltaSecs = (double)(now - this.statsSince) / 1000.0;
        return (double)this.getCacheHitCount() / deltaSecs;
    }

    public long getCacheHitSample() {
        long count = 0L;
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            count += ((Double)cache.getStatistics().cacheHitOperation().rate().value()).longValue();
        }
        return count;
    }

    public long getCacheMissCount() {
        long count = 0L;
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            count += cache.getStatistics().cacheMissCount();
        }
        return count;
    }

    public double getCacheMissRate() {
        long now = System.currentTimeMillis();
        double deltaSecs = (double)(now - this.statsSince) / 1000.0;
        return (double)this.getCacheMissCount() / deltaSecs;
    }

    public long getCacheMissSample() {
        long count = 0L;
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            count += ((Double)cache.getStatistics().cacheMissOperation().rate().value()).longValue();
        }
        return count;
    }

    public long getCachePutCount() {
        long count = 0L;
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            count += cache.getStatistics().cachePutCount();
        }
        return count;
    }

    public double getCachePutRate() {
        long now = System.currentTimeMillis();
        double deltaSecs = (double)(now - this.statsSince) / 1000.0;
        return (double)this.getCachePutCount() / deltaSecs;
    }

    public long getCachePutSample() {
        long count = 0L;
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            count += ((Double)cache.getStatistics().cachePutOperation().rate().value()).longValue();
        }
        return count;
    }

    public String getOriginalConfigDeclaration() {
        return this.cacheManager.getOriginalConfigurationText();
    }

    public String getOriginalConfigDeclaration(String region) {
        return this.cacheManager.getOriginalConfigurationText(region);
    }

    public Map<String, Map<String, Object>> getRegionCacheAttributes() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (String regionName : this.cacheManager.getCacheNames()) {
            result.put(regionName, this.getRegionCacheAttributes(regionName));
        }
        return result;
    }

    public Map<String, Object> getRegionCacheAttributes(String regionName) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Enabled", this.isRegionCacheEnabled(regionName));
        result.put("LoggingEnabled", this.isRegionCacheLoggingEnabled(regionName));
        result.put("MaxTTISeconds", this.getRegionCacheMaxTTISeconds(regionName));
        result.put("MaxTTLSeconds", this.getRegionCacheMaxTTLSeconds(regionName));
        result.put("TargetMaxInMemoryCount", this.getRegionCacheTargetMaxInMemoryCount(regionName));
        result.put("TargetMaxTotalCount", this.getRegionCacheTargetMaxTotalCount(regionName));
        result.put("OrphanEvictionEnabled", this.isRegionCacheOrphanEvictionEnabled(regionName));
        result.put("OrphanEvictionPeriod", this.getRegionCacheOrphanEvictionPeriod(regionName));
        return result;
    }

    public int getRegionCacheMaxTTISeconds(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return (int)cache.getCacheConfiguration().getTimeToIdleSeconds();
        }
        return -1;
    }

    public int getRegionCacheMaxTTLSeconds(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return (int)cache.getCacheConfiguration().getTimeToLiveSeconds();
        }
        return -1;
    }

    public int getRegionCacheOrphanEvictionPeriod(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null && cache.isTerracottaClustered()) {
            return cache.getCacheConfiguration().getTerracottaConfiguration().getOrphanEvictionPeriod();
        }
        return -1;
    }

    public Map<String, int[]> getRegionCacheSamples() {
        HashMap<String, int[]> rv = new HashMap<String, int[]>();
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            Double hits = (Double)cache.getStatistics().cacheHitOperation().rate().value();
            Double misses = (Double)cache.getStatistics().cacheMissNotFoundOperation().rate().value();
            Double expired = (Double)cache.getStatistics().cacheMissExpiredOperation().rate().value();
            Double puts = (Double)cache.getStatistics().cachePutOperation().rate().value();
            rv.put(name, new int[]{hits.intValue(), misses.intValue(), expired.intValue(), puts.intValue()});
        }
        return rv;
    }

    public int getRegionCacheTargetMaxInMemoryCount(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return cache.getCacheConfiguration().getMaxElementsInMemory();
        }
        return -1;
    }

    public int getRegionCacheTargetMaxTotalCount(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return cache.getCacheConfiguration().getMaxElementsOnDisk();
        }
        return -1;
    }

    public String[] getTerracottaHibernateCacheRegionNames() {
        ArrayList<String> rv = new ArrayList<String>();
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null || !cache.getCacheConfiguration().isTerracottaClustered()) continue;
            rv.add(name);
        }
        return rv.toArray(new String[rv.size()]);
    }

    public boolean isRegionCacheEnabled(String region) {
        Cache cache = this.cacheManager.getCache(region);
        return cache != null && !cache.isDisabled();
    }

    public void setRegionCacheEnabled(String region, boolean enabled) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.setDisabled(!enabled);
        }
        this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
    }

    public boolean isRegionCachesEnabled() {
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null || !cache.isDisabled()) continue;
            return false;
        }
        return true;
    }

    public void setRegionCachesEnabled(boolean flag) {
        for (String name : this.cacheManager.getCacheNames()) {
            Cache cache = this.cacheManager.getCache(name);
            if (cache == null) continue;
            cache.setDisabled(!flag);
        }
        this.sendNotification("CacheEnabled", flag);
    }

    public boolean isRegionCacheLoggingEnabled(String region) {
        Cache cache = this.cacheManager.getCache(region);
        return cache != null && cache.getCacheConfiguration().getLogging();
    }

    public boolean isRegionCacheOrphanEvictionEnabled(String region) {
        Cache cache = this.cacheManager.getCache(region);
        return cache != null && cache.isTerracottaClustered() && cache.getCacheConfiguration().getTerracottaConfiguration().getOrphanEviction();
    }

    public boolean isTerracottaHibernateCache(String region) {
        Cache cache = this.cacheManager.getCache(region);
        return cache != null && cache.getCacheConfiguration().isTerracottaClustered();
    }

    public void setRegionCacheLoggingEnabled(String region, boolean loggingEnabled) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.getCacheConfiguration().setLogging(loggingEnabled);
            this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
        }
    }

    public void setRegionCacheMaxTTISeconds(String region, int maxTTISeconds) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.getCacheConfiguration().setTimeToIdleSeconds((long)maxTTISeconds);
            this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
        }
    }

    public void setRegionCacheMaxTTLSeconds(String region, int maxTTLSeconds) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.getCacheConfiguration().setTimeToLiveSeconds((long)maxTTLSeconds);
            this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
        }
    }

    public void setRegionCacheTargetMaxInMemoryCount(String region, int targetMaxInMemoryCount) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.getCacheConfiguration().setMaxElementsInMemory(targetMaxInMemoryCount);
            this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
        }
    }

    public void setRegionCacheTargetMaxTotalCount(String region, int targetMaxTotalCount) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            cache.getCacheConfiguration().setMaxElementsOnDisk(targetMaxTotalCount);
            this.sendNotification("CacheRegionChanged", this.getRegionCacheAttributes(region), region);
        }
    }

    public int getNumberOfElementsInMemory(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return (int)cache.getMemoryStoreSize();
        }
        return -1;
    }

    public int getNumberOfElementsOffHeap(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return (int)cache.getOffHeapStoreSize();
        }
        return -1;
    }

    public int getNumberOfElementsOnDisk(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            return cache.getDiskStoreSize();
        }
        return -1;
    }

    public long getMaxGetTimeMillis() {
        long rv = 0L;
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Long maximum;
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || (maximum = (Long)cache.getStatistics().cacheGetOperation().latency().maximum().value()) == null) continue;
            rv = Math.max(rv, TimeUnit.MILLISECONDS.convert(maximum, TimeUnit.NANOSECONDS));
        }
        return rv;
    }

    public long getMinGetTimeMillis() {
        long rv = Long.MAX_VALUE;
        for (String cacheName : this.cacheManager.getCacheNames()) {
            Long minimum;
            Cache cache = this.cacheManager.getCache(cacheName);
            if (cache == null || (minimum = (Long)cache.getStatistics().cacheGetOperation().latency().minimum().value()) == null) continue;
            rv = Math.min(rv, TimeUnit.MILLISECONDS.convert(minimum, TimeUnit.NANOSECONDS));
        }
        return rv == Long.MAX_VALUE ? 0L : rv;
    }

    public long getMaxGetTimeMillis(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            Long maximum = (Long)cache.getStatistics().cacheGetOperation().latency().maximum().value();
            return maximum == null ? 0L : TimeUnit.MILLISECONDS.convert(maximum, TimeUnit.NANOSECONDS);
        }
        return 0L;
    }

    public long getMinGetTimeMillis(String cacheName) {
        Cache cache = this.cacheManager.getCache(cacheName);
        if (cache != null) {
            Long minimum = (Long)cache.getStatistics().cacheGetOperation().latency().minimum().value();
            return minimum == null ? 0L : TimeUnit.MILLISECONDS.convert(minimum, TimeUnit.NANOSECONDS);
        }
        return 0L;
    }

    public float getAverageGetTimeMillis(String region) {
        Cache cache = this.cacheManager.getCache(region);
        if (cache != null) {
            Double avg = (Double)cache.getStatistics().cacheGetOperation().latency().average().value();
            return TimeUnit.MILLISECONDS.convert(avg.longValue(), TimeUnit.NANOSECONDS);
        }
        return -1.0f;
    }

    @Override
    protected void doDispose() {
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{NOTIFICATION_INFO};
    }

    static {
        String[] notifTypes = new String[]{"CacheEnabled", "CacheRegionChanged", "CacheFlushed", "CacheRegionFlushed", "CacheStatisticsEnabled", "CacheStatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache Hibernate Statistics Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo(notifTypes, name, "Ehcache Hibernate Statistics Event");
    }
}

