/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.oned.Code93Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Collection;
import java.util.Collections;

public class Code93Writer
extends OneDimensionalCodeWriter {
    @Override
    protected Collection<BarcodeFormat> getSupportedWriteFormats() {
        return Collections.singleton(BarcodeFormat.CODE_93);
    }

    @Override
    public boolean[] encode(String contents) {
        int length = (contents = Code93Writer.convertToExtended(contents)).length();
        if (length > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long after converting to extended encoding, but got " + length);
        }
        int codeWidth = (contents.length() + 2 + 2) * 9 + 1;
        boolean[] result = new boolean[codeWidth];
        int pos = Code93Writer.appendPattern(result, 0, Code93Reader.ASTERISK_ENCODING);
        for (int i = 0; i < length; ++i) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            pos += Code93Writer.appendPattern(result, pos, Code93Reader.CHARACTER_ENCODINGS[indexInString]);
        }
        int check1 = Code93Writer.computeChecksumIndex(contents, 20);
        pos += Code93Writer.appendPattern(result, pos, Code93Reader.CHARACTER_ENCODINGS[check1]);
        contents = contents + "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".charAt(check1);
        int check2 = Code93Writer.computeChecksumIndex(contents, 15);
        pos += Code93Writer.appendPattern(result, pos, Code93Reader.CHARACTER_ENCODINGS[check2]);
        pos += Code93Writer.appendPattern(result, pos, Code93Reader.ASTERISK_ENCODING);
        result[pos] = true;
        return result;
    }

    @Deprecated
    protected static int appendPattern(boolean[] target, int pos, int[] pattern, boolean startColor) {
        for (int bit : pattern) {
            target[pos++] = bit != 0;
        }
        return 9;
    }

    private static int appendPattern(boolean[] target, int pos, int a) {
        for (int i = 0; i < 9; ++i) {
            int temp = a & 1 << 8 - i;
            target[pos + i] = temp != 0;
        }
        return 9;
    }

    private static int computeChecksumIndex(String contents, int maxWeight) {
        int weight = 1;
        int total = 0;
        for (int i = contents.length() - 1; i >= 0; --i) {
            int indexInString = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".indexOf(contents.charAt(i));
            total += indexInString * weight;
            if (++weight <= maxWeight) continue;
            weight = 1;
        }
        return total % 47;
    }

    static String convertToExtended(String contents) {
        int length = contents.length();
        StringBuilder extendedContent = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            char character = contents.charAt(i);
            if (character == '\u0000') {
                extendedContent.append("bU");
                continue;
            }
            if (character <= '\u001a') {
                extendedContent.append('a');
                extendedContent.append((char)(65 + character - 1));
                continue;
            }
            if (character <= '\u001f') {
                extendedContent.append('b');
                extendedContent.append((char)(65 + character - 27));
                continue;
            }
            if (character == ' ' || character == '$' || character == '%' || character == '+') {
                extendedContent.append(character);
                continue;
            }
            if (character <= ',') {
                extendedContent.append('c');
                extendedContent.append((char)(65 + character - 33));
                continue;
            }
            if (character <= '9') {
                extendedContent.append(character);
                continue;
            }
            if (character == ':') {
                extendedContent.append("cZ");
                continue;
            }
            if (character <= '?') {
                extendedContent.append('b');
                extendedContent.append((char)(70 + character - 59));
                continue;
            }
            if (character == '@') {
                extendedContent.append("bV");
                continue;
            }
            if (character <= 'Z') {
                extendedContent.append(character);
                continue;
            }
            if (character <= '_') {
                extendedContent.append('b');
                extendedContent.append((char)(75 + character - 91));
                continue;
            }
            if (character == '`') {
                extendedContent.append("bW");
                continue;
            }
            if (character <= 'z') {
                extendedContent.append('d');
                extendedContent.append((char)(65 + character - 97));
                continue;
            }
            if (character <= '\u007f') {
                extendedContent.append('b');
                extendedContent.append((char)(80 + character - 123));
                continue;
            }
            throw new IllegalArgumentException("Requested content contains a non-encodable character: '" + character + "'");
        }
        return extendedContent.toString();
    }
}

