/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.validation.constraints;

import java.lang.reflect.Array;
import java.util.Collection;
import org.grails.datastore.gorm.validation.constraints.AbstractConstraint;
import org.springframework.context.MessageSource;
import org.springframework.validation.Errors;

public class MaxSizeConstraint
extends AbstractConstraint {
    private final int maxSize;

    public MaxSizeConstraint(Class<?> constraintOwningClass, String constraintPropertyName, Object constraintParameter, MessageSource messageSource) {
        super(constraintOwningClass, constraintPropertyName, constraintParameter, messageSource);
        this.maxSize = ((Number)this.constraintParameter).intValue();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    protected Object validateParameter(Object constraintParameter) {
        if (!(constraintParameter instanceof Number)) {
            throw new IllegalArgumentException("Parameter for constraint [maxSize] of property [" + this.constraintPropertyName + "] of class [" + this.constraintOwningClass + "] must be a of type [java.lang.Number]");
        }
        return constraintParameter;
    }

    @Override
    public String getName() {
        return "maxSize";
    }

    @Override
    public boolean supports(Class type) {
        return type != null && (String.class.isAssignableFrom(type) || Collection.class.isAssignableFrom(type) || type.isArray());
    }

    @Override
    protected void processValidate(Object target, Object propertyValue, Errors errors) {
        int length = propertyValue.getClass().isArray() ? Array.getLength(propertyValue) : (propertyValue instanceof Collection ? ((Collection)propertyValue).size() : ((String)propertyValue).length());
        if (length > this.maxSize) {
            Object[] args = new Object[]{this.constraintPropertyName, this.constraintOwningClass, propertyValue, this.maxSize};
            this.rejectValue(target, errors, "default.invalid.max.size.message", "maxSize.exceeded", args);
        }
    }
}

