/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.validation;

import grails.core.GrailsDomainClass;
import grails.core.GrailsDomainClassProperty;
import grails.validation.Constrained;
import java.util.Map;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.PersistentProperty;
import org.grails.orm.hibernate.cfg.PropertyConfig;
import org.grails.validation.DefaultConstraintEvaluator;

public class HibernateConstraintsEvaluator
extends DefaultConstraintEvaluator {
    private MappingContext mappingContext;

    public HibernateConstraintsEvaluator(Map<String, Object> defaultConstraints) {
        super(defaultConstraints);
    }

    public HibernateConstraintsEvaluator() {
    }

    public void setMappingContext(MappingContext mappingContext) {
        this.mappingContext = mappingContext;
    }

    protected boolean canPropertyBeConstrained(GrailsDomainClassProperty property) {
        PersistentEntity entity = this.getPersistentEntity(property);
        PersistentProperty p = this.getPersistentProperty(property);
        if (p != null) {
            PersistentProperty identity;
            PropertyConfig propertyConfig = this.getPropertyConfig(p);
            if (propertyConfig != null) {
                property.setDerived(propertyConfig.getFormula() != null);
            }
            if ((identity = entity.getIdentity()) != null && identity.getName().equals(property.getName())) {
                return false;
            }
        }
        return super.canPropertyBeConstrained(property);
    }

    protected boolean canApplyNullableConstraint(String propertyName, GrailsDomainClassProperty property, Constrained constrained) {
        PropertyConfig propertyConfig = this.getPropertyConfig(property);
        if (propertyConfig != null) {
            property.setDerived(propertyConfig.getFormula() != null);
        }
        return super.canApplyNullableConstraint(propertyName, property, constrained);
    }

    protected void applyDefaultNullableConstraint(GrailsDomainClassProperty p, Constrained cp) {
        boolean insertable;
        PropertyConfig propertyConfig = this.getPropertyConfig(p);
        if (propertyConfig != null && propertyConfig.getFormula() != null) {
            p.setDerived(true);
        }
        boolean bl = insertable = propertyConfig == null || propertyConfig.isInsertable();
        if (!insertable) {
            cp.applyConstraint("nullable", (Object)true);
        } else if (this.canApplyNullableConstraint(p.getName(), p, cp)) {
            super.applyDefaultNullableConstraint(p, cp);
        }
    }

    private PropertyConfig getPropertyConfig(GrailsDomainClassProperty p) {
        PersistentProperty property = this.getPersistentProperty(p);
        return this.getPropertyConfig(property);
    }

    private PropertyConfig getPropertyConfig(PersistentProperty property) {
        PropertyConfig propertyConfig = null;
        if (property != null) {
            propertyConfig = (PropertyConfig)property.getMapping().getMappedForm();
        }
        return propertyConfig;
    }

    protected PersistentProperty getPersistentProperty(GrailsDomainClassProperty p) {
        PersistentProperty property = null;
        PersistentEntity entity = this.getPersistentEntity(p);
        if (entity != null) {
            property = entity.getPropertyByName(p.getName());
        }
        return property;
    }

    private PersistentEntity getPersistentEntity(GrailsDomainClassProperty p) {
        GrailsDomainClass domainClass = p.getDomainClass();
        PersistentEntity entity = null;
        if (this.mappingContext != null) {
            entity = this.mappingContext.getPersistentEntity(domainClass.getFullName());
        }
        return entity;
    }
}

