/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model;

import fr.w3blog.zpl.constant.ZebraFont;
import fr.w3blog.zpl.constant.ZebraPaperType;
import fr.w3blog.zpl.constant.ZebraPrintMode;
import fr.w3blog.zpl.model.PrinterOptions;
import fr.w3blog.zpl.model.ZebraElement;
import fr.w3blog.zpl.utils.ZplUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public class ZebraLabel {
    private Integer widthDots;
    private Integer heightDots;
    private ZebraPrintMode zebraPrintMode = ZebraPrintMode.TEAR_OFF;
    private ZebraPaperType zebraPaperType;
    private PrinterOptions printerOptions = new PrinterOptions();
    private List<ZebraElement> zebraElements = new ArrayList<ZebraElement>();

    public ZebraLabel() {
        this.zebraElements = new ArrayList<ZebraElement>();
    }

    public ZebraLabel(PrinterOptions printerOptions) {
        this.printerOptions = printerOptions;
    }

    public ZebraLabel(int widthDots, int heightDots) {
        this.widthDots = widthDots;
        this.heightDots = heightDots;
    }

    public ZebraLabel(int widthDots, int heightDots, PrinterOptions printerOptions) {
        this.widthDots = widthDots;
        this.heightDots = heightDots;
        this.printerOptions = printerOptions;
    }

    public ZebraLabel addElement(ZebraElement zebraElement) {
        this.zebraElements.add(zebraElement);
        return this;
    }

    public ZebraLabel setDefaultZebraFont(ZebraFont defaultZebraFont) {
        this.printerOptions.setDefaultZebraFont(defaultZebraFont);
        return this;
    }

    public ZebraLabel setDefaultFontSize(Integer defaultFontSize) {
        this.printerOptions.setDefaultFontSize(defaultFontSize);
        return this;
    }

    public Integer getWidthDots() {
        return this.widthDots;
    }

    public ZebraLabel setWidthDots(Integer widthDots) {
        this.widthDots = widthDots;
        return this;
    }

    public Integer getHeightDots() {
        return this.heightDots;
    }

    public ZebraLabel setHeightDots(Integer heightDots) {
        this.heightDots = heightDots;
        return this;
    }

    public PrinterOptions getPrinterOptions() {
        return this.printerOptions;
    }

    public void setPrinterOptions(PrinterOptions printerOptions) {
        this.printerOptions = printerOptions;
    }

    public ZebraPrintMode getZebraPrintMode() {
        return this.zebraPrintMode;
    }

    public ZebraLabel setZebraPrintMode(ZebraPrintMode zebraPrintMode) {
        this.zebraPrintMode = zebraPrintMode;
        return this;
    }

    public ZebraPaperType getZebraPaperType() {
        return this.zebraPaperType;
    }

    public ZebraLabel setZebraPaperType(ZebraPaperType zebraPaperType) {
        this.zebraPaperType = zebraPaperType;
        return this;
    }

    public List<ZebraElement> getZebraElements() {
        return this.zebraElements;
    }

    public void setZebraElements(List<ZebraElement> zebraElements) {
        this.zebraElements = zebraElements;
    }

    public String getZplCode() {
        StringBuilder zpl = new StringBuilder();
        zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("XA"));
        zpl.append(this.zebraPrintMode.getZplCode());
        if (this.zebraPaperType != null) {
            zpl.append(this.zebraPaperType.getZplCode());
        }
        if (this.widthDots != null) {
            zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("PW", this.widthDots));
        }
        if (this.heightDots != null) {
            zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("LL", this.heightDots));
        }
        if (this.printerOptions.getDefaultZebraFont() != null && this.printerOptions.getDefaultFontSize() != null) {
            zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("CF", ZplUtils.extractDotsFromFont(this.printerOptions.getDefaultZebraFont(), this.printerOptions.getDefaultFontSize(), this.printerOptions.getZebraPPP())));
        }
        for (ZebraElement zebraElement : this.zebraElements) {
            zpl.append(zebraElement.getZplCode(this.printerOptions));
        }
        zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("XZ"));
        return zpl.toString();
    }

    public BufferedImage getImagePreview() {
        if (this.widthDots != null && this.heightDots != null) {
            int widthPx = ZplUtils.convertPointInPixel(this.widthDots);
            int heightPx = ZplUtils.convertPointInPixel(this.heightDots);
            BufferedImage image = new BufferedImage(widthPx, heightPx, 2);
            Graphics2D graphic = image.createGraphics();
            graphic.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphic.setComposite(AlphaComposite.Src);
            graphic.fillRect(0, 0, widthPx, heightPx);
            graphic.setColor(Color.BLACK);
            graphic.setFont(new Font("Arial", 1, 11));
            for (ZebraElement zebraElement : this.zebraElements) {
                zebraElement.drawPreviewGraphic(this.printerOptions, graphic);
            }
            return image;
        }
        throw new UnsupportedOperationException("Graphics Preview is only available ont label sized");
    }
}

