/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.gorm.transform;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.grails.datastore.mapping.reflect.AstUtils;
import org.grails.datastore.mapping.reflect.ClassPropertyFetcher;
import org.grails.datastore.mapping.reflect.NameUtils;

public class AstPropertyResolveUtils {
    protected static Map<String, Map<String, ClassNode>> cachedClassProperties = new HashMap<String, Map<String, ClassNode>>();

    public static ClassNode getPropertyType(ClassNode classNode, String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        Map<String, ClassNode> cachedProperties = AstPropertyResolveUtils.getPropertiesFromCache(classNode);
        if (cachedProperties.containsKey(propertyName)) {
            return cachedProperties.get(propertyName);
        }
        ClassNode type = null;
        PropertyNode property = classNode.getProperty(propertyName);
        if (property != null) {
            type = property.getType();
        } else {
            MethodNode methodNode = classNode.getMethod(NameUtils.getGetterName((String)propertyName), new Parameter[0]);
            if (methodNode != null) {
                type = methodNode.getReturnType();
            } else {
                FieldNode fieldNode = classNode.getDeclaredField(propertyName);
                if (fieldNode != null) {
                    type = fieldNode.getType();
                }
            }
        }
        return type;
    }

    public static List<String> getPropertyNames(ClassNode classNode) {
        Map<String, ClassNode> cachedProperties = AstPropertyResolveUtils.getPropertiesFromCache(classNode);
        return new ArrayList<String>(cachedProperties.keySet());
    }

    private static Map<String, ClassNode> getPropertiesFromCache(ClassNode classNode) {
        String className = classNode.getName();
        Map<String, ClassNode> cachedProperties = cachedClassProperties.get(className);
        if (cachedProperties == null) {
            cachedProperties = new HashMap<String, ClassNode>();
            boolean isDomainClass = AstUtils.isDomainClass((ClassNode)classNode);
            if (isDomainClass) {
                cachedProperties.put("id", new ClassNode(Long.class));
                cachedProperties.put("version", new ClassNode(Long.class));
            }
            cachedClassProperties.put(className, cachedProperties);
            for (ClassNode currentNode = classNode; currentNode != null && !currentNode.equals((Object)ClassHelper.OBJECT_TYPE); currentNode = currentNode.getSuperClass()) {
                AstPropertyResolveUtils.populatePropertiesForClassNode(currentNode, cachedProperties, isDomainClass, !isDomainClass);
            }
        }
        return cachedProperties;
    }

    private static void populatePropertiesForClassNode(ClassNode classNode, Map<String, ClassNode> cachedProperties, boolean isDomainClass, boolean allowAbstract) {
        String propertyName;
        List methods = classNode.getMethods();
        for (Object method : methods) {
            String methodName = method.getName();
            if (!AstUtils.isGetter((MethodNode)method) || !allowAbstract && method.isAbstract() || "metaClass".equals(propertyName = NameUtils.getPropertyNameForGetterOrSetter((String)methodName))) continue;
            if (isDomainClass && ("hasMany".equals(propertyName) || "belongsTo".equals(propertyName) || "hasOne".equals(propertyName))) {
                FieldNode field = classNode.getField(propertyName);
                if (field == null) continue;
                AstPropertyResolveUtils.populatePropertiesForInitialExpression(cachedProperties, field.getInitialExpression());
                continue;
            }
            if (method.isStatic()) continue;
            cachedProperties.put(propertyName, method.getReturnType());
        }
        List properties = classNode.getProperties();
        for (PropertyNode property : properties) {
            propertyName = property.getName();
            if (propertyName.equals("metaClass")) continue;
            if (isDomainClass && ("hasMany".equals(propertyName) || "belongsTo".equals(propertyName) || "hasOne".equals(propertyName))) {
                Expression initialExpression = property.getInitialExpression();
                AstPropertyResolveUtils.populatePropertiesForInitialExpression(cachedProperties, initialExpression);
                continue;
            }
            cachedProperties.put(propertyName, property.getType());
        }
        if (isDomainClass && classNode.isResolved()) {
            ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass((Class)classNode.getTypeClass());
            AstPropertyResolveUtils.cachePropertiesForAssociationMetadata(cachedProperties, propertyFetcher, "hasMany");
            AstPropertyResolveUtils.cachePropertiesForAssociationMetadata(cachedProperties, propertyFetcher, "belongsTo");
            AstPropertyResolveUtils.cachePropertiesForAssociationMetadata(cachedProperties, propertyFetcher, "hasOne");
        }
    }

    private static void cachePropertiesForAssociationMetadata(Map<String, ClassNode> cachedProperties, ClassPropertyFetcher propertyFetcher, String associationMetadataName) {
        Object propertyValue;
        if (propertyFetcher.isReadableProperty(associationMetadataName) && (propertyValue = propertyFetcher.getPropertyValue(associationMetadataName)) instanceof Map) {
            Map hasManyMap = (Map)propertyValue;
            for (Object propertyName : hasManyMap.keySet()) {
                Object val = hasManyMap.get(propertyName);
                if (!(val instanceof Class)) continue;
                cachedProperties.put(propertyName.toString(), ClassHelper.make((Class)((Class)val)).getPlainNodeReference());
            }
        }
    }

    private static void populatePropertiesForInitialExpression(Map<String, ClassNode> cachedProperties, Expression initialExpression) {
        if (initialExpression instanceof MapExpression) {
            MapExpression me = (MapExpression)initialExpression;
            List mapEntryExpressions = me.getMapEntryExpressions();
            for (MapEntryExpression mapEntryExpression : mapEntryExpressions) {
                Expression keyExpression = mapEntryExpression.getKeyExpression();
                Expression valueExpression = mapEntryExpression.getValueExpression();
                if (!(valueExpression instanceof ClassExpression)) continue;
                cachedProperties.put(keyExpression.getText(), valueExpression.getType());
            }
        }
    }
}

