/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.docx4j.Docx4J;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.FopReflective;
import org.docx4j.finders.SectPrFindFirst;
import org.docx4j.model.bookmarks.BookmarksIntegrity;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.WordprocessingML.NumberingDefinitionsPart;
import org.docx4j.toc.Toc;
import org.docx4j.toc.TocEntry;
import org.docx4j.toc.TocException;
import org.docx4j.toc.TocFinder;
import org.docx4j.toc.TocHelper;
import org.docx4j.toc.TocPageNumbersHandler;
import org.docx4j.toc.TocSdtUtils;
import org.docx4j.toc.TocStyles;
import org.docx4j.toc.switches.SwitchProcessor;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.Document;
import org.docx4j.wml.P;
import org.docx4j.wml.STTabTlc;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtContent;
import org.docx4j.wml.SdtContentBlock;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tabs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public class TocGenerator {
    private static Logger log = LoggerFactory.getLogger(TocGenerator.class);
    private WordprocessingMLPackage wordMLPackage;
    private SectPr sectPr;
    private TocStyles tocStyles = null;
    AtomicInteger bookmarkId = null;
    private boolean foViaXSLT = true;

    public WordprocessingMLPackage getWordMLPackage() {
        return this.wordMLPackage;
    }

    private TocGenerator() {
    }

    public TocGenerator(WordprocessingMLPackage wordMLPackage) throws TocException {
        this.wordMLPackage = wordMLPackage;
        this.tocStyles = TocStyles.getTocStyles(wordMLPackage.getMainDocumentPart());
    }

    @Deprecated
    public static SdtBlock generateToc(WordprocessingMLPackage wordMLPackage, boolean skipPageNumbering) throws TocException {
        return new TocGenerator(wordMLPackage).generateToc(0, " TOC \\o \"1-3\" \\h \\z \\u ", skipPageNumbering);
    }

    @Deprecated
    public static SdtBlock generateToc(WordprocessingMLPackage wordMLPackage, int index, String instruction, boolean skipPageNumbering) throws TocException {
        new TocGenerator(wordMLPackage);
        return TocGenerator.generateToc(wordMLPackage, index, instruction, skipPageNumbering);
    }

    public SdtBlock generateToc(boolean skipPageNumbering) throws TocException {
        return this.generateToc(0, " TOC \\o \"1-3\" \\h \\z \\u ", skipPageNumbering);
    }

    public SdtBlock generateToc(int index, String instruction, boolean skipPageNumbering) throws TocException {
        return this.generateToc(index, instruction, TocHelper.DEFAULT_TAB_LEADER, skipPageNumbering);
    }

    public SdtBlock generateToc(int index, String instruction, STTabTlc leader, boolean skipPageNumbering) throws TocException {
        MainDocumentPart documentPart = this.wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        TocFinder finder = new TocFinder();
        new TraversalUtil(body.getContent(), finder);
        SdtBlock sdt = finder.tocSDT;
        if (sdt != null) {
            throw new TocException("ToC already present; use updateToc instead");
        }
        List sublist = body.getContent().subList(index, body.getContent().size());
        SectPrFindFirst sf = new SectPrFindFirst();
        new TraversalUtil(sublist, sf);
        this.sectPr = sf.firstSectPr;
        sdt = TocSdtUtils.createSdt();
        body.getContent().add(index, sdt);
        return this.generateToc(sdt, instruction, leader, skipPageNumbering);
    }

    protected SdtBlock generateToc(SdtBlock sdt, String instruction, STTabTlc leader, boolean skipPageNumbering) throws TocException {
        MainDocumentPart documentPart = this.wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        SdtContentBlock sdtContent = (SdtContentBlock)sdt.getSdtContent();
        if (sdtContent == null) {
            sdtContent = TocSdtUtils.createSdtContent();
            sdt.setSdtContent((SdtContent)sdtContent);
        }
        if (Toc.getTocHeadingText() != null) {
            TocSdtUtils.addTocHeading(documentPart, this.tocStyles, sdtContent);
        }
        this.populateToc(sdtContent, instruction, leader, skipPageNumbering);
        return sdt;
    }

    protected SdtBlock generateToc(SdtBlock sdt, List<P> tocHeadingP, String instruction, STTabTlc leader, boolean skipPageNumbering) throws TocException {
        MainDocumentPart documentPart = this.wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        SdtContentBlock sdtContent = (SdtContentBlock)sdt.getSdtContent();
        if (sdtContent == null) {
            sdtContent = TocSdtUtils.createSdtContent();
            sdt.setSdtContent((SdtContent)sdtContent);
        }
        if (tocHeadingP == null || tocHeadingP.size() == 0) {
            log.warn("No ToC header paragraph provided!");
        } else {
            sdtContent.getContent().addAll(tocHeadingP);
        }
        this.populateToc(sdtContent, instruction, leader, skipPageNumbering);
        return sdt;
    }

    public void setStartingIdForNewBookmarks(AtomicInteger bookmarkId) {
        this.bookmarkId = bookmarkId;
    }

    private void populateToc(SdtContentBlock sdtContent, String instruction, STTabTlc leader, boolean skipPageNumbering) throws TocException {
        MainDocumentPart documentPart = this.wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        Toc toc = new Toc(instruction);
        if (this.sectPr == null) {
            log.debug("sectPr not set by tocFinder");
            this.sectPr = ((Document)this.wordMLPackage.getMainDocumentPart().getJaxbElement()).getBody().getSectPr();
            if (this.sectPr == null) {
                throw new TocException("No sectPr following ToC");
            }
        }
        PageDimensions pageDimensions = new PageDimensions(this.sectPr);
        try {
            pageDimensions.getWritableWidthTwips();
        }
        catch (RuntimeException e) {
            throw new TocException("margins or page width not defined in \n" + XmlUtils.marshaltoString(this.sectPr));
        }
        ArrayList<TocEntry> tocEntries = new ArrayList<TocEntry>();
        List<Object> pList = TocHelper.getAllElementsFromObject(body, P.class);
        Map<P, Emulator.ResultTriple> pNumbersMap = this.numberParagraphs(pList);
        SwitchProcessor sp = new SwitchProcessor(pageDimensions, leader);
        sp.setStartingIdForNewBookmarks(this.bookmarkId);
        tocEntries.addAll(sp.processSwitches(this.wordMLPackage, pList, toc.getSwitches(), pNumbersMap));
        if (tocEntries.size() == 0) {
            log.warn("No ToC entries generated!");
            P p = new P();
            p.getContent().addAll(toc.getTocInstruction());
            sdtContent.getContent().add(p);
            sdtContent.getContent().add(TocSdtUtils.getLastParagraph());
        } else {
            P firstEntry = ((TocEntry)tocEntries.get(0)).getEntryParagraph(this.tocStyles);
            firstEntry.getContent().addAll(0, toc.getTocInstruction());
            for (TocEntry entry : tocEntries) {
                sdtContent.getContent().add(entry.getEntryParagraph(this.tocStyles));
            }
            sdtContent.getContent().add(TocSdtUtils.getLastParagraph());
            if (!skipPageNumbering && sp.pageNumbers()) {
                Map<String, Integer> pageNumbersMap = this.getPageNumbersMap();
                for (TocEntry entry : tocEntries) {
                    Integer pageNumber = pageNumbersMap.get(entry.getAnchorValue());
                    if (pageNumber == null) {
                        log.debug("null page number for key " + entry.getAnchorValue());
                        continue;
                    }
                    if (!entry.isPageNumber()) continue;
                    entry.getEntryPageNumberText().setValue(Integer.toString(pageNumber));
                }
            }
        }
    }

    private Map<P, Emulator.ResultTriple> numberParagraphs(List<P> pList) {
        NumberingDefinitionsPart numberingPart = this.wordMLPackage.getMainDocumentPart().getNumberingDefinitionsPart();
        HashMap<P, Emulator.ResultTriple> pNumbersMap = new HashMap<P, Emulator.ResultTriple>();
        if (numberingPart == null) {
            return pNumbersMap;
        }
        numberingPart.getEmulator(true);
        for (P p : pList) {
            if (p.getPPr() == null) continue;
            Emulator.ResultTriple triple = Emulator.getNumber(this.wordMLPackage, p.getPPr());
            pNumbersMap.put(p, triple);
        }
        return pNumbersMap;
    }

    public SdtBlock updateToc(boolean skipPageNumbering) throws TocException {
        return this.updateToc(skipPageNumbering, true);
    }

    public SdtBlock updateToc() throws TocException {
        return this.updateToc(false, true);
    }

    @Deprecated
    public static SdtBlock updateToc(WordprocessingMLPackage wordMLPackage, boolean skipPageNumbering) throws TocException {
        return new TocGenerator(wordMLPackage).updateToc(skipPageNumbering);
    }

    public SdtBlock updateToc(boolean skipPageNumbering, boolean reuseExistingToCHeadingP) throws TocException {
        return this.updateToc(skipPageNumbering, reuseExistingToCHeadingP, null);
    }

    public SdtBlock updateToc(boolean skipPageNumbering, boolean reuseExistingToCHeadingP, STTabTlc leader) throws TocException {
        MainDocumentPart documentPart = this.wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        TocFinder finder = new TocFinder();
        new TraversalUtil(body.getContent(), finder);
        SdtBlock sdt = finder.tocSDT;
        this.sectPr = finder.sectPr;
        if (sdt == null) {
            throw new TocException("No ToC content control found");
        }
        String instruction = finder.tocInstruction;
        if (instruction.isEmpty()) {
            throw new TocException("TOC instruction text missing");
        }
        if (leader == null) {
            leader = this.getExistingTabLeader(sdt.getSdtContent().getContent());
        }
        sdt.getSdtContent().getContent().clear();
        if (finder.tocHeadingP == null || finder.tocHeadingP.size() == 0) {
            log.warn("No ToC header paragraph found; generating..");
            this.generateToc(sdt, instruction, leader, skipPageNumbering);
        } else if (!reuseExistingToCHeadingP) {
            log.debug("Generating ToC header paragraph ..");
            this.generateToc(sdt, instruction, leader, skipPageNumbering);
        } else {
            log.debug("Reusing existing ToC header paragraph");
            this.generateToc(sdt, finder.tocHeadingP, instruction, leader, skipPageNumbering);
        }
        return sdt;
    }

    private STTabTlc getExistingTabLeader(List<Object> contents) {
        Tabs sampleTabs;
        P sampleP;
        Object o;
        STTabTlc leader = null;
        if (contents.size() > 1 && (o = contents.get(1)) instanceof P && (sampleP = (P)o).getPPr() != null && sampleP.getPPr() != null && sampleP.getPPr().getTabs() != null && (sampleTabs = sampleP.getPPr().getTabs()).getTab().size() > 0) {
            CTTabStop tab = (CTTabStop)sampleTabs.getTab().get(0);
            leader = tab.getLeader();
            if (leader == null) {
                leader = STTabTlc.NONE;
                log.debug("Reusing existing leader (in this case, STTabTlc.NONE)");
            } else {
                log.debug("Reusing existing leader");
            }
        }
        if (leader == null) {
            log.info("Couldn't figure out leader from existing ToC; defaulting to dots");
            leader = TocHelper.DEFAULT_TAB_LEADER;
        }
        return leader;
    }

    @Deprecated
    public SdtBlock updateToc(WordprocessingMLPackage wordMLPackage, boolean skipPageNumbering, boolean reuseExistingToCHeadingP) throws TocException {
        return new TocGenerator(wordMLPackage).updateToc(skipPageNumbering, reuseExistingToCHeadingP);
    }

    public void pageNumbersViaXSLT(boolean useXSLT) {
        this.foViaXSLT = useXSLT;
    }

    private Map<String, Integer> getPageNumbersMap() throws TocException {
        boolean remediate = Docx4jProperties.getProperty("docx4j.toc.BookmarksIntegrity.remediate", false);
        BookmarksIntegrity bm = new BookmarksIntegrity();
        StringWriter sw = new StringWriter();
        bm.setWriter(sw);
        BookmarksIntegrity.BookmarksStatus result = null;
        try {
            result = bm.check(this.wordMLPackage.getMainDocumentPart(), remediate);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == BookmarksIntegrity.BookmarksStatus.BROKEN) {
            throw new TocException("Encountered broken bookmarks; not configured to remediate. \n" + sw.toString());
        }
        if (Docx4J.pdfViaFO()) {
            return this.getPageNumbersMapViaFOP();
        }
        if (Docx4J.pdfViaLegacyConverter()) {
            try {
                return this.getPageNumbersMapViaService();
            }
            catch (TocException e) {
                throw new TocException("Page number service not available; try using docx4j-export-documents4j-local|remote or docx4j-export-fo");
            }
        }
        throw new TocException("For page numbering, try using docx4j-export-documents4j-local|remote or docx4j-export-fo");
    }

    private Map<String, Integer> getPageNumbersMapViaService() throws TocException {
        log.debug("getPageNumbersMapViaService() starting..");
        ByteArrayOutputStream tmpDocxFile = new ByteArrayOutputStream();
        try {
            Docx4J.save((OpcPackage)this.wordMLPackage, tmpDocxFile, 1);
        }
        catch (Exception e) {
            throw new TocException("Error saving pkg as tmp file; " + e.getMessage(), e);
        }
        String documentServicesEndpoint = Docx4jProperties.getProperty("com.plutext.converter.URL", "http://localhost:9016/v1/00000000-0000-0000-0000-000000000000/convert");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Class<?> clazz = Class.forName("org.docx4j.services.client.ConverterHttp");
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object converter = constructor.newInstance(documentServicesEndpoint);
            Method method = converter.getClass().getMethod("convert", byte[].class, OutputStream.class);
            method.invoke(converter, tmpDocxFile.toByteArray(), baos);
            baos.close();
            log.debug("page numbers successfully received from service");
        }
        catch (Exception e) {
            throw new TocException("Error in toc web service at " + documentServicesEndpoint + "\n" + e.getMessage(), e);
        }
        byte[] json = baos.toByteArray();
        try {
            Class<?> clazz = Class.forName("org.docx4j.services.client.JsonUtil");
            Method method = clazz.getMethod("bytesToMap", byte[].class);
            Map map = (Map)method.invoke(null, new Object[]{json});
            log.debug("page number map size " + map.size());
            return map;
        }
        catch (Exception e) {
            throw new TocException("Error reading toc json; \n" + json + "\n" + e.getMessage(), e);
        }
    }

    private Map<String, Integer> getPageNumbersMapViaFOP() throws TocException {
        log.debug("getPageNumbersMapViaFOP() starting..");
        long start = System.currentTimeMillis();
        FOSettings foSettings = Docx4J.createFOSettings();
        try {
            foSettings.setOpcPackage(this.wordMLPackage);
        }
        catch (Docx4JException e1) {
            throw new TocException(e1.getMessage(), e1);
        }
        String MIME_FOP_AREA_TREE = "application/X-fop-areatree";
        foSettings.setApacheFopMime(MIME_FOP_AREA_TREE);
        foSettings.getFeatures().add("pp.apachefop.disablepagebreaklistitem");
        if (log.isDebugEnabled()) {
            foSettings.setFoDumpFile(new File(System.getProperty("user.dir") + "/Toc.fo"));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            FopReflective.invokeFORendererApacheFOP(foSettings);
            if (this.foViaXSLT) {
                Docx4J.toFO(foSettings, os, 1);
            } else {
                Docx4J.toFO(foSettings, os, 2);
            }
            long end = System.currentTimeMillis();
            float timing = (end - start) / 1000L;
            if (this.foViaXSLT) {
                log.debug("Time taken (AT via XSLT): " + Math.round(timing) + " sec");
            } else {
                log.debug("Time taken (AT via non XSLT): " + Math.round(timing) + " sec");
            }
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            TocPageNumbersHandler tpnh = new TocPageNumbersHandler();
            saxParser.parse((InputStream)is, (DefaultHandler)tpnh);
            return tpnh.getPageNumbers();
        }
        catch (Exception e) {
            throw new TocException(e.getMessage(), e);
        }
    }
}

