/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.hibernate.ConnectionAcquisitionMode;
import org.hibernate.ConnectionReleaseMode;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.EmptyInterceptor;
import org.hibernate.EntityMode;
import org.hibernate.EntityNameResolver;
import org.hibernate.HibernateException;
import org.hibernate.Interceptor;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.NullPrecedence;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.SchemaAutoTooling;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.TempTableDdlTransactionHandling;
import org.hibernate.boot.internal.DefaultCustomEntityDirtinessStrategy;
import org.hibernate.boot.internal.SessionFactoryOptionsImpl;
import org.hibernate.boot.internal.SessionFactoryOptionsState;
import org.hibernate.boot.internal.StandardEntityNotFoundDelegate;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.boot.spi.SessionFactoryBuilderImplementor;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.internal.NoCachingRegionFactory;
import org.hibernate.cache.internal.StandardQueryCacheFactory;
import org.hibernate.cache.spi.QueryCacheFactory;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cfg.BaselineSessionEventsListenerBuilder;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.engine.config.internal.ConfigurationServiceImpl;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.config.spi.StandardConverters;
import org.hibernate.engine.jdbc.env.spi.ExtractedDatabaseMetaData;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.hql.spi.id.MultiTableBulkIdStrategy;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.loader.BatchFetchStyle;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.ImmutableEntityUpdateQueryHandlingMode;
import org.hibernate.query.criteria.LiteralHandlingMode;
import org.hibernate.resource.jdbc.spi.PhysicalConnectionHandlingMode;
import org.hibernate.resource.jdbc.spi.StatementInspector;
import org.hibernate.resource.transaction.spi.TransactionCoordinatorBuilder;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.EntityTuplizerFactory;
import org.jboss.logging.Logger;

public class SessionFactoryBuilderImpl
implements SessionFactoryBuilderImplementor,
SessionFactoryOptionsState {
    private static final Logger log = Logger.getLogger(SessionFactoryBuilderImpl.class);
    private final MetadataImplementor metadata;
    private final SessionFactoryOptionsStateStandardImpl options;

    public SessionFactoryBuilderImpl(MetadataImplementor metadata) {
        this.metadata = metadata;
        this.options = new SessionFactoryOptionsStateStandardImpl(metadata.getMetadataBuildingOptions().getServiceRegistry());
        if (metadata.getSqlFunctionMap() != null) {
            for (Map.Entry<String, SQLFunction> sqlFunctionEntry : metadata.getSqlFunctionMap().entrySet()) {
                this.applySqlFunction(sqlFunctionEntry.getKey(), sqlFunctionEntry.getValue());
            }
        }
    }

    @Override
    public SessionFactoryBuilder applyValidatorFactory(Object validatorFactory) {
        this.options.validatorFactoryReference = validatorFactory;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyBeanManager(Object beanManager) {
        this.options.beanManagerReference = beanManager;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyName(String sessionFactoryName) {
        this.options.sessionFactoryName = sessionFactoryName;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyNameAsJndiName(boolean isJndiName) {
        this.options.sessionFactoryNameAlsoJndiName = isJndiName;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyAutoClosing(boolean enabled) {
        this.options.autoCloseSessionEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyAutoFlushing(boolean enabled) {
        this.options.flushBeforeCompletionEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyJtaTrackingByThread(boolean enabled) {
        this.options.jtaTrackByThread = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyPreferUserTransactions(boolean preferUserTransactions) {
        this.options.preferUserTransaction = preferUserTransactions;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyStatisticsSupport(boolean enabled) {
        this.options.statisticsEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder addSessionFactoryObservers(SessionFactoryObserver ... observers) {
        this.options.sessionFactoryObserverList.addAll(Arrays.asList(observers));
        return this;
    }

    @Override
    public SessionFactoryBuilder applyInterceptor(Interceptor interceptor) {
        this.options.interceptor = interceptor;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyStatelessInterceptor(Class<? extends Interceptor> statelessInterceptorClass) {
        this.options.statelessInterceptorClass = statelessInterceptorClass;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyStatelessInterceptor(Supplier<? extends Interceptor> statelessInterceptorSupplier) {
        this.options.statelessInterceptorSupplier = statelessInterceptorSupplier;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyStatementInspector(StatementInspector statementInspector) {
        this.options.statementInspector = statementInspector;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyCustomEntityDirtinessStrategy(CustomEntityDirtinessStrategy strategy) {
        this.options.customEntityDirtinessStrategy = strategy;
        return this;
    }

    @Override
    public SessionFactoryBuilder addEntityNameResolver(EntityNameResolver ... entityNameResolvers) {
        this.options.entityNameResolvers.addAll(Arrays.asList(entityNameResolvers));
        return this;
    }

    @Override
    public SessionFactoryBuilder applyEntityNotFoundDelegate(EntityNotFoundDelegate entityNotFoundDelegate) {
        this.options.entityNotFoundDelegate = entityNotFoundDelegate;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyIdentifierRollbackSupport(boolean enabled) {
        this.options.identifierRollbackEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyDefaultEntityMode(EntityMode entityMode) {
        this.options.defaultEntityMode = entityMode;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyNullabilityChecking(boolean enabled) {
        this.options.checkNullability = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyLazyInitializationOutsideTransaction(boolean enabled) {
        this.options.initializeLazyStateOutsideTransactions = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyEntityTuplizerFactory(EntityTuplizerFactory entityTuplizerFactory) {
        this.options.entityTuplizerFactory = entityTuplizerFactory;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyEntityTuplizer(EntityMode entityMode, Class<? extends EntityTuplizer> tuplizerClass) {
        this.options.entityTuplizerFactory.registerDefaultTuplizerClass(entityMode, tuplizerClass);
        return this;
    }

    @Override
    public SessionFactoryBuilder applyMultiTableBulkIdStrategy(MultiTableBulkIdStrategy strategy) {
        this.options.multiTableBulkIdStrategy = strategy;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyTempTableDdlTransactionHandling(TempTableDdlTransactionHandling handling) {
        this.options.tempTableDdlTransactionHandling = handling;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyBatchFetchStyle(BatchFetchStyle style) {
        this.options.batchFetchStyle = style;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyDefaultBatchFetchSize(int size) {
        this.options.defaultBatchFetchSize = size;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyMaximumFetchDepth(int depth) {
        this.options.maximumFetchDepth = depth;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyDefaultNullPrecedence(NullPrecedence nullPrecedence) {
        this.options.defaultNullPrecedence = nullPrecedence;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyOrderingOfInserts(boolean enabled) {
        this.options.orderInsertsEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyOrderingOfUpdates(boolean enabled) {
        this.options.orderUpdatesEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyMultiTenancyStrategy(MultiTenancyStrategy strategy) {
        this.options.multiTenancyStrategy = strategy;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyCurrentTenantIdentifierResolver(CurrentTenantIdentifierResolver resolver) {
        this.options.currentTenantIdentifierResolver = resolver;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyQuerySubstitutions(Map substitutions) {
        this.options.querySubstitutions.putAll(substitutions);
        return this;
    }

    @Override
    public SessionFactoryBuilder applyStrictJpaQueryLanguageCompliance(boolean enabled) {
        this.options.strictJpaQueryLanguageCompliance = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyNamedQueryCheckingOnStartup(boolean enabled) {
        this.options.namedQueryStartupCheckingEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applySecondLevelCacheSupport(boolean enabled) {
        this.options.secondLevelCacheEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyQueryCacheSupport(boolean enabled) {
        this.options.queryCacheEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyQueryCacheFactory(QueryCacheFactory factory) {
        this.options.queryCacheFactory = factory;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyCacheRegionPrefix(String prefix) {
        this.options.cacheRegionPrefix = prefix;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyMinimalPutsForCaching(boolean enabled) {
        this.options.minimalPutsEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyStructuredCacheEntries(boolean enabled) {
        this.options.structuredCacheEntriesEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyDirectReferenceCaching(boolean enabled) {
        this.options.directReferenceCacheEntriesEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyAutomaticEvictionOfCollectionCaches(boolean enabled) {
        this.options.autoEvictCollectionCache = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyJdbcBatchSize(int size) {
        this.options.jdbcBatchSize = size;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyJdbcBatchingForVersionedEntities(boolean enabled) {
        this.options.jdbcBatchVersionedData = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyScrollableResultsSupport(boolean enabled) {
        this.options.scrollableResultSetsEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyResultSetsWrapping(boolean enabled) {
        this.options.wrapResultSetsEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyGetGeneratedKeysSupport(boolean enabled) {
        this.options.getGeneratedKeysEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyJdbcFetchSize(int size) {
        this.options.jdbcFetchSize = size;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyConnectionHandlingMode(PhysicalConnectionHandlingMode connectionHandlingMode) {
        this.options.connectionHandlingMode = connectionHandlingMode;
        return this;
    }

    @Override
    public SessionFactoryBuilder applyConnectionReleaseMode(ConnectionReleaseMode connectionReleaseMode) {
        if (this.options.connectionHandlingMode == null) {
            this.options.connectionHandlingMode = PhysicalConnectionHandlingMode.interpret(ConnectionAcquisitionMode.AS_NEEDED, connectionReleaseMode);
        } else {
            this.options.connectionHandlingMode = PhysicalConnectionHandlingMode.interpret(this.options.connectionHandlingMode.getAcquisitionMode(), connectionReleaseMode);
        }
        return this;
    }

    @Override
    public SessionFactoryBuilder applyConnectionProviderDisablesAutoCommit(boolean providerDisablesAutoCommit) {
        this.options.connectionProviderDisablesAutoCommit = providerDisablesAutoCommit;
        return this;
    }

    @Override
    public SessionFactoryBuilder applySqlComments(boolean enabled) {
        this.options.commentsEnabled = enabled;
        return this;
    }

    @Override
    public SessionFactoryBuilder applySqlFunction(String registrationName, SQLFunction sqlFunction) {
        if (this.options.sqlFunctions == null) {
            this.options.sqlFunctions = new HashMap();
        }
        this.options.sqlFunctions.put(registrationName, sqlFunction);
        return this;
    }

    @Override
    public SessionFactoryBuilder allowOutOfTransactionUpdateOperations(boolean allow) {
        this.options.allowOutOfTransactionUpdateOperations = allow;
        return this;
    }

    @Override
    public SessionFactoryBuilder enableReleaseResourcesOnCloseEnabled(boolean enable) {
        this.options.releaseResourcesOnCloseEnabled = enable;
        return this;
    }

    @Override
    public <T extends SessionFactoryBuilder> T unwrap(Class<T> type) {
        return (T)this;
    }

    @Override
    public SessionFactory build() {
        this.metadata.validate();
        return new SessionFactoryImpl(this.metadata, this.buildSessionFactoryOptions());
    }

    @Override
    public void markAsJpaBootstrap() {
        this.options.jpaBootstrap = true;
    }

    @Override
    public void disableRefreshDetachedEntity() {
        this.options.allowRefreshDetachedEntity = false;
    }

    @Override
    public void disableJtaTransactionAccess() {
        this.options.jtaTransactionAccessEnabled = false;
    }

    @Override
    public SessionFactoryOptions buildSessionFactoryOptions() {
        return new SessionFactoryOptionsImpl(this);
    }

    private static Supplier<? extends Interceptor> interceptorSupplier(Class<? extends Interceptor> clazz) {
        return () -> {
            try {
                return (Interceptor)clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new HibernateException("Could not supply session-scoped SessionFactory Interceptor", e);
            }
        };
    }

    @Override
    public StandardServiceRegistry getServiceRegistry() {
        return this.options.getServiceRegistry();
    }

    @Override
    public boolean isJpaBootstrap() {
        return this.options.isJpaBootstrap();
    }

    @Override
    public boolean isJtaTransactionAccessEnabled() {
        return this.options.isJtaTransactionAccessEnabled();
    }

    @Override
    public boolean isAllowRefreshDetachedEntity() {
        return this.options.isAllowRefreshDetachedEntity();
    }

    @Override
    public boolean isAllowOutOfTransactionUpdateOperations() {
        return this.options.isAllowOutOfTransactionUpdateOperations();
    }

    @Override
    public boolean isReleaseResourcesOnCloseEnabled() {
        return this.options.releaseResourcesOnCloseEnabled;
    }

    @Override
    public Object getBeanManagerReference() {
        return this.options.getBeanManagerReference();
    }

    @Override
    public Object getValidatorFactoryReference() {
        return this.options.getValidatorFactoryReference();
    }

    @Override
    public String getSessionFactoryName() {
        return this.options.getSessionFactoryName();
    }

    @Override
    public boolean isSessionFactoryNameAlsoJndiName() {
        return this.options.isSessionFactoryNameAlsoJndiName();
    }

    @Override
    public boolean isFlushBeforeCompletionEnabled() {
        return this.options.isFlushBeforeCompletionEnabled();
    }

    @Override
    public boolean isAutoCloseSessionEnabled() {
        return this.options.isAutoCloseSessionEnabled();
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.options.isStatisticsEnabled();
    }

    @Override
    public Interceptor getInterceptor() {
        return this.options.getInterceptor();
    }

    @Override
    public Class<? extends Interceptor> getStatelessInterceptorImplementor() {
        return this.options.getStatelessInterceptorImplementor();
    }

    @Override
    public Supplier<? extends Interceptor> getStatelessInterceptorImplementorSupplier() {
        return this.options.getStatelessInterceptorImplementorSupplier();
    }

    @Override
    public StatementInspector getStatementInspector() {
        return this.options.getStatementInspector();
    }

    @Override
    public SessionFactoryObserver[] getSessionFactoryObservers() {
        return this.options.getSessionFactoryObservers();
    }

    @Override
    public BaselineSessionEventsListenerBuilder getBaselineSessionEventsListenerBuilder() {
        return this.options.getBaselineSessionEventsListenerBuilder();
    }

    @Override
    public boolean isIdentifierRollbackEnabled() {
        return this.options.isIdentifierRollbackEnabled();
    }

    @Override
    public EntityMode getDefaultEntityMode() {
        return this.options.getDefaultEntityMode();
    }

    @Override
    public EntityTuplizerFactory getEntityTuplizerFactory() {
        return this.options.getEntityTuplizerFactory();
    }

    @Override
    public boolean isCheckNullability() {
        return this.options.isCheckNullability();
    }

    @Override
    public boolean isInitializeLazyStateOutsideTransactionsEnabled() {
        return this.options.isInitializeLazyStateOutsideTransactionsEnabled();
    }

    @Override
    public MultiTableBulkIdStrategy getMultiTableBulkIdStrategy() {
        return this.options.getMultiTableBulkIdStrategy();
    }

    @Override
    public TempTableDdlTransactionHandling getTempTableDdlTransactionHandling() {
        return this.options.getTempTableDdlTransactionHandling();
    }

    @Override
    public BatchFetchStyle getBatchFetchStyle() {
        return this.options.getBatchFetchStyle();
    }

    @Override
    public int getDefaultBatchFetchSize() {
        return this.options.getDefaultBatchFetchSize();
    }

    @Override
    public Integer getMaximumFetchDepth() {
        return this.options.getMaximumFetchDepth();
    }

    @Override
    public NullPrecedence getDefaultNullPrecedence() {
        return this.options.getDefaultNullPrecedence();
    }

    @Override
    public boolean isOrderUpdatesEnabled() {
        return this.options.isOrderUpdatesEnabled();
    }

    @Override
    public boolean isOrderInsertsEnabled() {
        return this.options.isOrderInsertsEnabled();
    }

    @Override
    public MultiTenancyStrategy getMultiTenancyStrategy() {
        return this.options.getMultiTenancyStrategy();
    }

    @Override
    public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
        return this.options.getCurrentTenantIdentifierResolver();
    }

    @Override
    public boolean isJtaTrackByThread() {
        return this.options.isJtaTrackByThread();
    }

    @Override
    public Map getQuerySubstitutions() {
        return this.options.getQuerySubstitutions();
    }

    @Override
    public boolean isStrictJpaQueryLanguageCompliance() {
        return this.options.isStrictJpaQueryLanguageCompliance();
    }

    @Override
    public boolean isNamedQueryStartupCheckingEnabled() {
        return this.options.isNamedQueryStartupCheckingEnabled();
    }

    @Override
    public boolean isConventionalJavaConstants() {
        return this.options.isConventionalJavaConstants();
    }

    @Override
    public boolean isProcedureParameterNullPassingEnabled() {
        return this.options.isProcedureParameterNullPassingEnabled();
    }

    @Override
    public boolean isCollectionJoinSubqueryRewriteEnabled() {
        return this.options.isCollectionJoinSubqueryRewriteEnabled();
    }

    @Override
    public boolean isSecondLevelCacheEnabled() {
        return this.options.isSecondLevelCacheEnabled();
    }

    @Override
    public boolean isQueryCacheEnabled() {
        return this.options.isQueryCacheEnabled();
    }

    @Override
    public QueryCacheFactory getQueryCacheFactory() {
        return this.options.getQueryCacheFactory();
    }

    @Override
    public String getCacheRegionPrefix() {
        return this.options.getCacheRegionPrefix();
    }

    @Override
    public boolean isMinimalPutsEnabled() {
        return this.options.isMinimalPutsEnabled();
    }

    @Override
    public boolean isStructuredCacheEntriesEnabled() {
        return this.options.isStructuredCacheEntriesEnabled();
    }

    @Override
    public boolean isDirectReferenceCacheEntriesEnabled() {
        return this.options.isDirectReferenceCacheEntriesEnabled();
    }

    @Override
    public boolean isAutoEvictCollectionCache() {
        return this.options.isAutoEvictCollectionCache();
    }

    @Override
    public SchemaAutoTooling getSchemaAutoTooling() {
        return this.options.getSchemaAutoTooling();
    }

    @Override
    public int getJdbcBatchSize() {
        return this.options.getJdbcBatchSize();
    }

    @Override
    public boolean isJdbcBatchVersionedData() {
        return this.options.isJdbcBatchVersionedData();
    }

    @Override
    public boolean isScrollableResultSetsEnabled() {
        return this.options.isScrollableResultSetsEnabled();
    }

    @Override
    public boolean isWrapResultSetsEnabled() {
        return this.options.isWrapResultSetsEnabled();
    }

    @Override
    public boolean isGetGeneratedKeysEnabled() {
        return this.options.isGetGeneratedKeysEnabled();
    }

    @Override
    public Integer getJdbcFetchSize() {
        return this.options.getJdbcFetchSize();
    }

    @Override
    public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
        return this.options.getPhysicalConnectionHandlingMode();
    }

    @Override
    public boolean connectionProviderDisablesAutoCommit() {
        return this.options.connectionProviderDisablesAutoCommit();
    }

    @Override
    public ConnectionReleaseMode getConnectionReleaseMode() {
        return this.getPhysicalConnectionHandlingMode().getReleaseMode();
    }

    @Override
    public boolean isCommentsEnabled() {
        return this.options.isCommentsEnabled();
    }

    @Override
    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
        return this.options.getCustomEntityDirtinessStrategy();
    }

    @Override
    public EntityNameResolver[] getEntityNameResolvers() {
        return this.options.getEntityNameResolvers();
    }

    @Override
    public EntityNotFoundDelegate getEntityNotFoundDelegate() {
        return this.options.getEntityNotFoundDelegate();
    }

    @Override
    public Map<String, SQLFunction> getCustomSqlFunctionMap() {
        return this.options.getCustomSqlFunctionMap();
    }

    @Override
    public boolean isPreferUserTransaction() {
        return this.options.isPreferUserTransaction();
    }

    @Override
    public TimeZone getJdbcTimeZone() {
        return this.options.getJdbcTimeZone();
    }

    @Override
    public boolean isQueryParametersValidationEnabled() {
        return this.options.isQueryParametersValidationEnabled();
    }

    @Override
    public LiteralHandlingMode getCriteriaLiteralHandlingMode() {
        return this.options.getCriteriaLiteralHandlingMode();
    }

    @Override
    public boolean isFailOnPaginationOverCollectionFetchEnabled() {
        return this.options.isFailOnPaginationOverCollectionFetchEnabled();
    }

    @Override
    public boolean isJpaProxyComplianceEnabled() {
        return this.options.isJpaProxyComplianceEnabled();
    }

    @Override
    public ImmutableEntityUpdateQueryHandlingMode getImmutableEntityUpdateQueryHandlingMode() {
        return this.options.getImmutableEntityUpdateQueryHandlingMode();
    }

    @Override
    public boolean inClauseParameterPaddingEnabled() {
        return this.options.inClauseParameterPaddingEnabled();
    }

    public static class SessionFactoryOptionsStateStandardImpl
    implements SessionFactoryOptionsState {
        private final StandardServiceRegistry serviceRegistry;
        private Object beanManagerReference;
        private Object validatorFactoryReference;
        private boolean jpaBootstrap;
        private String sessionFactoryName;
        private boolean sessionFactoryNameAlsoJndiName;
        private boolean flushBeforeCompletionEnabled;
        private boolean autoCloseSessionEnabled;
        private boolean jtaTransactionAccessEnabled;
        private boolean allowOutOfTransactionUpdateOperations;
        private boolean releaseResourcesOnCloseEnabled;
        private boolean allowRefreshDetachedEntity;
        private boolean jtaTrackByThread;
        private boolean preferUserTransaction;
        private boolean statisticsEnabled;
        private Interceptor interceptor;
        private Class<? extends Interceptor> statelessInterceptorClass;
        private Supplier<? extends Interceptor> statelessInterceptorSupplier;
        private StatementInspector statementInspector;
        private List<SessionFactoryObserver> sessionFactoryObserverList = new ArrayList<SessionFactoryObserver>();
        private BaselineSessionEventsListenerBuilder baselineSessionEventsListenerBuilder;
        private CustomEntityDirtinessStrategy customEntityDirtinessStrategy;
        private List<EntityNameResolver> entityNameResolvers = new ArrayList<EntityNameResolver>();
        private EntityNotFoundDelegate entityNotFoundDelegate;
        private boolean identifierRollbackEnabled;
        private EntityMode defaultEntityMode;
        private EntityTuplizerFactory entityTuplizerFactory = new EntityTuplizerFactory();
        private boolean checkNullability;
        private boolean initializeLazyStateOutsideTransactions;
        private MultiTableBulkIdStrategy multiTableBulkIdStrategy;
        private TempTableDdlTransactionHandling tempTableDdlTransactionHandling;
        private BatchFetchStyle batchFetchStyle;
        private int defaultBatchFetchSize;
        private Integer maximumFetchDepth;
        private NullPrecedence defaultNullPrecedence;
        private boolean orderUpdatesEnabled;
        private boolean orderInsertsEnabled;
        private MultiTenancyStrategy multiTenancyStrategy;
        private CurrentTenantIdentifierResolver currentTenantIdentifierResolver;
        private Map querySubstitutions;
        private boolean strictJpaQueryLanguageCompliance;
        private boolean namedQueryStartupCheckingEnabled;
        private boolean conventionalJavaConstants;
        private final boolean procedureParameterNullPassingEnabled;
        private final boolean collectionJoinSubqueryRewriteEnabled;
        private boolean secondLevelCacheEnabled;
        private boolean queryCacheEnabled;
        private QueryCacheFactory queryCacheFactory;
        private String cacheRegionPrefix;
        private boolean minimalPutsEnabled;
        private boolean structuredCacheEntriesEnabled;
        private boolean directReferenceCacheEntriesEnabled;
        private boolean autoEvictCollectionCache;
        private SchemaAutoTooling schemaAutoTooling;
        private boolean getGeneratedKeysEnabled;
        private int jdbcBatchSize;
        private boolean jdbcBatchVersionedData;
        private Integer jdbcFetchSize;
        private boolean scrollableResultSetsEnabled;
        private boolean commentsEnabled;
        private PhysicalConnectionHandlingMode connectionHandlingMode;
        private boolean connectionProviderDisablesAutoCommit;
        private boolean wrapResultSetsEnabled;
        private TimeZone jdbcTimeZone;
        private boolean queryParametersValidationEnabled;
        private LiteralHandlingMode criteriaLiteralHandlingMode;
        private Map<String, SQLFunction> sqlFunctions;
        private boolean failOnPaginationOverCollectionFetchEnabled;
        private boolean jpaProxyComplianceEnabled;
        private ImmutableEntityUpdateQueryHandlingMode immutableEntityUpdateQueryHandlingMode;
        private boolean inClauseParameterPaddingEnabled;

        public SessionFactoryOptionsStateStandardImpl(StandardServiceRegistry serviceRegistry) {
            this.serviceRegistry = serviceRegistry;
            StrategySelector strategySelector = serviceRegistry.getService(StrategySelector.class);
            ConfigurationService cfgService = serviceRegistry.getService(ConfigurationService.class);
            JdbcServices jdbcServices = serviceRegistry.getService(JdbcServices.class);
            HashMap<Object, Object> configurationSettings = new HashMap<Object, Object>();
            configurationSettings.putAll(jdbcServices.getJdbcEnvironment().getDialect().getDefaultProperties());
            configurationSettings.putAll(cfgService.getSettings());
            cfgService = new ConfigurationServiceImpl(configurationSettings);
            ((ConfigurationServiceImpl)cfgService).injectServices((ServiceRegistryImplementor)((Object)serviceRegistry));
            this.beanManagerReference = configurationSettings.get("javax.persistence.bean.manager");
            this.validatorFactoryReference = configurationSettings.get("javax.persistence.validation.factory");
            this.sessionFactoryName = (String)configurationSettings.get("hibernate.session_factory_name");
            this.sessionFactoryNameAlsoJndiName = cfgService.getSetting("hibernate.session_factory_name_is_jndi", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.jtaTransactionAccessEnabled = cfgService.getSetting("hibernate.jta.allowTransactionAccess", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.allowRefreshDetachedEntity = cfgService.getSetting("hibernate.allow_refresh_detached_entity", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.flushBeforeCompletionEnabled = cfgService.getSetting("hibernate.transaction.flush_before_completion", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.autoCloseSessionEnabled = cfgService.getSetting("hibernate.transaction.auto_close_session", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.statisticsEnabled = cfgService.getSetting("hibernate.generate_statistics", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.interceptor = SessionFactoryOptionsStateStandardImpl.determineInterceptor(configurationSettings, strategySelector);
            this.statelessInterceptorSupplier = SessionFactoryOptionsStateStandardImpl.determineStatelessInterceptor(configurationSettings, strategySelector);
            this.statementInspector = strategySelector.resolveStrategy(StatementInspector.class, configurationSettings.get("hibernate.session_factory.statement_inspector"));
            String autoSessionEventsListenerName = (String)configurationSettings.get("hibernate.session.events.auto");
            Class<SessionEventListener> autoSessionEventsListener = autoSessionEventsListenerName == null ? null : strategySelector.selectStrategyImplementor(SessionEventListener.class, autoSessionEventsListenerName);
            boolean logSessionMetrics = cfgService.getSetting("hibernate.session.events.log", StandardConverters.BOOLEAN, Boolean.valueOf(this.statisticsEnabled));
            this.baselineSessionEventsListenerBuilder = new BaselineSessionEventsListenerBuilder(logSessionMetrics, autoSessionEventsListener);
            this.customEntityDirtinessStrategy = strategySelector.resolveDefaultableStrategy(CustomEntityDirtinessStrategy.class, configurationSettings.get("hibernate.entity_dirtiness_strategy"), DefaultCustomEntityDirtinessStrategy.INSTANCE);
            this.entityNotFoundDelegate = StandardEntityNotFoundDelegate.INSTANCE;
            this.identifierRollbackEnabled = cfgService.getSetting("hibernate.use_identifier_rollback", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.defaultEntityMode = EntityMode.parse((String)configurationSettings.get("hibernate.default_entity_mode"));
            this.checkNullability = cfgService.getSetting("hibernate.check_nullability", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.initializeLazyStateOutsideTransactions = cfgService.getSetting("hibernate.enable_lazy_load_no_trans", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.multiTenancyStrategy = MultiTenancyStrategy.determineMultiTenancyStrategy(configurationSettings);
            this.currentTenantIdentifierResolver = strategySelector.resolveStrategy(CurrentTenantIdentifierResolver.class, configurationSettings.get("hibernate.tenant_identifier_resolver"));
            this.multiTableBulkIdStrategy = strategySelector.resolveDefaultableStrategy(MultiTableBulkIdStrategy.class, configurationSettings.get("hibernate.hql.bulk_id_strategy"), jdbcServices.getJdbcEnvironment().getDialect().getDefaultMultiTableBulkIdStrategy());
            this.batchFetchStyle = BatchFetchStyle.interpret(configurationSettings.get("hibernate.batch_fetch_style"));
            this.defaultBatchFetchSize = ConfigurationHelper.getInt("hibernate.default_batch_fetch_size", configurationSettings, -1);
            this.maximumFetchDepth = ConfigurationHelper.getInteger("hibernate.max_fetch_depth", configurationSettings);
            String defaultNullPrecedence = ConfigurationHelper.getString("hibernate.order_by.default_null_ordering", configurationSettings, "none", "first", "last");
            this.defaultNullPrecedence = NullPrecedence.parse(defaultNullPrecedence);
            this.orderUpdatesEnabled = ConfigurationHelper.getBoolean("hibernate.order_updates", configurationSettings);
            this.orderInsertsEnabled = ConfigurationHelper.getBoolean("hibernate.order_inserts", configurationSettings);
            this.jtaTrackByThread = cfgService.getSetting("hibernate.jta.track_by_thread", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.querySubstitutions = ConfigurationHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", configurationSettings);
            this.strictJpaQueryLanguageCompliance = cfgService.getSetting("hibernate.query.jpaql_strict_compliance", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.namedQueryStartupCheckingEnabled = cfgService.getSetting("hibernate.query.startup_check", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.conventionalJavaConstants = cfgService.getSetting("hibernate.query.conventional_java_constants", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            this.procedureParameterNullPassingEnabled = cfgService.getSetting("hibernate.proc.param_null_passing", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            this.collectionJoinSubqueryRewriteEnabled = cfgService.getSetting("hibernate.collection_join_subquery", StandardConverters.BOOLEAN, Boolean.valueOf(true));
            RegionFactory regionFactory = serviceRegistry.getService(RegionFactory.class);
            if (!NoCachingRegionFactory.class.isInstance(regionFactory)) {
                this.secondLevelCacheEnabled = cfgService.getSetting("hibernate.cache.use_second_level_cache", StandardConverters.BOOLEAN, Boolean.valueOf(true));
                this.queryCacheEnabled = cfgService.getSetting("hibernate.cache.use_query_cache", StandardConverters.BOOLEAN, Boolean.valueOf(false));
                this.queryCacheFactory = strategySelector.resolveDefaultableStrategy(QueryCacheFactory.class, configurationSettings.get("hibernate.cache.query_cache_factory"), StandardQueryCacheFactory.INSTANCE);
                this.cacheRegionPrefix = ConfigurationHelper.extractPropertyValue("hibernate.cache.region_prefix", configurationSettings);
                this.minimalPutsEnabled = cfgService.getSetting("hibernate.cache.use_minimal_puts", StandardConverters.BOOLEAN, Boolean.valueOf(regionFactory.isMinimalPutsEnabledByDefault()));
                this.structuredCacheEntriesEnabled = cfgService.getSetting("hibernate.cache.use_structured_entries", StandardConverters.BOOLEAN, Boolean.valueOf(false));
                this.directReferenceCacheEntriesEnabled = cfgService.getSetting("hibernate.cache.use_reference_entries", StandardConverters.BOOLEAN, Boolean.valueOf(false));
                this.autoEvictCollectionCache = cfgService.getSetting("hibernate.cache.auto_evict_collection_cache", StandardConverters.BOOLEAN, Boolean.valueOf(false));
            } else {
                this.secondLevelCacheEnabled = false;
                this.queryCacheEnabled = false;
                this.queryCacheFactory = null;
                this.cacheRegionPrefix = null;
                this.minimalPutsEnabled = false;
                this.structuredCacheEntriesEnabled = false;
                this.directReferenceCacheEntriesEnabled = false;
                this.autoEvictCollectionCache = false;
            }
            try {
                this.schemaAutoTooling = SchemaAutoTooling.interpret((String)configurationSettings.get("hibernate.hbm2ddl.auto"));
            }
            catch (Exception e) {
                log.warn((Object)(e.getMessage() + "  Ignoring"));
            }
            ExtractedDatabaseMetaData meta = jdbcServices.getExtractedMetaDataSupport();
            this.tempTableDdlTransactionHandling = TempTableDdlTransactionHandling.NONE;
            if (meta.doesDataDefinitionCauseTransactionCommit()) {
                this.tempTableDdlTransactionHandling = meta.supportsDataDefinitionInTransaction() ? TempTableDdlTransactionHandling.ISOLATE_AND_TRANSACT : TempTableDdlTransactionHandling.ISOLATE;
            }
            this.jdbcBatchSize = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", configurationSettings, 0);
            if (!meta.supportsBatchUpdates()) {
                this.jdbcBatchSize = 0;
            }
            this.jdbcBatchVersionedData = ConfigurationHelper.getBoolean("hibernate.jdbc.batch_versioned_data", configurationSettings, true);
            this.scrollableResultSetsEnabled = ConfigurationHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", configurationSettings, meta.supportsScrollableResults());
            this.wrapResultSetsEnabled = ConfigurationHelper.getBoolean("hibernate.jdbc.wrap_result_sets", configurationSettings, false);
            this.getGeneratedKeysEnabled = ConfigurationHelper.getBoolean("hibernate.jdbc.use_get_generated_keys", configurationSettings, meta.supportsGetGeneratedKeys());
            this.jdbcFetchSize = ConfigurationHelper.getInteger("hibernate.jdbc.fetch_size", configurationSettings);
            this.connectionHandlingMode = this.interpretConnectionHandlingMode(configurationSettings, serviceRegistry);
            this.connectionProviderDisablesAutoCommit = ConfigurationHelper.getBoolean("hibernate.connection.provider_disables_autocommit", configurationSettings, false);
            this.commentsEnabled = ConfigurationHelper.getBoolean("hibernate.use_sql_comments", configurationSettings);
            this.preferUserTransaction = ConfigurationHelper.getBoolean("hibernate.jta.prefer_user_transaction", configurationSettings, false);
            this.allowOutOfTransactionUpdateOperations = ConfigurationHelper.getBoolean("hibernate.allow_update_outside_transaction", configurationSettings, false);
            this.releaseResourcesOnCloseEnabled = ConfigurationHelper.getBoolean("hibernate.ejb.discard_pc_on_close", configurationSettings, false);
            Object jdbcTimeZoneValue = configurationSettings.get("hibernate.jdbc.time_zone");
            if (jdbcTimeZoneValue instanceof TimeZone) {
                this.jdbcTimeZone = (TimeZone)jdbcTimeZoneValue;
            } else if (jdbcTimeZoneValue instanceof ZoneId) {
                this.jdbcTimeZone = TimeZone.getTimeZone((ZoneId)jdbcTimeZoneValue);
            } else if (jdbcTimeZoneValue instanceof String) {
                this.jdbcTimeZone = TimeZone.getTimeZone(ZoneId.of((String)jdbcTimeZoneValue));
            } else if (jdbcTimeZoneValue != null) {
                throw new IllegalArgumentException("Configuration property hibernate.jdbc.time_zone value [" + jdbcTimeZoneValue + "] is not supported!");
            }
            this.queryParametersValidationEnabled = ConfigurationHelper.getBoolean("hibernate.query.validate_parameters", configurationSettings, true);
            this.criteriaLiteralHandlingMode = LiteralHandlingMode.interpret(configurationSettings.get("hibernate.criteria.literal_handling_mode"));
            this.failOnPaginationOverCollectionFetchEnabled = ConfigurationHelper.getBoolean("hibernate.query.fail_on_pagination_over_collection_fetch", configurationSettings, false);
            this.jpaProxyComplianceEnabled = ConfigurationHelper.getBoolean("hibernate.jpa.compliance.proxy", configurationSettings, false);
            this.immutableEntityUpdateQueryHandlingMode = ImmutableEntityUpdateQueryHandlingMode.interpret(configurationSettings.get("hibernate.query.immutable_entity_update_query_handling_mode"));
            this.inClauseParameterPaddingEnabled = ConfigurationHelper.getBoolean("hibernate.query.in_clause_parameter_padding", configurationSettings, false);
        }

        private static Interceptor determineInterceptor(Map configurationSettings, StrategySelector strategySelector) {
            Object setting = configurationSettings.get("hibernate.session_factory.interceptor");
            if (setting == null && (setting = configurationSettings.get("hibernate.ejb.interceptor")) != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.ejb.interceptor", "hibernate.session_factory.interceptor");
            }
            return strategySelector.resolveStrategy(Interceptor.class, setting);
        }

        private static Supplier<? extends Interceptor> determineStatelessInterceptor(Map configurationSettings, StrategySelector strategySelector) {
            Object setting = configurationSettings.get("hibernate.session_factory.session_scoped_interceptor");
            if (setting == null && (setting = configurationSettings.get("hibernate.ejb.interceptor.session_scoped")) != null) {
                DeprecationLogger.DEPRECATION_LOGGER.deprecatedSetting("hibernate.ejb.interceptor.session_scoped", "hibernate.session_factory.session_scoped_interceptor");
            }
            if (setting == null) {
                return null;
            }
            if (setting instanceof Supplier) {
                return (Supplier)setting;
            }
            if (setting instanceof Class) {
                Class clazz = (Class)setting;
                return SessionFactoryBuilderImpl.interceptorSupplier(clazz);
            }
            return SessionFactoryBuilderImpl.interceptorSupplier(strategySelector.selectStrategyImplementor(Interceptor.class, setting.toString()));
        }

        private PhysicalConnectionHandlingMode interpretConnectionHandlingMode(Map configurationSettings, StandardServiceRegistry serviceRegistry) {
            PhysicalConnectionHandlingMode specifiedHandlingMode = PhysicalConnectionHandlingMode.interpret(configurationSettings.get("hibernate.connection.handling_mode"));
            if (specifiedHandlingMode != null) {
                return specifiedHandlingMode;
            }
            TransactionCoordinatorBuilder transactionCoordinatorBuilder = serviceRegistry.getService(TransactionCoordinatorBuilder.class);
            ConnectionAcquisitionMode specifiedAcquisitionMode = ConnectionAcquisitionMode.interpret(configurationSettings.get("hibernate.connection.acquisition_mode"));
            ConnectionReleaseMode specifiedReleaseMode = ConnectionReleaseMode.interpret(configurationSettings.get("hibernate.connection.release_mode"));
            if (specifiedAcquisitionMode != null || specifiedReleaseMode != null) {
                return this.interpretConnectionHandlingMode(specifiedAcquisitionMode, specifiedReleaseMode, configurationSettings, transactionCoordinatorBuilder);
            }
            return transactionCoordinatorBuilder.getDefaultConnectionHandlingMode();
        }

        @Deprecated
        private PhysicalConnectionHandlingMode interpretConnectionHandlingMode(ConnectionAcquisitionMode specifiedAcquisitionMode, ConnectionReleaseMode specifiedReleaseMode, Map configurationSettings, TransactionCoordinatorBuilder transactionCoordinatorBuilder) {
            ConnectionReleaseMode effectiveReleaseMode;
            ConnectionAcquisitionMode effectiveAcquisitionMode;
            DeprecationLogger.DEPRECATION_LOGGER.logUseOfDeprecatedConnectionHandlingSettings();
            ConnectionAcquisitionMode connectionAcquisitionMode = effectiveAcquisitionMode = specifiedAcquisitionMode == null ? ConnectionAcquisitionMode.AS_NEEDED : specifiedAcquisitionMode;
            if (specifiedReleaseMode == null) {
                String releaseModeName = ConfigurationHelper.getString("hibernate.connection.release_mode", configurationSettings, "auto");
                assert ("auto".equalsIgnoreCase(releaseModeName));
                effectiveReleaseMode = effectiveAcquisitionMode == ConnectionAcquisitionMode.IMMEDIATELY ? ConnectionReleaseMode.ON_CLOSE : transactionCoordinatorBuilder.getDefaultConnectionReleaseMode();
            } else {
                effectiveReleaseMode = specifiedReleaseMode;
            }
            return PhysicalConnectionHandlingMode.interpret(effectiveAcquisitionMode, effectiveReleaseMode);
        }

        @Override
        public StandardServiceRegistry getServiceRegistry() {
            return this.serviceRegistry;
        }

        @Override
        public boolean isJpaBootstrap() {
            return this.jpaBootstrap;
        }

        @Override
        public boolean isJtaTransactionAccessEnabled() {
            return this.jtaTransactionAccessEnabled;
        }

        @Override
        public boolean isAllowRefreshDetachedEntity() {
            return this.allowRefreshDetachedEntity;
        }

        @Override
        public boolean isAllowOutOfTransactionUpdateOperations() {
            return this.allowOutOfTransactionUpdateOperations;
        }

        @Override
        public boolean isReleaseResourcesOnCloseEnabled() {
            return this.releaseResourcesOnCloseEnabled;
        }

        @Override
        public Object getBeanManagerReference() {
            return this.beanManagerReference;
        }

        @Override
        public Object getValidatorFactoryReference() {
            return this.validatorFactoryReference;
        }

        @Override
        public String getSessionFactoryName() {
            return this.sessionFactoryName;
        }

        @Override
        public boolean isSessionFactoryNameAlsoJndiName() {
            return this.sessionFactoryNameAlsoJndiName;
        }

        @Override
        public boolean isFlushBeforeCompletionEnabled() {
            return this.flushBeforeCompletionEnabled;
        }

        @Override
        public boolean isAutoCloseSessionEnabled() {
            return this.autoCloseSessionEnabled;
        }

        @Override
        public boolean isStatisticsEnabled() {
            return this.statisticsEnabled;
        }

        @Override
        public Interceptor getInterceptor() {
            return this.interceptor == null ? EmptyInterceptor.INSTANCE : this.interceptor;
        }

        @Override
        public Class<? extends Interceptor> getStatelessInterceptorImplementor() {
            return this.statelessInterceptorClass;
        }

        @Override
        public Supplier<? extends Interceptor> getStatelessInterceptorImplementorSupplier() {
            return this.statelessInterceptorSupplier;
        }

        @Override
        public StatementInspector getStatementInspector() {
            return this.statementInspector;
        }

        @Override
        public SessionFactoryObserver[] getSessionFactoryObservers() {
            return this.sessionFactoryObserverList.toArray(new SessionFactoryObserver[this.sessionFactoryObserverList.size()]);
        }

        @Override
        public BaselineSessionEventsListenerBuilder getBaselineSessionEventsListenerBuilder() {
            return this.baselineSessionEventsListenerBuilder;
        }

        @Override
        public boolean isIdentifierRollbackEnabled() {
            return this.identifierRollbackEnabled;
        }

        @Override
        public EntityMode getDefaultEntityMode() {
            return this.defaultEntityMode;
        }

        @Override
        public EntityTuplizerFactory getEntityTuplizerFactory() {
            return this.entityTuplizerFactory;
        }

        @Override
        public boolean isCheckNullability() {
            return this.checkNullability;
        }

        @Override
        public boolean isInitializeLazyStateOutsideTransactionsEnabled() {
            return this.initializeLazyStateOutsideTransactions;
        }

        @Override
        public MultiTableBulkIdStrategy getMultiTableBulkIdStrategy() {
            return this.multiTableBulkIdStrategy;
        }

        @Override
        public TempTableDdlTransactionHandling getTempTableDdlTransactionHandling() {
            return this.tempTableDdlTransactionHandling;
        }

        @Override
        public BatchFetchStyle getBatchFetchStyle() {
            return this.batchFetchStyle;
        }

        @Override
        public int getDefaultBatchFetchSize() {
            return this.defaultBatchFetchSize;
        }

        @Override
        public Integer getMaximumFetchDepth() {
            return this.maximumFetchDepth;
        }

        @Override
        public NullPrecedence getDefaultNullPrecedence() {
            return this.defaultNullPrecedence;
        }

        @Override
        public boolean isOrderUpdatesEnabled() {
            return this.orderUpdatesEnabled;
        }

        @Override
        public boolean isOrderInsertsEnabled() {
            return this.orderInsertsEnabled;
        }

        @Override
        public MultiTenancyStrategy getMultiTenancyStrategy() {
            return this.multiTenancyStrategy;
        }

        @Override
        public CurrentTenantIdentifierResolver getCurrentTenantIdentifierResolver() {
            return this.currentTenantIdentifierResolver;
        }

        @Override
        public boolean isJtaTrackByThread() {
            return this.jtaTrackByThread;
        }

        @Override
        public Map getQuerySubstitutions() {
            return this.querySubstitutions;
        }

        @Override
        public boolean isStrictJpaQueryLanguageCompliance() {
            return this.strictJpaQueryLanguageCompliance;
        }

        @Override
        public boolean isNamedQueryStartupCheckingEnabled() {
            return this.namedQueryStartupCheckingEnabled;
        }

        @Override
        public boolean isConventionalJavaConstants() {
            return this.conventionalJavaConstants;
        }

        @Override
        public boolean isProcedureParameterNullPassingEnabled() {
            return this.procedureParameterNullPassingEnabled;
        }

        @Override
        public boolean isCollectionJoinSubqueryRewriteEnabled() {
            return this.collectionJoinSubqueryRewriteEnabled;
        }

        @Override
        public boolean isSecondLevelCacheEnabled() {
            return this.secondLevelCacheEnabled;
        }

        @Override
        public boolean isQueryCacheEnabled() {
            return this.queryCacheEnabled;
        }

        @Override
        public QueryCacheFactory getQueryCacheFactory() {
            return this.queryCacheFactory;
        }

        @Override
        public String getCacheRegionPrefix() {
            return this.cacheRegionPrefix;
        }

        @Override
        public boolean isMinimalPutsEnabled() {
            return this.minimalPutsEnabled;
        }

        @Override
        public boolean isStructuredCacheEntriesEnabled() {
            return this.structuredCacheEntriesEnabled;
        }

        @Override
        public boolean isDirectReferenceCacheEntriesEnabled() {
            return this.directReferenceCacheEntriesEnabled;
        }

        @Override
        public boolean isAutoEvictCollectionCache() {
            return this.autoEvictCollectionCache;
        }

        @Override
        public SchemaAutoTooling getSchemaAutoTooling() {
            return this.schemaAutoTooling;
        }

        @Override
        public int getJdbcBatchSize() {
            return this.jdbcBatchSize;
        }

        @Override
        public boolean isJdbcBatchVersionedData() {
            return this.jdbcBatchVersionedData;
        }

        @Override
        public boolean isScrollableResultSetsEnabled() {
            return this.scrollableResultSetsEnabled;
        }

        @Override
        public boolean isWrapResultSetsEnabled() {
            return this.wrapResultSetsEnabled;
        }

        @Override
        public boolean isGetGeneratedKeysEnabled() {
            return this.getGeneratedKeysEnabled;
        }

        @Override
        public Integer getJdbcFetchSize() {
            return this.jdbcFetchSize;
        }

        @Override
        public PhysicalConnectionHandlingMode getPhysicalConnectionHandlingMode() {
            return this.connectionHandlingMode;
        }

        @Override
        public boolean connectionProviderDisablesAutoCommit() {
            return this.connectionProviderDisablesAutoCommit;
        }

        @Override
        public ConnectionReleaseMode getConnectionReleaseMode() {
            return this.getPhysicalConnectionHandlingMode().getReleaseMode();
        }

        @Override
        public boolean isCommentsEnabled() {
            return this.commentsEnabled;
        }

        @Override
        public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy() {
            return this.customEntityDirtinessStrategy;
        }

        @Override
        public EntityNameResolver[] getEntityNameResolvers() {
            return this.entityNameResolvers.toArray(new EntityNameResolver[this.entityNameResolvers.size()]);
        }

        @Override
        public EntityNotFoundDelegate getEntityNotFoundDelegate() {
            return this.entityNotFoundDelegate;
        }

        @Override
        public Map<String, SQLFunction> getCustomSqlFunctionMap() {
            return this.sqlFunctions == null ? Collections.emptyMap() : this.sqlFunctions;
        }

        @Override
        public boolean isPreferUserTransaction() {
            return this.preferUserTransaction;
        }

        @Override
        public TimeZone getJdbcTimeZone() {
            return this.jdbcTimeZone;
        }

        @Override
        public boolean isQueryParametersValidationEnabled() {
            return this.queryParametersValidationEnabled;
        }

        @Override
        public LiteralHandlingMode getCriteriaLiteralHandlingMode() {
            return this.criteriaLiteralHandlingMode;
        }

        @Override
        public boolean isFailOnPaginationOverCollectionFetchEnabled() {
            return this.failOnPaginationOverCollectionFetchEnabled;
        }

        @Override
        public boolean isJpaProxyComplianceEnabled() {
            return this.jpaProxyComplianceEnabled;
        }

        @Override
        public ImmutableEntityUpdateQueryHandlingMode getImmutableEntityUpdateQueryHandlingMode() {
            return this.immutableEntityUpdateQueryHandlingMode;
        }

        @Override
        public boolean inClauseParameterPaddingEnabled() {
            return this.inClauseParameterPaddingEnabled;
        }
    }
}

