
<%@ page import="org.pih.warehouse.core.Person" %>
<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="layout" content="custom" />
        <g:set var="entityName" value="${warehouse.message(code: 'person.label', default: 'Person')}" />
        <title><warehouse:message code="default.show.label" args="[entityName]" /></title>
        <!-- Specify content to overload like global navigation links, page titles, etc. -->
		<content tag="pageTitle"><warehouse:message code="default.show.label" args="[entityName]" /></content>
    </head>
    <body>
        <div class="body">
            <g:if test="${flash.message}">
	            <div class="message" role="status" aria-label="message">${flash.message}</div>
            </g:if>
            <div class="dialog">
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="person.id.label" default="Id" /></td>

                            <td valign="top" class="value">${fieldValue(bean: personInstance, field: "id")}</td>

                        </tr>
						<tr class="prop">
                            <td valign="top" class="name">
                                <warehouse:message code="person.type.label" default="Type" />
                            </td>
                            <td valign="top" class="value">
								${personInstance?.class?.simpleName}
                            </td>
                        </tr>


                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="person.name.label" default="Name" /></td>

                            <td valign="top" class="value">${fieldValue(bean: personInstance, field: "name")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="person.firstName.label" default="First Name" /></td>

                            <td valign="top" class="value">${fieldValue(bean: personInstance, field: "firstName")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="person.lastName.label" default="Last Name" /></td>

                            <td valign="top" class="value">${fieldValue(bean: personInstance, field: "lastName")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="person.email.label" default="Email" /></td>

                            <td valign="top" class="value">${fieldValue(bean: personInstance, field: "email")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="person.phoneNumber.label" default="Phone Number" /></td>

                            <td valign="top" class="value">${fieldValue(bean: personInstance, field: "phoneNumber")}</td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="default.dateCreated.label" default="Date Created" /></td>

                            <td valign="top" class="value"><format:datetime obj="${personInstance?.dateCreated}" /></td>

                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name"><warehouse:message code="default.lastUpdated.label" default="Last Updated" /></td>

                            <td valign="top" class="value"><format:datetime obj="${personInstance?.lastUpdated}" /></td>

                        </tr>


						<tr class="prop">
                        	<td valign="top"></td>
                        	<td valign="top">
					            <div class="buttons">
					                <g:form>
					                    <g:hiddenField name="id" value="${personInstance?.id}" />
					                    <g:actionSubmit class="edit" action="edit" value="${warehouse.message(code: 'default.button.edit.label', default: 'Edit')}" />
					                    <g:actionSubmit class="delete" action="delete" value="${warehouse.message(code: 'default.button.delete.label', default: 'Delete')}" onclick="return confirm('${warehouse.message(code: 'default.button.delete.confirm.message', default: 'Are you sure?')}');" />
					                </g:form>
					            </div>
							</td>
						</tr>
                    </tbody>
                </table>
            </div>
        </div>
    </body>
</html>
