/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.html;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.textstyling.html.HTMLColorParser;
import fr.opensagres.xdocreport.document.textstyling.properties.ContainerProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.HeaderProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListItemProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ParagraphProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.SpanProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableCellProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TableRowProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.TextAlignment;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;

public class StylesHelper {
    public static Map<String, String> parse(String style) {
        if (StringUtils.isEmpty((String)style)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> stylesMap = new HashMap<String, String>();
        String[] styles = style.split(";");
        String s = null;
        int index = 0;
        String name = null;
        String value = null;
        for (int i = 0; i < styles.length; ++i) {
            name = null;
            value = null;
            s = styles[i];
            index = s.indexOf(58);
            if (index == -1) continue;
            name = s.substring(0, index).trim();
            value = s.substring(index + 1, s.length()).trim();
            stylesMap.put(name, value);
        }
        return stylesMap;
    }

    public static ParagraphProperties createParagraphProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            ParagraphProperties properties = new ParagraphProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static HeaderProperties createHeaderProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            HeaderProperties properties = new HeaderProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static ListItemProperties createListItemProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            ListItemProperties properties = new ListItemProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static ListProperties createListProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            ListProperties properties = new ListProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    public static SpanProperties createSpanProperties(String style) {
        Map<String, String> stylesMap = StylesHelper.parse(style);
        if (!stylesMap.isEmpty()) {
            SpanProperties properties = new SpanProperties();
            StylesHelper.processContainerproperties(properties, stylesMap);
            return properties;
        }
        return null;
    }

    private static void processContainerproperties(ContainerProperties properties, Map<String, String> stylesMap) {
        String styleName;
        String color;
        String textAlignment;
        properties.setPageBreakBefore(false);
        if ("always".equals(stylesMap.get("page-break-before"))) {
            properties.setPageBreakBefore(true);
        }
        properties.setPageBreakAfter(false);
        if ("always".equals(stylesMap.get("page-break-after"))) {
            properties.setPageBreakAfter(true);
        }
        String fontWeight = stylesMap.get("font-weight");
        properties.setBold(false);
        if (fontWeight != null && ("bold".equals(fontWeight) || "700".equals(fontWeight))) {
            properties.setBold(true);
        }
        String fontStyle = stylesMap.get("font-style");
        properties.setItalic(false);
        if (fontStyle != null && "italic".equals(fontStyle)) {
            properties.setItalic(true);
        }
        String textDecoration = stylesMap.get("text-decoration");
        properties.setStrike(false);
        properties.setUnderline(false);
        if (textDecoration != null) {
            if (textDecoration.contains("underline")) {
                properties.setUnderline(true);
            }
            if (textDecoration.contains("line-through")) {
                properties.setStrike(true);
            }
        }
        String verticalAlign = stylesMap.get("vertical-align");
        properties.setSuperscript(false);
        properties.setSubscript(false);
        if (verticalAlign != null) {
            if ("sub".equals(verticalAlign)) {
                properties.setSubscript(true);
            } else if ("super".equals(verticalAlign)) {
                properties.setSuperscript(true);
            }
        }
        if ((textAlignment = stylesMap.get("text-align")) != null) {
            if ("left".equals(textAlignment)) {
                properties.setTextAlignment(TextAlignment.Left);
            } else if ("center".equals(textAlignment)) {
                properties.setTextAlignment(TextAlignment.Center);
            } else if ("right".equals(textAlignment)) {
                properties.setTextAlignment(TextAlignment.Right);
            } else if ("justify".equals(textAlignment)) {
                properties.setTextAlignment(TextAlignment.Justify);
            } else if ("inherit".equals(textAlignment)) {
                properties.setTextAlignment(TextAlignment.Inherit);
            }
        }
        if ((color = stylesMap.get("color")) != null) {
            properties.setColor(HTMLColorParser.parse(color));
        }
        if ((styleName = stylesMap.get("name")) != null) {
            properties.setStyleName(styleName);
        }
    }

    public static TableProperties createTableProperties(Attributes attributes) {
        TableProperties properties = new TableProperties();
        return properties;
    }

    public static TableRowProperties createTableRowProperties(Attributes attributes) {
        TableRowProperties properties = new TableRowProperties();
        return properties;
    }

    public static TableCellProperties createTableCellProperties(Attributes attributes) {
        TableCellProperties properties = new TableCellProperties();
        return properties;
    }
}

