/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.RanChangeSet;
import liquibase.command.AbstractCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;

public class HistoryCommand
extends AbstractCommand {
    private Database database;
    private DateFormat dateFormat;
    private PrintStream outputStream = System.out;

    public HistoryCommand() {
        this.dateFormat = DateFormat.getDateTimeInstance(3, 3);
    }

    @Override
    public String getName() {
        return "history";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public Database getDatabase() {
        return this.database;
    }

    public void setDatabase(Database database) {
        this.database = database;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    protected CommandResult run() throws Exception {
        ChangeLogHistoryService historyService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        this.outputStream.println("Liquibase History for " + this.database.getConnection().getURL());
        this.outputStream.println("");
        DeploymentDetails deployment = null;
        for (RanChangeSet ranChangeSet : historyService.getRanChangeSets()) {
            String thisDeploymentId = ranChangeSet.getDeploymentId();
            if (deployment == null || !Objects.equals(thisDeploymentId, deployment.getDeploymentId())) {
                if (deployment != null) {
                    deployment.printReport();
                }
                deployment = new DeploymentDetails();
            }
            deployment.changeSets.add(ranChangeSet);
        }
        if (deployment == null) {
            this.outputStream.println("No changeSets deployed");
        } else {
            deployment.printReport();
        }
        return new CommandResult("OK");
    }

    private class DeploymentDetails {
        List<RanChangeSet> changeSets = new ArrayList<RanChangeSet>();

        private DeploymentDetails() {
        }

        void printReport() {
            String executionTime = null;
            RanChangeSet firstChangeSet = this.changeSets.get(0);
            if (this.changeSets.size() > 1) {
                RanChangeSet last = this.changeSets.get(this.changeSets.size() - 1);
                long executionMs = last.getDateExecuted().getTime() - firstChangeSet.getDateExecuted().getTime();
                executionTime = (float)executionMs / 1000.0f + "s";
            }
            String message = "- Database updated at " + HistoryCommand.this.dateFormat.format(firstChangeSet.getDateExecuted()) + ". Applied " + this.changeSets.size() + " changeSet(s)";
            if (executionTime != null) {
                message = message + " in " + executionTime;
            }
            message = message + ", DeploymentId: " + firstChangeSet.getDeploymentId();
            HistoryCommand.this.outputStream.println(message);
            for (RanChangeSet changeSet : this.changeSets) {
                HistoryCommand.this.outputStream.println("  " + changeSet.toString());
            }
            HistoryCommand.this.outputStream.println("");
        }

        String getDeploymentId() {
            if (this.changeSets.size() == 0) {
                return null;
            }
            return this.changeSets.get(0).getDeploymentId();
        }
    }
}

