/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.org.apache.fop.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.xmlgraphics.util.QName;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLResourceBundle
extends ResourceBundle {
    private Properties resources = new Properties();
    private Locale locale;
    private static SAXTransformerFactory tFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private static final ResourceBundle MISSING = new MissingBundle();
    private static final ResourceBundle MISSINGBASE = new MissingBundle();
    private static Map cache = new WeakHashMap();

    public XMLResourceBundle(InputStream in) throws IOException {
        try {
            Transformer transformer = tFactory.newTransformer();
            StreamSource src = new StreamSource(in);
            SAXResult res = new SAXResult(new CatalogueHandler());
            transformer.transform(src, res);
        }
        catch (TransformerException e) {
            throw new IOException("Error while parsing XML resource bundle: " + e.getMessage());
        }
    }

    public static ResourceBundle getXMLBundle(String baseName, ClassLoader loader) throws MissingResourceException {
        return XMLResourceBundle.getXMLBundle(baseName, Locale.getDefault(), loader);
    }

    public static ResourceBundle getXMLBundle(String baseName, Locale locale, ClassLoader loader) throws MissingResourceException {
        ResourceBundle bundle;
        if (loader == null) {
            throw new NullPointerException("loader must not be null");
        }
        if (baseName == null) {
            throw new NullPointerException("baseName must not be null");
        }
        assert (locale != null);
        if (!locale.equals(Locale.getDefault()) && (bundle = XMLResourceBundle.handleGetXMLBundle(baseName, "_" + locale, false, loader)) != null) {
            return bundle;
        }
        bundle = XMLResourceBundle.handleGetXMLBundle(baseName, "_" + Locale.getDefault(), true, loader);
        if (bundle != null) {
            return bundle;
        }
        throw new MissingResourceException(baseName + " (" + locale + ")", baseName + '_' + locale, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceBundle handleGetXMLBundle(String base, String locale, boolean loadBase, final ClassLoader loader) {
        ResourceBundle fallback;
        Hashtable<String, ResourceBundle> loaderCache;
        XMLResourceBundle bundle = null;
        String bundleName = base + locale;
        Object cacheKey = loader != null ? loader : "null";
        Map map = cache;
        synchronized (map) {
            loaderCache = (Hashtable<String, ResourceBundle>)cache.get(cacheKey);
            if (loaderCache == null) {
                loaderCache = new Hashtable<String, ResourceBundle>();
                cache.put(cacheKey, loaderCache);
            }
        }
        ResourceBundle result = (ResourceBundle)loaderCache.get(bundleName);
        if (result != null) {
            if (result == MISSINGBASE) {
                return null;
            }
            if (result == MISSING) {
                if (!loadBase) {
                    return null;
                }
                String extension = XMLResourceBundle.strip(locale);
                if (extension == null) {
                    return null;
                }
                return XMLResourceBundle.handleGetXMLBundle(base, extension, loadBase, loader);
            }
            return result;
        }
        final String fileName = bundleName.replace('.', '/') + ".xml";
        InputStream stream = (InputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return loader == null ? ClassLoader.getSystemResourceAsStream(fileName) : loader.getResourceAsStream(fileName);
            }
        });
        if (stream != null) {
            try {
                try {
                    bundle = new XMLResourceBundle(stream);
                }
                finally {
                    stream.close();
                }
                bundle.setLocale(locale);
            }
            catch (IOException e) {
                throw new MissingResourceException(e.getMessage(), base, null);
            }
        }
        String extension = XMLResourceBundle.strip(locale);
        if (bundle != null) {
            ResourceBundle parent;
            if (extension != null && (parent = XMLResourceBundle.handleGetXMLBundle(base, extension, true, loader)) != null) {
                bundle.setParent(parent);
            }
            loaderCache.put(bundleName, bundle);
            return bundle;
        }
        if (extension != null && (fallback = XMLResourceBundle.handleGetXMLBundle(base, extension, loadBase, loader)) != null) {
            loaderCache.put(bundleName, fallback);
            return fallback;
        }
        loaderCache.put(bundleName, loadBase ? MISSINGBASE : MISSING);
        return null;
    }

    private void setLocale(String name) {
        String language = "";
        String country = "";
        String variant = "";
        if (name.length() > 1) {
            int nextIndex = name.indexOf(95, 1);
            if (nextIndex == -1) {
                nextIndex = name.length();
            }
            language = name.substring(1, nextIndex);
            if (nextIndex + 1 < name.length()) {
                int index = nextIndex;
                if ((nextIndex = name.indexOf(95, nextIndex + 1)) == -1) {
                    nextIndex = name.length();
                }
                country = name.substring(index + 1, nextIndex);
                if (nextIndex + 1 < name.length()) {
                    variant = name.substring(nextIndex + 1, name.length());
                }
            }
        }
        this.locale = new Locale(language, country, variant);
    }

    private static String strip(String name) {
        int index = name.lastIndexOf(95);
        if (index != -1) {
            return name.substring(0, index);
        }
        return null;
    }

    private Enumeration getLocalKeys() {
        return this.resources.propertyNames();
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    public Enumeration getKeys() {
        if (this.parent == null) {
            return this.getLocalKeys();
        }
        return new Enumeration(){
            private Enumeration local;
            private Enumeration pEnum;
            private Object nextElement;
            {
                this.local = XMLResourceBundle.this.getLocalKeys();
                this.pEnum = XMLResourceBundle.this.parent.getKeys();
            }

            private boolean findNext() {
                if (this.nextElement != null) {
                    return true;
                }
                while (this.pEnum.hasMoreElements()) {
                    Object next = this.pEnum.nextElement();
                    if (XMLResourceBundle.this.resources.containsKey(next)) continue;
                    this.nextElement = next;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                if (this.local.hasMoreElements()) {
                    return true;
                }
                return this.findNext();
            }

            public Object nextElement() {
                if (this.local.hasMoreElements()) {
                    return this.local.nextElement();
                }
                if (this.findNext()) {
                    Object result = this.nextElement;
                    this.nextElement = null;
                    return result;
                }
                return this.pEnum.nextElement();
            }
        };
    }

    @Override
    protected Object handleGetObject(String key) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        return this.resources.get(key);
    }

    public String toString() {
        return "XMLResourceBundle: " + this.getLocale();
    }

    private class CatalogueHandler
    extends DefaultHandler {
        private static final String CATALOGUE = "catalogue";
        private static final String MESSAGE = "message";
        private StringBuffer valueBuffer = new StringBuffer();
        private Stack elementStack = new Stack();
        private String currentKey;

        private CatalogueHandler() {
        }

        private boolean isOwnNamespace(String uri) {
            return "".equals(uri);
        }

        private QName getParentElementName() {
            return (QName)this.elementStack.peek();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(uri, localName, qName, atts);
            QName elementName = new QName(uri, qName);
            if (this.isOwnNamespace(uri) && !CATALOGUE.equals(localName)) {
                if (MESSAGE.equals(localName)) {
                    if (!CATALOGUE.equals(this.getParentElementName().getLocalName())) {
                        throw new SAXException("message must be a child of catalogue");
                    }
                    this.currentKey = atts.getValue("key");
                } else {
                    throw new SAXException("Invalid element name: " + elementName);
                }
            }
            this.valueBuffer.setLength(0);
            this.elementStack.push(elementName);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            this.elementStack.pop();
            if (this.isOwnNamespace(uri) && !CATALOGUE.equals(localName) && MESSAGE.equals(localName)) {
                if (this.currentKey == null) {
                    throw new SAXException("current key is null (attribute 'key' might be mistyped)");
                }
                XMLResourceBundle.this.resources.put(this.currentKey, this.valueBuffer.toString());
                this.currentKey = null;
            }
            this.valueBuffer.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            this.valueBuffer.append(ch, start, length);
        }
    }

    static class MissingBundle
    extends ResourceBundle {
        MissingBundle() {
        }

        public Enumeration getKeys() {
            return null;
        }

        @Override
        public Object handleGetObject(String name) {
            return null;
        }
    }
}

