/*
 * Decompiled with CFR 0.152.
 */
package org.jxls.transform.poi;

import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Workbook;
import org.jxls.common.Context;
import org.jxls.transform.poi.WritableCellValue;

public class WritableHyperlink
implements WritableCellValue {
    public static final String LINK_URL = "URL";
    public static final String LINK_DOCUMENT = "DOCUMENT";
    public static final String LINK_EMAIL = "EMAIL";
    public static final String LINK_FILE = "FILE";
    String address;
    String title;
    HyperlinkType linkType;
    CellStyle linkStyle;

    public WritableHyperlink(String address, String title) {
        this(address, title, LINK_URL);
    }

    public WritableHyperlink(String address, String title, String linkTypeString) {
        this.address = address;
        this.title = title;
        if (LINK_URL.equals(linkTypeString)) {
            this.linkType = HyperlinkType.URL;
        } else if (LINK_DOCUMENT.equals(linkTypeString)) {
            this.linkType = HyperlinkType.DOCUMENT;
        } else if (LINK_EMAIL.equals(linkTypeString)) {
            this.linkType = HyperlinkType.EMAIL;
        } else if (LINK_FILE.equals(linkTypeString)) {
            this.linkType = HyperlinkType.FILE;
        } else {
            throw new IllegalArgumentException("Link type must be one of the following values: URL,DOCUMENT,EMAIL,FILE");
        }
    }

    public WritableHyperlink(String address, String title, HyperlinkType linkType) {
        this.address = address;
        this.title = title;
        this.linkType = linkType;
    }

    @Override
    public Object writeToCell(Cell cell, Context context) {
        Workbook workbook = cell.getSheet().getWorkbook();
        CreationHelper createHelper = workbook.getCreationHelper();
        Hyperlink hyperlink = createHelper.createHyperlink(this.linkType);
        hyperlink.setAddress(this.address);
        cell.setHyperlink(hyperlink);
        cell.setCellValue(this.title);
        if (this.linkStyle == null) {
            this.linkStyle = cell.getCellStyle();
        }
        cell.setCellStyle(this.linkStyle);
        return cell;
    }

    private CellStyle createLinkStyle(Workbook workbook) {
        this.linkStyle = workbook.createCellStyle();
        Font hlink_font = workbook.createFont();
        hlink_font.setUnderline((byte)1);
        hlink_font.setColor(IndexedColors.BLUE.getIndex());
        this.linkStyle.setFont(hlink_font);
        return this.linkStyle;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

