/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sql.visitor;

import java.util.HashSet;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.change.CheckSum;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.serializer.ReflectionSerializer;
import liquibase.serializer.core.string.StringChangeLogSerializer;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.util.ObjectUtil;
import liquibase.util.StringUtils;

public abstract class AbstractSqlVisitor
implements SqlVisitor {
    private Set<String> applicableDbms;
    private boolean applyToRollback;
    private ContextExpression contexts;
    private Labels labels;

    @Override
    public Set<String> getApplicableDbms() {
        return this.applicableDbms;
    }

    @Override
    public void setApplicableDbms(Set<String> applicableDbms) {
        this.applicableDbms = applicableDbms;
    }

    @Override
    public boolean isApplyToRollback() {
        return this.applyToRollback;
    }

    @Override
    public void setApplyToRollback(boolean applyToRollback) {
        this.applyToRollback = applyToRollback;
    }

    @Override
    public ContextExpression getContexts() {
        return this.contexts;
    }

    @Override
    public void setContexts(ContextExpression contexts) {
        this.contexts = contexts;
    }

    @Override
    public Labels getLabels() {
        return this.labels;
    }

    @Override
    public void setLabels(Labels labels) {
        this.labels = labels;
    }

    @Override
    public CheckSum generateCheckSum() {
        return CheckSum.compute(new StringChangeLogSerializer().serialize(this, false));
    }

    @Override
    public Set<String> getSerializableFields() {
        return ReflectionSerializer.getInstance().getFields(this);
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        return ReflectionSerializer.getInstance().getValue(this, field);
    }

    @Override
    public String getSerializedObjectName() {
        return this.getName();
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog-ext";
    }

    @Override
    public String getSerializableFieldNamespace(String field) {
        return this.getSerializedObjectNamespace();
    }

    @Override
    public void load(ParsedNode parsedNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        for (ParsedNode childNode : parsedNode.getChildren()) {
            try {
                Object value;
                if ("dbms".equals(childNode.getName())) {
                    this.setApplicableDbms(new HashSet<String>(StringUtils.splitAndTrim((String)childNode.getValue(), ",")));
                    continue;
                }
                if ("applyToRollback".equals(childNode.getName())) {
                    value = childNode.getValue(Boolean.class);
                    if (value == null) continue;
                    this.setApplyToRollback((Boolean)value);
                    continue;
                }
                if ("context".equals(childNode.getName()) || "contexts".equals(childNode.getName())) {
                    this.setContexts(new ContextExpression((String)childNode.getValue()));
                    continue;
                }
                if (!ObjectUtil.hasWriteProperty(this, childNode.getName())) continue;
                value = childNode.getValue();
                if (value != null) {
                    value = value.toString();
                }
                ObjectUtil.setProperty((Object)this, childNode.getName(), (String)value);
            }
            catch (Exception e2) {
                throw new ParsedNodeException("Error setting property", e2);
            }
        }
    }

    @Override
    public ParsedNode serialize() {
        throw new RuntimeException("TODO");
    }
}

