/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.dao.parameters;

import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.parameters.NotLongDataParameter;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;

public class LongParameter
extends NotLongDataParameter
implements Cloneable {
    private long value;

    public LongParameter(long value) {
        this.value = value;
    }

    @Override
    public void writeTo(PacketOutputStream os) {
        os.write(String.valueOf(this.value).getBytes());
    }

    @Override
    public void writeUnsafeTo(PacketOutputStream os) {
        os.writeUnsafe(String.valueOf(this.value).getBytes());
    }

    @Override
    public long getApproximateTextProtocolLength() {
        return String.valueOf(this.value).getBytes().length;
    }

    @Override
    public void writeBinary(PacketOutputStream writeBuffer) {
        writeBuffer.writeLong(this.value);
    }

    @Override
    public MariaDbType getMariaDbType() {
        return MariaDbType.BIGINT;
    }

    @Override
    public String toString() {
        return Long.toString(this.value);
    }
}

