/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonObjectReader;
import io.sentry.JsonSerializable;
import io.sentry.JsonUnknown;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.SpanId;
import io.sentry.SpanStatus;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class SpanContext
implements JsonUnknown,
JsonSerializable {
    public static final String TYPE = "trace";
    @NotNull
    private final SentryId traceId;
    @NotNull
    private final SpanId spanId;
    @Nullable
    private final SpanId parentSpanId;
    @Nullable
    private transient TracesSamplingDecision samplingDecision;
    @NotNull
    protected String op;
    @Nullable
    protected String description;
    @Nullable
    protected SpanStatus status;
    @NotNull
    protected @NotNull Map<String, @NotNull String> tags = new ConcurrentHashMap<String, String>();
    @Nullable
    protected String origin = "manual";
    @Nullable
    private Map<String, Object> unknown;

    public SpanContext(@NotNull String operation, @Nullable TracesSamplingDecision samplingDecision) {
        this(new SentryId(), new SpanId(), operation, null, samplingDecision);
    }

    public SpanContext(@NotNull String operation) {
        this(new SentryId(), new SpanId(), operation, null, null);
    }

    public SpanContext(@NotNull SentryId traceId, @NotNull SpanId spanId, @NotNull String operation, @Nullable SpanId parentSpanId, @Nullable TracesSamplingDecision samplingDecision) {
        this(traceId, spanId, parentSpanId, operation, null, samplingDecision, null, "manual");
    }

    @ApiStatus.Internal
    public SpanContext(@NotNull SentryId traceId, @NotNull SpanId spanId, @Nullable SpanId parentSpanId, @NotNull String operation, @Nullable String description, @Nullable TracesSamplingDecision samplingDecision, @Nullable SpanStatus status, @Nullable String origin) {
        this.traceId = Objects.requireNonNull(traceId, "traceId is required");
        this.spanId = Objects.requireNonNull(spanId, "spanId is required");
        this.op = Objects.requireNonNull(operation, "operation is required");
        this.parentSpanId = parentSpanId;
        this.samplingDecision = samplingDecision;
        this.description = description;
        this.status = status;
        this.origin = origin;
    }

    public SpanContext(@NotNull SpanContext spanContext) {
        this.traceId = spanContext.traceId;
        this.spanId = spanContext.spanId;
        this.parentSpanId = spanContext.parentSpanId;
        this.samplingDecision = spanContext.samplingDecision;
        this.op = spanContext.op;
        this.description = spanContext.description;
        this.status = spanContext.status;
        Map<String, String> copiedTags = CollectionUtils.newConcurrentHashMap(spanContext.tags);
        if (copiedTags != null) {
            this.tags = copiedTags;
        }
    }

    public void setOperation(@NotNull String operation) {
        this.op = Objects.requireNonNull(operation, "operation is required");
    }

    public void setTag(@NotNull String name, @NotNull String value) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(value, "value is required");
        this.tags.put(name, value);
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    public void setStatus(@Nullable SpanStatus status) {
        this.status = status;
    }

    @NotNull
    public SentryId getTraceId() {
        return this.traceId;
    }

    @NotNull
    public SpanId getSpanId() {
        return this.spanId;
    }

    @Nullable
    @TestOnly
    public SpanId getParentSpanId() {
        return this.parentSpanId;
    }

    @NotNull
    public String getOperation() {
        return this.op;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public SpanStatus getStatus() {
        return this.status;
    }

    @NotNull
    public Map<String, String> getTags() {
        return this.tags;
    }

    @Nullable
    public TracesSamplingDecision getSamplingDecision() {
        return this.samplingDecision;
    }

    @Nullable
    public Boolean getSampled() {
        if (this.samplingDecision == null) {
            return null;
        }
        return this.samplingDecision.getSampled();
    }

    @Nullable
    public Boolean getProfileSampled() {
        if (this.samplingDecision == null) {
            return null;
        }
        return this.samplingDecision.getProfileSampled();
    }

    @ApiStatus.Internal
    public void setSampled(@Nullable Boolean sampled) {
        if (sampled == null) {
            this.setSamplingDecision(null);
        } else {
            this.setSamplingDecision(new TracesSamplingDecision(sampled));
        }
    }

    @ApiStatus.Internal
    public void setSampled(@Nullable Boolean sampled, @Nullable Boolean profileSampled) {
        if (sampled == null) {
            this.setSamplingDecision(null);
        } else if (profileSampled == null) {
            this.setSamplingDecision(new TracesSamplingDecision(sampled));
        } else {
            this.setSamplingDecision(new TracesSamplingDecision(sampled, null, profileSampled, null));
        }
    }

    @ApiStatus.Internal
    public void setSamplingDecision(@Nullable TracesSamplingDecision samplingDecision) {
        this.samplingDecision = samplingDecision;
    }

    @Nullable
    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(@Nullable String origin) {
        this.origin = origin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpanContext)) {
            return false;
        }
        SpanContext that = (SpanContext)o;
        return this.traceId.equals(that.traceId) && this.spanId.equals(that.spanId) && Objects.equals(this.parentSpanId, that.parentSpanId) && this.op.equals(that.op) && Objects.equals(this.description, that.description) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.spanId, this.parentSpanId, this.op, this.description, this.status);
    }

    @Override
    public void serialize(@NotNull ObjectWriter writer, @NotNull ILogger logger) throws IOException {
        writer.beginObject();
        writer.name("trace_id");
        this.traceId.serialize(writer, logger);
        writer.name("span_id");
        this.spanId.serialize(writer, logger);
        if (this.parentSpanId != null) {
            writer.name("parent_span_id");
            this.parentSpanId.serialize(writer, logger);
        }
        writer.name("op").value(this.op);
        if (this.description != null) {
            writer.name("description").value(this.description);
        }
        if (this.status != null) {
            writer.name("status").value(logger, this.status);
        }
        if (this.origin != null) {
            writer.name("origin").value(logger, this.origin);
        }
        if (!this.tags.isEmpty()) {
            writer.name("tags").value(logger, this.tags);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key).value(logger, value);
            }
        }
        writer.endObject();
    }

    @Override
    @Nullable
    public Map<String, Object> getUnknown() {
        return this.unknown;
    }

    @Override
    public void setUnknown(@Nullable Map<String, Object> unknown) {
        this.unknown = unknown;
    }

    public static final class JsonKeys {
        public static final String TRACE_ID = "trace_id";
        public static final String SPAN_ID = "span_id";
        public static final String PARENT_SPAN_ID = "parent_span_id";
        public static final String OP = "op";
        public static final String DESCRIPTION = "description";
        public static final String STATUS = "status";
        public static final String TAGS = "tags";
        public static final String ORIGIN = "origin";
    }

    public static final class Deserializer
    implements JsonDeserializer<SpanContext> {
        @Override
        @NotNull
        public SpanContext deserialize(@NotNull JsonObjectReader reader, @NotNull ILogger logger) throws Exception {
            IllegalStateException exception;
            String message;
            reader.beginObject();
            SentryId traceId = null;
            SpanId spanId = null;
            SpanId parentSpanId = null;
            String op = null;
            String description = null;
            SpanStatus status = null;
            String origin = null;
            Map tags = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block20: while (reader.peek() == JsonToken.NAME) {
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "trace_id": {
                        traceId = new SentryId.Deserializer().deserialize(reader, logger);
                        continue block20;
                    }
                    case "span_id": {
                        spanId = new SpanId.Deserializer().deserialize(reader, logger);
                        continue block20;
                    }
                    case "parent_span_id": {
                        parentSpanId = reader.nextOrNull(logger, new SpanId.Deserializer());
                        continue block20;
                    }
                    case "op": {
                        op = reader.nextString();
                        continue block20;
                    }
                    case "description": {
                        description = reader.nextString();
                        continue block20;
                    }
                    case "status": {
                        status = reader.nextOrNull(logger, new SpanStatus.Deserializer());
                        continue block20;
                    }
                    case "origin": {
                        origin = reader.nextString();
                        continue block20;
                    }
                    case "tags": {
                        tags = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        continue block20;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, nextName);
            }
            if (traceId == null) {
                message = "Missing required field \"trace_id\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (spanId == null) {
                message = "Missing required field \"span_id\"";
                exception = new IllegalStateException(message);
                logger.log(SentryLevel.ERROR, message, exception);
                throw exception;
            }
            if (op == null) {
                op = "";
            }
            SpanContext spanContext = new SpanContext(traceId, spanId, op, parentSpanId, null);
            spanContext.setDescription(description);
            spanContext.setStatus(status);
            spanContext.setOrigin(origin);
            if (tags != null) {
                spanContext.tags = tags;
            }
            spanContext.setUnknown(unknown);
            reader.endObject();
            return spanContext;
        }
    }
}

