/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.send;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.mariadb.jdbc.internal.packet.send.InterfaceSendPacket;
import org.mariadb.jdbc.internal.stream.PacketOutputStream;
import org.mariadb.jdbc.internal.util.PidFactory;
import org.mariadb.jdbc.internal.util.Utils;

public class SendHandshakeResponsePacket
implements InterfaceSendPacket {
    private final byte serverLanguage;
    private byte packetSeq;
    private String username;
    private String password;
    private byte[] seed;
    private long clientCapabilities;
    private String database;
    private String plugin;
    private String connectionAttributes;
    private byte[] connectionAttributesArray;
    private int connectionAttributesPosition;
    private String passwordCharacterEncoding;

    public SendHandshakeResponsePacket(String username, String password, String database, long clientCapabilities, byte serverLanguage, byte[] seed, byte packetSeq, String plugin, String connectionAttributes, String passwordCharacterEncoding) {
        this.packetSeq = packetSeq;
        this.username = username;
        this.password = password;
        this.seed = seed;
        this.clientCapabilities = clientCapabilities;
        this.serverLanguage = serverLanguage;
        this.database = database;
        this.plugin = plugin;
        this.connectionAttributes = connectionAttributes;
        this.passwordCharacterEncoding = passwordCharacterEncoding;
    }

    @Override
    public void send(OutputStream os) throws IOException {
        byte[] authData;
        PacketOutputStream writeBuffer = (PacketOutputStream)os;
        writeBuffer.startPacket(this.packetSeq);
        switch (this.plugin) {
            case "": 
            case "mysql_native_password": {
                try {
                    authData = Utils.encryptPassword(this.password, this.seed, this.passwordCharacterEncoding);
                    break;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Could not use SHA-1, failing", e);
                }
            }
            case "mysql_clear_password": {
                if (this.passwordCharacterEncoding != null && !this.passwordCharacterEncoding.isEmpty()) {
                    authData = this.password.getBytes(this.passwordCharacterEncoding);
                    break;
                }
                authData = this.password.getBytes();
                break;
            }
            default: {
                authData = new byte[]{};
            }
        }
        writeBuffer.writeInt((int)this.clientCapabilities).writeInt(0x40000000).writeByte(this.serverLanguage);
        writeBuffer.writeBytes((byte)0, 19).writeInt((int)(this.clientCapabilities >> 32));
        if (this.username == null || "".equals(this.username)) {
            this.username = System.getProperty("user.name");
        }
        writeBuffer.writeString(this.username).writeByte((byte)0);
        if ((this.clientCapabilities & 0x200000L) != 0L) {
            writeBuffer.writeFieldLength(authData.length).writeByteArray(authData);
        } else if ((this.clientCapabilities & 0x8000L) != 0L) {
            writeBuffer.writeByte((byte)authData.length).writeByteArray(authData);
        } else {
            writeBuffer.writeByteArray(authData).writeByte((byte)0);
        }
        if ((this.clientCapabilities & 8L) != 0L) {
            writeBuffer.writeString(this.database).writeByte((byte)0);
        }
        if ((this.clientCapabilities & 0x80000L) != 0L) {
            writeBuffer.writeString(this.plugin).writeByte((byte)0);
        }
        if ((this.clientCapabilities & 0x100000L) != 0L) {
            this.writeConnectAttributes(writeBuffer);
        }
        writeBuffer.finishPacketWithoutRelease(false);
        writeBuffer.releaseBuffer();
    }

    private void writeConnectAttributes(PacketOutputStream writeBuffer) {
        this.connectionAttributesArray = new byte[200];
        this.connectionAttributesPosition = 0;
        this.writeStringLength("_client_name", "MariaDB connector/J");
        this.writeStringLength("_client_version", "1.5.9");
        this.writeStringLength("_os", System.getProperty("os.name"));
        String pid = PidFactory.getInstance().getPid();
        if (pid != null) {
            this.writeStringLength("_pid", pid);
        }
        this.writeStringLength("_thread", Long.toString(Thread.currentThread().getId()));
        this.writeStringLength("_java_vendor", System.getProperty("java.vendor"));
        this.writeStringLength("_java_version", System.getProperty("java.version"));
        if (this.connectionAttributes != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.connectionAttributes, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int separator = token.indexOf(":");
                if (separator != -1) {
                    this.writeStringLength(token.substring(0, separator), token.substring(separator + 1));
                    continue;
                }
                this.writeStringLength(token, "");
            }
        }
        writeBuffer.writeFieldLength(this.connectionAttributesPosition);
        writeBuffer.writeByteArray(Arrays.copyOfRange(this.connectionAttributesArray, 0, this.connectionAttributesPosition));
    }

    private void writeStringLength(String strKey, String strValue) {
        try {
            byte[] strBytesKey = strKey.getBytes("UTF-8");
            byte[] strBytesValue = strValue.getBytes("UTF-8");
            this.assureBufferCapacity(strBytesKey.length + strBytesValue.length + 18);
            this.writeFieldLength(strBytesKey.length);
            this.writeBytes(strBytesKey);
            this.writeFieldLength(strBytesValue.length);
            this.writeBytes(strBytesValue);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void assureBufferCapacity(int additionalSize) {
        if (this.connectionAttributesArray.length < this.connectionAttributesPosition + additionalSize) {
            byte[] newConnectionAttributesArray = new byte[Math.max(this.connectionAttributesArray.length * 2, this.connectionAttributesPosition + additionalSize)];
            System.arraycopy(this.connectionAttributesArray, 0, newConnectionAttributesArray, 0, this.connectionAttributesPosition);
            this.connectionAttributesArray = newConnectionAttributesArray;
        }
    }

    private void writeFieldLength(long length) {
        if (length < 251L) {
            this.connectionAttributesArray[this.connectionAttributesPosition++] = (byte)length;
        } else {
            this.connectionAttributesArray[this.connectionAttributesPosition++] = -4;
            this.connectionAttributesArray[this.connectionAttributesPosition++] = (byte)(length & 0xFFL);
            this.connectionAttributesArray[this.connectionAttributesPosition++] = (byte)(length >>> 8);
        }
    }

    private void writeBytes(byte[] byteValue) {
        this.assureBufferCapacity(byteValue.length);
        System.arraycopy(byteValue, 0, this.connectionAttributesArray, this.connectionAttributesPosition, byteValue.length);
        this.connectionAttributesPosition += byteValue.length;
    }
}

