/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import org.docx4j.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XHTMLAttrInjector {
    public static Logger log = LoggerFactory.getLogger(XHTMLAttrInjector.class);

    protected static String injectAttrs(String content, String classVal, String styleVal) throws ParserConfigurationException, SAXException, IOException {
        int firstChar = content.codePointAt(0);
        if (firstChar == 65279) {
            log.info("Removing BOM..");
            content = content.substring(1);
        }
        InputSource is = new InputSource();
        is.setCharacterStream(new StringReader(content));
        Document doc = XmlUtils.getNewDocumentBuilder().parse(is);
        XHTMLAttrInjector.injectAttrs(doc, classVal, styleVal);
        return XmlUtils.w3CDomNodeToString(doc);
    }

    public static void injectAttrs(Node sourceNode, String classVal, String styleVal) {
        log.debug("node type" + sourceNode.getNodeType());
        switch (sourceNode.getNodeType()) {
            case 9: 
            case 11: {
                NodeList nodes = sourceNode.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    log.debug("child " + i + "of DOCUMENT_NODE");
                    XHTMLAttrInjector.injectAttrs(nodes.item(i), classVal, styleVal);
                }
                break;
            }
            case 1: {
                NodeList children;
                Element el = (Element)sourceNode;
                if (el.getLocalName() != null && (el.getLocalName().equals("div") || el.getLocalName().equals("p") || el.getLocalName().equals("ol") || el.getLocalName().equals("ul")) && el.getAttribute("class").trim().equals("") && el.getAttribute("style").trim().equals("")) {
                    if (classVal != null) {
                        el.setAttribute("class", classVal);
                    }
                    if (styleVal != null) {
                        el.setAttribute("style", styleVal);
                    }
                }
                if ((children = sourceNode.getChildNodes()) == null) break;
                for (int i = 0; i < children.getLength(); ++i) {
                    XHTMLAttrInjector.injectAttrs(children.item(i), classVal, styleVal);
                }
                break;
            }
        }
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        String content = "<div><p>p1</p><p>p2</p><table><tr><td><p>p1</p></td></tr></table></div>";
        System.out.println(XHTMLAttrInjector.injectAttrs(content, "foo", "bar"));
    }
}

