/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.LocaleAware;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.impl.DurationImpl;
import org.ocpsoft.prettytime.impl.ResourcesTimeFormat;
import org.ocpsoft.prettytime.impl.ResourcesTimeUnit;
import org.ocpsoft.prettytime.units.Century;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Decade;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.JustNow;
import org.ocpsoft.prettytime.units.Millennium;
import org.ocpsoft.prettytime.units.Millisecond;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Second;
import org.ocpsoft.prettytime.units.TimeUnitComparator;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public class PrettyTime {
    private volatile Date reference;
    private volatile Locale locale = Locale.getDefault();
    private volatile Map<TimeUnit, TimeFormat> units = new LinkedHashMap<TimeUnit, TimeFormat>();
    private volatile List<TimeUnit> cachedUnits;

    public PrettyTime() {
        this.initTimeUnits();
    }

    public PrettyTime(Date reference) {
        this();
        this.setReference(reference);
    }

    public PrettyTime(Locale locale) {
        this.setLocale(locale);
        this.initTimeUnits();
    }

    public PrettyTime(Date reference, Locale locale) {
        this(locale);
        this.setReference(reference);
    }

    public Duration approximateDuration(Date then) {
        Date ref;
        if (then == null) {
            then = this.now();
        }
        if (null == (ref = this.reference)) {
            ref = this.now();
        }
        long difference = then.getTime() - ref.getTime();
        return this.calculateDuration(difference);
    }

    public List<Duration> calculatePreciseDuration(Date then) {
        if (then == null) {
            then = this.now();
        }
        if (null == this.reference) {
            this.reference = this.now();
        }
        ArrayList<Duration> result = new ArrayList<Duration>();
        long difference = then.getTime() - this.reference.getTime();
        Duration duration = this.calculateDuration(difference);
        result.add(duration);
        while (0L != duration.getDelta()) {
            Duration last;
            duration = this.calculateDuration(duration.getDelta());
            if (result.size() > 0 && (last = (Duration)result.get(result.size() - 1)).getUnit().equals(duration.getUnit())) break;
            if (!duration.getUnit().isPrecise()) continue;
            result.add(duration);
        }
        return result;
    }

    public String format(Date then) {
        if (then == null) {
            then = this.now();
        }
        Duration d = this.approximateDuration(then);
        return this.format(d);
    }

    public String format(Calendar then) {
        if (then == null) {
            return this.format(this.now());
        }
        return this.format(then.getTime());
    }

    public String format(Duration duration) {
        if (duration == null) {
            return this.format(this.now());
        }
        TimeFormat format = this.getFormat(duration.getUnit());
        String time = format.format(duration);
        return format.decorate(duration, time);
    }

    public String format(List<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder result = new StringBuilder();
        Duration duration = null;
        TimeFormat format = null;
        for (int i = 0; i < durations.size(); ++i) {
            duration = durations.get(i);
            format = this.getFormat(duration.getUnit());
            if (i < durations.size() - 1) {
                result.append(format.formatUnrounded(duration)).append(" ");
                continue;
            }
            result.append(format.format(duration));
        }
        return format.decorateUnrounded(duration, result.toString());
    }

    public String formatUnrounded(Date then) {
        if (then == null) {
            then = this.now();
        }
        Duration d = this.approximateDuration(then);
        return this.formatUnrounded(d);
    }

    public String formatUnrounded(Calendar then) {
        if (then == null) {
            return this.formatUnrounded(this.now());
        }
        return this.formatUnrounded(then.getTime());
    }

    public String formatUnrounded(Duration duration) {
        if (duration == null) {
            return this.formatUnrounded(this.now());
        }
        TimeFormat format = this.getFormat(duration.getUnit());
        String time = format.formatUnrounded(duration);
        return format.decorateUnrounded(duration, time);
    }

    public String formatUnrounded(List<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder result = new StringBuilder();
        Duration duration = null;
        TimeFormat format = null;
        for (int i = 0; i < durations.size(); ++i) {
            duration = durations.get(i);
            format = this.getFormat(duration.getUnit());
            result.append(format.formatUnrounded(duration));
            if (i >= durations.size() - 1) continue;
            result.append(" ");
        }
        return format.decorateUnrounded(duration, result.toString());
    }

    public String formatDuration(Date then) {
        Duration duration = this.approximateDuration(then);
        return this.formatDuration(duration);
    }

    public String formatDuration(Calendar then) {
        if (then == null) {
            return this.formatDuration(this.now());
        }
        Duration duration = this.approximateDuration(then.getTime());
        return this.formatDuration(duration);
    }

    public String formatDuration(Duration duration) {
        if (duration == null) {
            return this.format(this.now());
        }
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        return timeFormat.format(duration);
    }

    public String formatDuration(List<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder result = new StringBuilder();
        Duration duration = null;
        TimeFormat format = null;
        for (int i = 0; i < durations.size(); ++i) {
            duration = durations.get(i);
            format = this.getFormat(duration.getUnit());
            if (i < durations.size() - 1) {
                result.append(format.formatUnrounded(duration)).append(" ");
                continue;
            }
            result.append(format.format(duration));
        }
        return result.toString();
    }

    public String formatDurationUnrounded(Date then) {
        Duration duration = this.approximateDuration(then);
        return this.formatDurationUnrounded(duration);
    }

    public String formatDurationUnrounded(Calendar then) {
        if (then == null) {
            return this.formatDuration(this.now());
        }
        Duration duration = this.approximateDuration(then.getTime());
        return this.formatDurationUnrounded(duration);
    }

    public String formatDurationUnrounded(Duration duration) {
        if (duration == null) {
            return this.format(this.now());
        }
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        return timeFormat.formatUnrounded(duration);
    }

    public String formatDurationUnrounded(List<Duration> durations) {
        if (durations == null || durations.isEmpty()) {
            return this.format(this.now());
        }
        StringBuilder result = new StringBuilder();
        Duration duration = null;
        TimeFormat format = null;
        for (int i = 0; i < durations.size(); ++i) {
            duration = durations.get(i);
            format = this.getFormat(duration.getUnit());
            result.append(format.formatUnrounded(duration));
            if (i >= durations.size() - 1) continue;
            result.append(" ");
        }
        return result.toString();
    }

    public TimeFormat getFormat(TimeUnit unit) {
        if (unit != null && this.units.get(unit) != null) {
            return this.units.get(unit);
        }
        return null;
    }

    public Date getReference() {
        return this.reference;
    }

    public PrettyTime setReference(Date timestamp) {
        this.reference = timestamp;
        return this;
    }

    public List<TimeUnit> getUnits() {
        if (this.cachedUnits == null) {
            ArrayList<TimeUnit> result = new ArrayList<TimeUnit>(this.units.keySet());
            Collections.sort(result, new TimeUnitComparator());
            this.cachedUnits = Collections.unmodifiableList(result);
        }
        return this.cachedUnits;
    }

    public <UNIT extends TimeUnit> UNIT getUnit(Class<UNIT> unitType) {
        if (unitType == null) {
            return null;
        }
        for (TimeUnit unit : this.units.keySet()) {
            if (!unitType.isAssignableFrom(unit.getClass())) continue;
            return (UNIT)unit;
        }
        return null;
    }

    public PrettyTime registerUnit(TimeUnit unit, TimeFormat format) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit to register must not be null.");
        }
        if (format == null) {
            throw new IllegalArgumentException("Format to register must not be null.");
        }
        this.cachedUnits = null;
        this.units.put(unit, format);
        if (unit instanceof LocaleAware) {
            ((LocaleAware)((Object)unit)).setLocale(this.locale);
        }
        if (format instanceof LocaleAware) {
            ((LocaleAware)((Object)format)).setLocale(this.locale);
        }
        return this;
    }

    public <UNIT extends TimeUnit> TimeFormat removeUnit(Class<UNIT> unitType) {
        if (unitType == null) {
            return null;
        }
        for (TimeUnit unit : this.units.keySet()) {
            if (!unitType.isAssignableFrom(unit.getClass())) continue;
            this.cachedUnits = null;
            return this.units.remove(unit);
        }
        return null;
    }

    public TimeFormat removeUnit(TimeUnit unit) {
        if (unit == null) {
            return null;
        }
        this.cachedUnits = null;
        return this.units.remove(unit);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PrettyTime setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.locale = locale;
        for (TimeUnit unit : this.units.keySet()) {
            if (!(unit instanceof LocaleAware)) continue;
            ((LocaleAware)((Object)unit)).setLocale(locale);
        }
        for (TimeFormat format : this.units.values()) {
            if (!(format instanceof LocaleAware)) continue;
            ((LocaleAware)((Object)format)).setLocale(locale);
        }
        return this;
    }

    public String toString() {
        return "PrettyTime [reference=" + this.reference + ", locale=" + this.locale + "]";
    }

    public List<TimeUnit> clearUnits() {
        List<TimeUnit> result = this.getUnits();
        this.cachedUnits = null;
        this.units.clear();
        return result;
    }

    private Date now() {
        return new Date();
    }

    private void initTimeUnits() {
        this.addUnit(new JustNow());
        this.addUnit(new Millisecond());
        this.addUnit(new Second());
        this.addUnit(new Minute());
        this.addUnit(new Hour());
        this.addUnit(new Day());
        this.addUnit(new Week());
        this.addUnit(new Month());
        this.addUnit(new Year());
        this.addUnit(new Decade());
        this.addUnit(new Century());
        this.addUnit(new Millennium());
    }

    private void addUnit(ResourcesTimeUnit unit) {
        this.registerUnit(unit, new ResourcesTimeFormat(unit));
    }

    private Duration calculateDuration(long difference) {
        long absoluteDifference = Math.abs(difference);
        List<TimeUnit> localUnits = this.getUnits();
        DurationImpl result = new DurationImpl();
        for (int i = 0; i < localUnits.size(); ++i) {
            boolean isLastUnit;
            TimeUnit unit = localUnits.get(i);
            long millisPerUnit = Math.abs(unit.getMillisPerUnit());
            long quantity = Math.abs(unit.getMaxQuantity());
            boolean bl = isLastUnit = i == localUnits.size() - 1;
            if (0L == quantity && !isLastUnit) {
                quantity = localUnits.get(i + 1).getMillisPerUnit() / unit.getMillisPerUnit();
            }
            if (millisPerUnit * quantity <= absoluteDifference && !isLastUnit) continue;
            result.setUnit(unit);
            if (millisPerUnit > absoluteDifference) {
                result.setQuantity(this.getSign(difference));
                result.setDelta(0L);
                break;
            }
            result.setQuantity(difference / millisPerUnit);
            result.setDelta(difference - result.getQuantity() * millisPerUnit);
            break;
        }
        return result;
    }

    private long getSign(long difference) {
        if (0L > difference) {
            return -1L;
        }
        return 1L;
    }
}

