/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter;

import fr.opensagres.xdocreport.converter.ConverterTypeTo;
import fr.opensagres.xdocreport.converter.ConverterTypeVia;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import java.util.HashMap;
import java.util.Map;

public class Options {
    private String from;
    private String to;
    private String via;
    private Map<String, Object> properties = null;

    private Options() {
    }

    public static Options getFrom(DocumentKind from) {
        return Options.getFrom(from.name());
    }

    public static Options getFrom(String from) {
        Options options = new Options();
        options.from = from;
        return options;
    }

    public static Options getTo(ConverterTypeTo to) {
        return Options.getTo(to.name());
    }

    public static Options getTo(String to) {
        Options options = new Options();
        options.to = to;
        return options;
    }

    public String getFrom() {
        return this.from;
    }

    public Options from(String from) {
        this.from = from;
        return this;
    }

    public Options from(DocumentKind from) {
        return this.from(from.name());
    }

    public String getTo() {
        return this.to;
    }

    public Options to(String to) {
        this.to = to;
        return this;
    }

    public Options to(ConverterTypeTo to) {
        return this.to(to.name());
    }

    public String getVia() {
        return this.via;
    }

    public Options via(String via) {
        this.via = via;
        return this;
    }

    public Options via(ConverterTypeVia via) {
        return this.via(via.name());
    }

    public Object getSubOptions(Class<?> subOptionsClass) {
        return subOptionsClass != null ? this.getProperty(subOptionsClass.getName()) : null;
    }

    public Options subOptions(Object subOptionsValue) {
        if (subOptionsValue != null) {
            Class<?> clazz = subOptionsValue.getClass();
            String clazzName = clazz.isAnonymousClass() ? (clazz.getInterfaces() != null && clazz.getInterfaces().length > 0 ? clazz.getInterfaces()[0].getName() : clazz.getSuperclass().getName()) : clazz.getName();
            this.setProperty(clazzName, subOptionsValue);
        }
        return this;
    }

    public void setProperty(String name, Object value) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, value);
    }

    public Object getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    public boolean hasProperty(String name) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(name);
    }
}

