/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import org.hibernate.HibernateException;
import org.hibernate.jpa.event.spi.jpa.ExtendedBeanManager;
import org.hibernate.jpa.event.spi.jpa.Listener;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.jboss.logging.Logger;

public class ListenerFactoryBeanManagerExtendedImpl
implements ListenerFactory,
ExtendedBeanManager.LifecycleListener {
    private static final Logger log = Logger.getLogger(ListenerFactoryBeanManagerExtendedImpl.class);
    private final Map<Class, ListenerImpl> listenerMap = new ConcurrentHashMap<Class, ListenerImpl>();

    public static ListenerFactoryBeanManagerExtendedImpl fromBeanManagerReference(Object reference) {
        if (!ExtendedBeanManager.class.isInstance(reference)) {
            throw new IllegalArgumentException("Expecting BeanManager reference that implements optional ExtendedBeanManager contract : " + reference);
        }
        return new ListenerFactoryBeanManagerExtendedImpl((ExtendedBeanManager)reference);
    }

    public ListenerFactoryBeanManagerExtendedImpl(ExtendedBeanManager beanManager) {
        beanManager.registerLifecycleListener(this);
        log.debugf("ExtendedBeanManager access requested to CDI BeanManager : " + beanManager, new Object[0]);
    }

    @Override
    public <T> Listener<T> buildListener(Class<T> listenerClass) {
        ListenerImpl listenerImpl = this.listenerMap.get(listenerClass);
        if (listenerImpl == null) {
            listenerImpl = new ListenerImpl(listenerClass);
            this.listenerMap.put(listenerClass, listenerImpl);
        }
        return listenerImpl;
    }

    @Override
    public void release() {
        for (ListenerImpl listenerImpl : this.listenerMap.values()) {
            listenerImpl.release();
        }
        this.listenerMap.clear();
    }

    @Override
    public void beanManagerInitialized(BeanManager beanManager) {
        for (ListenerImpl listenerImpl : this.listenerMap.values()) {
            listenerImpl.initialize(beanManager);
        }
    }

    private static class ListenerImpl<T>
    implements Listener<T> {
        private final Class<T> listenerClass;
        private boolean initialized = false;
        private InjectionTarget<T> injectionTarget;
        private CreationalContext<T> creationalContext;
        private T listenerInstance;

        private ListenerImpl(Class<T> listenerClass) {
            this.listenerClass = listenerClass;
        }

        public void initialize(BeanManager beanManager) {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(this.listenerClass);
            this.injectionTarget = beanManager.createInjectionTarget(annotatedType);
            this.creationalContext = beanManager.createCreationalContext(null);
            this.listenerInstance = this.injectionTarget.produce(this.creationalContext);
            this.injectionTarget.inject(this.listenerInstance, this.creationalContext);
            this.injectionTarget.postConstruct(this.listenerInstance);
            this.initialized = true;
        }

        @Override
        public T getListener() {
            if (!this.initialized) {
                throw new HibernateException("CDI not initialized as expected");
            }
            return this.listenerInstance;
        }

        public void release() {
            if (!this.initialized) {
                return;
            }
            this.injectionTarget.preDestroy(this.listenerInstance);
            this.injectionTarget.dispose(this.listenerInstance);
            this.creationalContext.release();
        }
    }
}

