/*
 * Decompiled with CFR 0.152.
 */
package fr.w3blog.zpl.model.element;

import fr.w3blog.zpl.model.PrinterOptions;
import fr.w3blog.zpl.model.ZebraElement;
import fr.w3blog.zpl.utils.ZplUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;

public abstract class ZebraBarCode<T extends ZebraBarCode<T>>
extends ZebraElement<T> {
    Integer barCodeHeigth;
    Integer moduleWidth;
    Integer wideBarRatio;
    boolean showTextInterpretation = true;
    boolean showTextInterpretationAbove = false;
    String text;

    public ZebraBarCode(int positionX, int positionY, String text) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.text = text;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.text = text;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth, int moduleWidth, int wideBarRatio) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.text = text;
        this.moduleWidth = moduleWidth;
        this.wideBarRatio = wideBarRatio;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth, boolean showTextInterpretation, int moduleWidth, int wideBarRatio) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.showTextInterpretation = showTextInterpretation;
        this.text = text;
        this.moduleWidth = moduleWidth;
        this.wideBarRatio = wideBarRatio;
    }

    public ZebraBarCode(int positionX, int positionY, String text, int barCodeHeigth, boolean showTextInterpretation, boolean showTextInterpretationAbove) {
        this.positionX = positionX;
        this.positionY = positionY;
        this.barCodeHeigth = barCodeHeigth;
        this.text = text;
        this.showTextInterpretation = showTextInterpretation;
        this.showTextInterpretationAbove = showTextInterpretationAbove;
    }

    @Override
    protected abstract T getThis();

    public StringBuilder getStartZplCodeBuilder() {
        StringBuilder zpl = new StringBuilder();
        zpl.append(this.getZplCodePosition());
        zpl.append("\n");
        if (this.moduleWidth != null) {
            zpl.append((CharSequence)ZplUtils.zplCommandSautLigne("BY", this.moduleWidth, this.wideBarRatio, this.barCodeHeigth));
        }
        return zpl;
    }

    @Override
    public void drawPreviewGraphic(PrinterOptions printerOptions, Graphics2D graphic) {
        int top = 0;
        int left = 0;
        if (this.positionX != null) {
            left = ZplUtils.convertPointInPixel(this.positionX);
        }
        if (this.positionY != null) {
            top = ZplUtils.convertPointInPixel(this.positionY);
        }
        graphic.setColor(Color.BLACK);
        Font font = new Font("Arial", 1, this.barCodeHeigth / 2);
        graphic.drawRect(left, top, ZplUtils.convertPointInPixel(Math.round(this.moduleWidth * this.wideBarRatio * 9 * this.text.length())), ZplUtils.convertPointInPixel(this.barCodeHeigth));
        this.drawTopString(graphic, font, this.text, left, top);
    }

    public Integer getBarCodeWidth() {
        return this.moduleWidth;
    }

    public Integer getBarCodeHeigth() {
        return this.barCodeHeigth;
    }

    public Integer getWideBarRatio() {
        return this.wideBarRatio;
    }

    public boolean isShowTextInterpretation() {
        return this.showTextInterpretation;
    }

    public boolean isShowTextInterpretationAbove() {
        return this.showTextInterpretationAbove;
    }

    public String getText() {
        return this.text;
    }

    public T withBarCodeWidth(Integer barCodeWidth) {
        this.moduleWidth = barCodeWidth;
        return (T)this.getThis();
    }

    public T withBarCodeHeigth(Integer barCodeHeigth) {
        this.barCodeHeigth = barCodeHeigth;
        return (T)this.getThis();
    }

    public T withWideBarRatio(Integer wideBarRatio) {
        this.wideBarRatio = wideBarRatio;
        return (T)this.getThis();
    }

    public T withShowTextInterpretation(boolean showTextInterpretation) {
        this.showTextInterpretation = showTextInterpretation;
        return (T)this.getThis();
    }

    public T withShowTextInterpretationAbove(boolean showTextInterpretationAbove) {
        this.showTextInterpretationAbove = showTextInterpretationAbove;
        return (T)this.getThis();
    }

    public T withText(String text) {
        this.text = text;
        return (T)this.getThis();
    }
}

