/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.FormattedDiffCommand$DiffFormat;
import com.datical.liquibase.ext.diff.FormattedChangeObject;
import com.datical.liquibase.ext.diff.FormattedDiffDatabase;
import com.datical.liquibase.ext.diff.FormattedDiffDatabases;
import com.datical.liquibase.ext.diff.FormattedDiffModel;
import com.datical.liquibase.ext.diff.FormattedDiffObject;
import com.datical.liquibase.ext.diff.FormattedDiffSerializer;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.command.core.DiffCommand;
import liquibase.database.Database;
import liquibase.diff.DiffResult;
import liquibase.diff.Difference;
import liquibase.diff.StringDiff;
import liquibase.exception.LiquibaseException;
import liquibase.license.LicenseServiceFactory;
import liquibase.structure.DatabaseObject;

public class FormattedDiffCommand
extends AbstractSelfConfiguratingCommand {
    private FormattedDiffCommand$DiffFormat format;
    private DiffCommand diffCommand;

    @Override
    public String getName() {
        return "formattedDiff";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    @Override
    public int getPriority(String string) {
        int n2 = super.getPriority(string);
        if (n2 < 0) {
            return n2;
        }
        if (!LicenseServiceFactory.getInstance().getLicenseService().licenseIsValid("Liquibase Pro")) {
            return -1;
        }
        return 101;
    }

    public void configure(Map object) {
        String string = (String)object.get("format");
        if (string == null || string.isEmpty()) {
            this.format = FormattedDiffCommand$DiffFormat.TXT;
        } else {
            if (!this.validateDiffFormat(string)) {
                object = "\nWARNING: The diff command optional Pro parameter '--format' currently supports only 'TXT' or 'JSON' as values.  (Blank defaults to 'TXT')";
                throw new LiquibaseException(String.format((String)object, new Object[0]));
            }
            this.format = !string.toUpperCase().equals(FormattedDiffCommand$DiffFormat.JSON.toString()) ? FormattedDiffCommand$DiffFormat.TXT : FormattedDiffCommand$DiffFormat.JSON;
        }
        this.diffCommand = (DiffCommand)object.get("diffCommand");
    }

    @Override
    protected CommandResult run() {
        if (this.format != FormattedDiffCommand$DiffFormat.JSON) {
            return this.diffCommand.execute();
        }
        Object object = this.diffCommand.createDiffResult();
        object = this.createJsonOutput((DiffResult)object);
        this.diffCommand.getOutputStream().print((String)object);
        return new CommandResult("OK");
    }

    private boolean validateDiffFormat(String string) {
        FormattedDiffCommand$DiffFormat[] formattedDiffCommand$DiffFormatArray = FormattedDiffCommand$DiffFormat.values();
        int n2 = formattedDiffCommand$DiffFormatArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!formattedDiffCommand$DiffFormatArray[i2].toString().toLowerCase().equals(string.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    private String createJsonOutput(DiffResult diffResult) {
        Iterator iterator = diffResult.getComparisonSnapshot().getDatabase();
        Database iterator22 = diffResult.getReferenceSnapshot().getDatabase();
        String string = iterator.getConnection().getURL();
        iterator = iterator.getDatabaseProductName();
        Object object = diffResult.getProductVersionDiff();
        String string2 = ((StringDiff)object).getTargetVersion();
        String string3 = iterator22.getConnection().getURL();
        String string4 = iterator22.getDatabaseProductName();
        object = ((StringDiff)object).getReferenceVersion();
        FormattedDiffModel formattedDiffModel = new FormattedDiffModel();
        new FormattedDiffModel().created = new Date().toString();
        formattedDiffModel.databases = new FormattedDiffDatabases();
        formattedDiffModel.databases.reference = new FormattedDiffDatabase();
        formattedDiffModel.databases.reference.name = string4;
        formattedDiffModel.databases.reference.majorVersion = "";
        if (object != null) {
            this.assignVersionInfo((String)object, "reference", formattedDiffModel);
        }
        formattedDiffModel.databases.reference.url = string3;
        formattedDiffModel.databases.target = new FormattedDiffDatabase();
        formattedDiffModel.databases.target.name = iterator;
        formattedDiffModel.databases.target.majorVersion = "";
        formattedDiffModel.databases.target.minorVersion = "";
        if (string2 != null) {
            this.assignVersionInfo((String)object, "target", formattedDiffModel);
        }
        formattedDiffModel.databases.target.url = string;
        for (DatabaseObject databaseObject : diffResult.getMissingObjects()) {
            FormattedDiffObject formattedDiffObject = new FormattedDiffObject(databaseObject, "missingObject");
            formattedDiffModel.missingObjects.add(formattedDiffObject);
        }
        for (DatabaseObject databaseObject : diffResult.getUnexpectedObjects()) {
            FormattedDiffObject formattedDiffObject = new FormattedDiffObject(databaseObject, "unexpectedObject");
            formattedDiffModel.unexpectedObjects.add(formattedDiffObject);
        }
        for (DatabaseObject databaseObject : diffResult.getChangedObjects().keySet()) {
            iterator = diffResult.getChangedObjects().get(databaseObject).getDifferences();
            DatabaseObject databaseObject2 = diffResult.getComparisonSnapshot().get(databaseObject);
            FormattedDiffObject formattedDiffObject = new FormattedDiffObject(databaseObject2, "");
            FormattedChangeObject formattedChangeObject = new FormattedChangeObject(formattedDiffObject);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                object = (Difference)iterator.next();
                formattedChangeObject.differences.add((Difference)object);
            }
            formattedDiffModel.changedObjects.add(formattedChangeObject);
        }
        return new FormattedDiffSerializer().serialize(formattedDiffModel, true).replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
    }

    private String[] assignVersionInfo(String stringArray, String string, FormattedDiffModel formattedDiffModel) {
        String string2;
        if (stringArray == null) {
            return new String[0];
        }
        stringArray = stringArray.split("\\.");
        String string3 = stringArray[0];
        String string4 = string2 = stringArray.length > 1 ? stringArray[1] : "";
        if (string.equals("reference")) {
            formattedDiffModel.databases.reference.majorVersion = string3;
            formattedDiffModel.databases.reference.minorVersion = string2;
        } else {
            formattedDiffModel.databases.target.majorVersion = string3;
            formattedDiffModel.databases.target.minorVersion = string2;
        }
        return stringArray;
    }
}

