/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.sendgrid;

import com.sendgrid.SendGrid;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.sendgrid.SendGridProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@ConditionalOnClass(value={SendGrid.class})
@Conditional(value={SendGridPropertyCondition.class})
@EnableConfigurationProperties(value={SendGridProperties.class})
public class SendGridAutoConfiguration {
    private final SendGridProperties properties;

    public SendGridAutoConfiguration(SendGridProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean(value={SendGrid.class})
    public SendGrid sendGrid() {
        SendGrid sendGrid = this.createSendGrid();
        if (this.properties.isProxyConfigured()) {
            HttpHost proxy = new HttpHost(this.properties.getProxy().getHost(), this.properties.getProxy().getPort().intValue());
            sendGrid.setClient(HttpClientBuilder.create().setProxy(proxy).setUserAgent("sendgrid/" + sendGrid.getVersion() + ";java").build());
        }
        return sendGrid;
    }

    private SendGrid createSendGrid() {
        if (this.properties.getApiKey() != null) {
            return new SendGrid(this.properties.getApiKey());
        }
        return new SendGrid(this.properties.getUsername(), this.properties.getPassword());
    }

    static class SendGridPropertyCondition
    extends AnyNestedCondition {
        SendGridPropertyCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.sendgrid", value={"api-key"})
        static class SendGridApiKeyProperty {
            SendGridApiKeyProperty() {
            }
        }

        @ConditionalOnProperty(prefix="spring.sendgrid", value={"username"})
        static class SendGridUserProperty {
            SendGridUserProperty() {
            }
        }
    }
}

