/*
 * Decompiled with CFR 0.152.
 */
package liquibase.integration.servlet;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.sql.DataSource;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.LiquibaseException;
import liquibase.logging.LogService;
import liquibase.logging.LogType;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.CompositeResourceAccessor;
import liquibase.resource.FileSystemResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.util.NetUtil;
import liquibase.util.StringUtils;

public class LiquibaseServletListener
implements ServletContextListener {
    private static final String JAVA_COMP_ENV = "java:comp/env";
    private static final String LIQUIBASE_CHANGELOG = "liquibase.changelog";
    private static final String LIQUIBASE_CONTEXTS = "liquibase.contexts";
    private static final String LIQUIBASE_LABELS = "liquibase.labels";
    private static final String LIQUIBASE_DATASOURCE = "liquibase.datasource";
    private static final String LIQUIBASE_HOST_EXCLUDES = "liquibase.host.excludes";
    private static final String LIQUIBASE_HOST_INCLUDES = "liquibase.host.includes";
    private static final String LIQUIBASE_ONERROR_FAIL = "liquibase.onerror.fail";
    private static final String LIQUIBASE_PARAMETER = "liquibase.parameter";
    private static final String LIQUIBASE_SCHEMA_DEFAULT = "liquibase.schema.default";
    private String changeLogFile;
    private String dataSourceName;
    private String contexts;
    private String labels;
    private String defaultSchema;
    private String hostName;
    private ServletValueContainer servletValueContainer;

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public void setChangeLogFile(String changeLogFile) {
        this.changeLogFile = changeLogFile;
    }

    public String getContexts() {
        return this.contexts;
    }

    public void setContexts(String ctxt) {
        this.contexts = ctxt;
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels;
    }

    public String getDataSource() {
        return this.dataSourceName;
    }

    public void setDataSource(String dataSource) {
        this.dataSourceName = dataSource;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        try {
            this.hostName = NetUtil.getLocalHostName();
        }
        catch (Exception e2) {
            servletContext.log("Cannot find hostname: " + e2.getMessage());
            return;
        }
        InitialContext ic2 = null;
        String failOnError = null;
        try {
            ic2 = new InitialContext();
            this.servletValueContainer = new ServletValueContainer(servletContext, ic2);
            LiquibaseConfiguration.getInstance().init(this.servletValueContainer);
            failOnError = (String)this.servletValueContainer.getValue(LIQUIBASE_ONERROR_FAIL);
            if (this.checkPreconditions(servletContext, ic2)) {
                this.executeUpdate(servletContext, ic2);
            }
        }
        catch (Exception e3) {
            if (!"false".equals(failOnError)) {
                throw new RuntimeException(e3);
            }
        }
        finally {
            if (ic2 != null) {
                try {
                    ic2.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    private boolean checkPreconditions(ServletContext servletContext, InitialContext ic2) {
        GlobalConfiguration globalConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class);
        if (!globalConfiguration.getShouldRun()) {
            LogService.getLog(this.getClass()).info(LogType.LOG, "Liquibase did not run on " + this.hostName + " because " + LiquibaseConfiguration.getInstance().describeValueLookupLogic(globalConfiguration.getProperty("shouldRun")) + " was set to false");
            return false;
        }
        String machineIncludes = (String)this.servletValueContainer.getValue(LIQUIBASE_HOST_INCLUDES);
        String machineExcludes = (String)this.servletValueContainer.getValue(LIQUIBASE_HOST_EXCLUDES);
        boolean shouldRun = false;
        if (machineIncludes == null && machineExcludes == null) {
            shouldRun = true;
        } else if (machineIncludes != null) {
            for (String machine : machineIncludes.split(",")) {
                if (!this.hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                shouldRun = true;
            }
        } else if (machineExcludes != null) {
            shouldRun = true;
            for (String machine : machineExcludes.split(",")) {
                if (!this.hostName.equalsIgnoreCase(machine = machine.trim())) continue;
                shouldRun = false;
            }
        }
        if (globalConfiguration.getShouldRun() && globalConfiguration.getProperty("shouldRun").getWasOverridden()) {
            shouldRun = true;
            servletContext.log("ignoring liquibase.host.includes and liquibase.host.excludes, since " + LiquibaseConfiguration.getInstance().describeValueLookupLogic(globalConfiguration.getProperty("shouldRun")) + "=true");
        }
        if (!shouldRun) {
            servletContext.log("LiquibaseServletListener did not run due to liquibase.host.includes and/or liquibase.host.excludes");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeUpdate(ServletContext servletContext, InitialContext ic2) throws NamingException, SQLException, LiquibaseException {
        this.setDataSource((String)this.servletValueContainer.getValue(LIQUIBASE_DATASOURCE));
        if (this.getDataSource() == null) {
            throw new RuntimeException("Cannot run Liquibase, liquibase.datasource is not set");
        }
        this.setChangeLogFile((String)this.servletValueContainer.getValue(LIQUIBASE_CHANGELOG));
        if (this.getChangeLogFile() == null) {
            throw new RuntimeException("Cannot run Liquibase, liquibase.changelog is not set");
        }
        this.setContexts((String)this.servletValueContainer.getValue(LIQUIBASE_CONTEXTS));
        this.setLabels((String)this.servletValueContainer.getValue(LIQUIBASE_LABELS));
        this.defaultSchema = StringUtils.trimToNull((String)this.servletValueContainer.getValue(LIQUIBASE_SCHEMA_DEFAULT));
        Connection connection = null;
        Database database = null;
        try {
            DataSource dataSource = (DataSource)ic2.lookup(this.dataSourceName);
            connection = dataSource.getConnection();
            Thread currentThread = Thread.currentThread();
            ClassLoader contextClassLoader = currentThread.getContextClassLoader();
            ClassLoaderResourceAccessor threadClFO = new ClassLoaderResourceAccessor(contextClassLoader);
            ClassLoaderResourceAccessor clFO = new ClassLoaderResourceAccessor();
            FileSystemResourceAccessor fsFO = new FileSystemResourceAccessor();
            database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation(new JdbcConnection(connection));
            database.setDefaultSchemaName(this.getDefaultSchema());
            Liquibase liquibase = new Liquibase(this.getChangeLogFile(), (ResourceAccessor)new CompositeResourceAccessor(clFO, fsFO, threadClFO), database);
            Enumeration initParameters = servletContext.getInitParameterNames();
            while (initParameters.hasMoreElements()) {
                String name = ((String)initParameters.nextElement()).trim();
                if (!name.startsWith("liquibase.parameter.")) continue;
                liquibase.setChangeLogParameter(name.substring(LIQUIBASE_PARAMETER.length() + 1), this.servletValueContainer.getValue(name));
            }
            liquibase.update(new Contexts(this.getContexts()), new LabelExpression(this.getLabels()));
            if (database instanceof DerbyDatabase) {
                ((DerbyDatabase)database).setShutdownEmbeddedDerby(false);
            }
        }
        finally {
            if (database != null) {
                database.close();
            } else if (connection != null) {
                connection.close();
            }
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
    }

    protected class ServletValueContainer
    implements ConfigurationValueProvider {
        private ServletContext servletContext;
        private InitialContext initialContext;

        public ServletValueContainer(ServletContext servletContext, InitialContext initialContext) {
            this.servletContext = servletContext;
            this.initialContext = initialContext;
        }

        @Override
        public String describeValueLookupLogic(ConfigurationProperty property) {
            return "JNDI, servlet container init parameter, and system property '" + property.getNamespace() + "." + property.getName() + "'";
        }

        @Override
        public Object getValue(String namespace, String property) {
            return this.getValue(namespace + "." + property);
        }

        public Object getValue(String prefixAndProperty) {
            try {
                Context envCtx = (Context)this.initialContext.lookup(LiquibaseServletListener.JAVA_COMP_ENV);
                String valueFromJndi = (String)envCtx.lookup(prefixAndProperty);
                return valueFromJndi;
            }
            catch (NamingException envCtx) {
                String valueFromServletContext = this.servletContext.getInitParameter(prefixAndProperty);
                if (valueFromServletContext != null) {
                    return valueFromServletContext;
                }
                return System.getProperty(prefixAndProperty);
            }
        }
    }
}

