/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins.databasemigration.liquibase;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.sql.Connection;
import java.util.Iterator;
import java.util.Map;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.integration.spring.SpringLiquibase;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.plugins.databasemigration.PluginConstants;
import org.springframework.context.ApplicationContext;

public class GrailsLiquibase
extends SpringLiquibase
implements GroovyObject {
    private ApplicationContext applicationContext;
    private String dataSourceName;
    private String databaseChangeLogTableName;
    private String databaseChangeLogLockTableName;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    /*
     * WARNING - void declaration
     */
    public GrailsLiquibase(ApplicationContext applicationContext) {
        void applicationContext2;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        void var3_3 = applicationContext2;
        this.applicationContext = var3_3;
    }

    protected Liquibase createLiquibase(Connection connection) throws LiquibaseException {
        Liquibase liquibase = new Liquibase(this.getChangeLog(), (ResourceAccessor)new ClassLoaderResourceAccessor(), this.createDatabase(connection, null));
        liquibase.setIgnoreClasspathPrefix(this.isIgnoreClasspathPrefix());
        if (this.parameters != null) {
            Map.Entry entry = null;
            Iterator iterator = this.parameters.entrySet().iterator();
            while (iterator.hasNext()) {
                entry = (Map.Entry)ScriptBytecodeAdapter.castToType(iterator.next(), Map.Entry.class);
                liquibase.setChangeLogParameter(ShortTypeHandling.castToString(entry.getKey()), entry.getValue());
            }
        }
        liquibase.setChangeLogParameter(PluginConstants.getDATA_SOURCE_NAME_KEY(), (Object)this.dataSourceName);
        if (this.isDropFirst()) {
            liquibase.dropAll();
        }
        return liquibase;
    }

    protected Database createDatabase(Connection connection, ResourceAccessor accessor) throws DatabaseException {
        Database database = super.createDatabase(connection, accessor);
        if (DefaultTypeTransformation.booleanUnbox((Object)this.databaseChangeLogTableName)) {
            String string = this.databaseChangeLogTableName;
            database.setDatabaseChangeLogTableName(string);
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)this.databaseChangeLogLockTableName)) {
            String string = this.databaseChangeLogLockTableName;
            database.setDatabaseChangeLogLockTableName(string);
        }
        return database;
    }

    protected void performUpdate(Liquibase liquibase) throws LiquibaseException {
        if (!this.applicationContext.containsBean("migrationCallbacks")) {
            super.performUpdate(liquibase);
            return;
        }
        Database database = liquibase.getDatabase();
        Object migrationCallbacks = this.applicationContext.getBean("migrationCallbacks");
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getMetaClass((Object)migrationCallbacks).respondsTo(migrationCallbacks, "beforeStartMigration"))) {
            DefaultGroovyMethods.invokeMethod((Object)migrationCallbacks, (String)"beforeStartMigration", (Object)new Object[]{database});
        }
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getMetaClass((Object)migrationCallbacks).respondsTo(migrationCallbacks, "onStartMigration"))) {
            DefaultGroovyMethods.invokeMethod((Object)migrationCallbacks, (String)"onStartMigration", (Object)new Object[]{database, liquibase, this.getChangeLog()});
        }
        super.performUpdate(liquibase);
        if (DefaultTypeTransformation.booleanUnbox((Object)DefaultGroovyMethods.getMetaClass((Object)migrationCallbacks).respondsTo(migrationCallbacks, "afterMigrations"))) {
            DefaultGroovyMethods.invokeMethod((Object)migrationCallbacks, (String)"afterMigrations", (Object)new Object[]{database});
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != GrailsLiquibase.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public String getDatabaseChangeLogTableName() {
        return this.databaseChangeLogTableName;
    }

    public void setDatabaseChangeLogTableName(String string) {
        this.databaseChangeLogTableName = string;
    }

    public String getDatabaseChangeLogLockTableName() {
        return this.databaseChangeLogLockTableName;
    }

    public void setDatabaseChangeLogLockTableName(String string) {
        this.databaseChangeLogLockTableName = string;
    }
}

