/*
 * Decompiled with CFR 0.152.
 */
package org.grails.orm.hibernate.cfg;

import grails.gorm.annotation.Entity;
import grails.gorm.hibernate.HibernateEntity;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import java.lang.annotation.Annotation;
import java.util.Locale;
import org.grails.datastore.gorm.GormEntity;
import org.grails.datastore.mapping.config.AbstractGormMappingFactory;
import org.grails.datastore.mapping.config.Property;
import org.grails.datastore.mapping.config.groovy.MappingConfigurationBuilder;
import org.grails.datastore.mapping.model.AbstractMappingContext;
import org.grails.datastore.mapping.model.ClassMapping;
import org.grails.datastore.mapping.model.DatastoreConfigurationException;
import org.grails.datastore.mapping.model.EmbeddedPersistentEntity;
import org.grails.datastore.mapping.model.IdentityMapping;
import org.grails.datastore.mapping.model.MappingConfigurationStrategy;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.MappingFactory;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.model.ValueGenerator;
import org.grails.datastore.mapping.model.config.JpaMappingConfigurationStrategy;
import org.grails.datastore.mapping.reflect.ClassUtils;
import org.grails.orm.hibernate.cfg.CompositeIdentity;
import org.grails.orm.hibernate.cfg.HibernateMappingBuilder;
import org.grails.orm.hibernate.cfg.HibernatePersistentEntity;
import org.grails.orm.hibernate.cfg.Identity;
import org.grails.orm.hibernate.cfg.Mapping;
import org.grails.orm.hibernate.cfg.PropertyConfig;
import org.grails.orm.hibernate.connections.HibernateConnectionSourceSettings;
import org.grails.orm.hibernate.proxy.SimpleHibernateProxyHandler;
import org.springframework.core.env.PropertyResolver;
import org.springframework.validation.Errors;

public class HibernateMappingContext
extends AbstractMappingContext {
    private static final String[] DEFAULT_IDENTITY_MAPPING = new String[]{"id"};
    private final HibernateMappingFactory mappingFactory = new HibernateMappingFactory();
    private final MappingConfigurationStrategy syntaxStrategy;

    public HibernateMappingContext(HibernateConnectionSourceSettings settings, Object contextObject, Class ... persistentClasses) {
        this.initialize(settings);
        if (settings != null) {
            this.mappingFactory.setDefaultMapping(settings.getDefault().getMapping());
            this.mappingFactory.setDefaultConstraints(settings.getDefault().getConstraints());
        }
        this.mappingFactory.setContextObject(contextObject);
        this.syntaxStrategy = new JpaMappingConfigurationStrategy((MappingFactory)this.mappingFactory){

            protected boolean supportsCustomType(Class<?> propertyType) {
                return !Errors.class.isAssignableFrom(propertyType);
            }
        };
        this.proxyFactory = new SimpleHibernateProxyHandler();
        this.addPersistentEntities(persistentClasses);
    }

    public HibernateMappingContext(HibernateConnectionSourceSettings settings, Class ... persistentClasses) {
        this(settings, (Object)null, persistentClasses);
    }

    public HibernateMappingContext() {
        this(new HibernateConnectionSourceSettings(), new Class[0]);
    }

    @Deprecated
    public HibernateMappingContext(PropertyResolver configuration, Object contextObject, Class ... persistentClasses) {
        this((Closure)configuration.getProperty("grails.gorm.default.mapping", Closure.class, null), contextObject);
        this.addPersistentEntities(persistentClasses);
    }

    @Deprecated
    public HibernateMappingContext(PropertyResolver configuration, Object contextObject, Closure defaultConstraints, Class ... persistentClasses) {
        this((Closure)configuration.getProperty("grails.gorm.default.mapping", Closure.class, null), contextObject);
        this.setDefaultConstraints(defaultConstraints);
        this.addPersistentEntities(persistentClasses);
    }

    @Deprecated
    public HibernateMappingContext(PropertyResolver configuration, Object contextObject) {
        this((Closure)configuration.getProperty("grails.gorm.default.mapping", Closure.class, null), contextObject);
    }

    @Deprecated
    public HibernateMappingContext(Closure defaultMapping) {
        this(defaultMapping, null);
    }

    @Deprecated
    public HibernateMappingContext(Closure defaultMapping, Object contextObject) {
        if (defaultMapping != null) {
            this.mappingFactory.setDefaultMapping(defaultMapping);
        }
        this.mappingFactory.setContextObject(contextObject);
        this.syntaxStrategy = new JpaMappingConfigurationStrategy((MappingFactory)this.mappingFactory){

            protected boolean supportsCustomType(Class<?> propertyType) {
                return !Errors.class.isAssignableFrom(propertyType);
            }
        };
    }

    public void setDefaultConstraints(Closure defaultConstraints) {
        this.mappingFactory.setDefaultConstraints(defaultConstraints);
    }

    public MappingConfigurationStrategy getMappingSyntaxStrategy() {
        return this.syntaxStrategy;
    }

    public MappingFactory getMappingFactory() {
        return this.mappingFactory;
    }

    protected PersistentEntity createPersistentEntity(Class javaClass) {
        Object mappingStrategy;
        if (GormEntity.class.isAssignableFrom(javaClass) && this.isValidMappingStrategy(javaClass, mappingStrategy = this.resolveMappingStrategy(javaClass))) {
            return new HibernatePersistentEntity(javaClass, (MappingContext)this);
        }
        return null;
    }

    protected boolean isValidMappingStrategy(Class javaClass, Object mappingStrategy) {
        return HibernateEntity.class.isAssignableFrom(javaClass) || super.isValidMappingStrategy(javaClass, mappingStrategy);
    }

    protected PersistentEntity createPersistentEntity(Class javaClass, boolean external) {
        return this.createPersistentEntity(javaClass);
    }

    public static boolean isDomainClass(Class clazz) {
        return HibernateMappingContext.doIsDomainClassCheck(clazz);
    }

    private static boolean doIsDomainClassCheck(Class<?> clazz) {
        Annotation[] allAnnotations;
        if (GormEntity.class.isAssignableFrom(clazz)) {
            return true;
        }
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isEnum()) {
            return false;
        }
        for (Annotation annotation : allAnnotations = clazz.getAnnotations()) {
            Class<? extends Annotation> type = annotation.annotationType();
            String annName = type.getName();
            if (annName.equals("grails.persistence.Entity")) {
                return true;
            }
            if (!type.equals(Entity.class)) continue;
            return true;
        }
        for (Class<?> testClass = clazz; testClass != null && !testClass.equals(GroovyObject.class) && !testClass.equals(Object.class); testClass = testClass.getSuperclass()) {
            try {
                testClass.getDeclaredField("id");
                testClass.getDeclaredField("version");
                return true;
            }
            catch (SecurityException securityException) {
                continue;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return false;
    }

    public PersistentEntity createEmbeddedEntity(Class type) {
        HibernateEmbeddedPersistentEntity embedded = new HibernateEmbeddedPersistentEntity(type, (MappingContext)this);
        embedded.initialize();
        return embedded;
    }

    class HibernateMappingFactory
    extends AbstractGormMappingFactory<Mapping, PropertyConfig> {
        protected MappingConfigurationBuilder createConfigurationBuilder(PersistentEntity entity, Mapping mapping) {
            return new HibernateMappingBuilder(mapping, entity.getName(), this.defaultConstraints);
        }

        public IdentityMapping createIdentityMapping(final ClassMapping classMapping) {
            ValueGenerator generator;
            Mapping mappedForm = (Mapping)this.createMappedForm(classMapping.getEntity());
            final Property identity = mappedForm.getIdentity();
            if (identity instanceof Identity) {
                Identity id = (Identity)identity;
                String generatorName = id.getGenerator();
                if (generatorName != null) {
                    ValueGenerator resolvedGenerator;
                    try {
                        resolvedGenerator = ValueGenerator.valueOf((String)generatorName.toUpperCase(Locale.ENGLISH));
                    }
                    catch (IllegalArgumentException e) {
                        if (ClassUtils.isPresent((String)generatorName)) {
                            resolvedGenerator = ValueGenerator.CUSTOM;
                        }
                        throw new DatastoreConfigurationException("Invalid id generation strategy for entity [" + classMapping.getEntity().getName() + "]: " + generatorName);
                    }
                    generator = resolvedGenerator;
                } else {
                    generator = ValueGenerator.AUTO;
                }
            } else {
                generator = ValueGenerator.AUTO;
            }
            return new IdentityMapping(){

                public String[] getIdentifierName() {
                    if (identity instanceof Identity) {
                        String name = ((Identity)((Object)identity)).getName();
                        if (name != null) {
                            return new String[]{name};
                        }
                        return DEFAULT_IDENTITY_MAPPING;
                    }
                    if (identity instanceof CompositeIdentity) {
                        return ((CompositeIdentity)identity).getPropertyNames();
                    }
                    return DEFAULT_IDENTITY_MAPPING;
                }

                public ValueGenerator getGenerator() {
                    return generator;
                }

                public ClassMapping getClassMapping() {
                    return classMapping;
                }

                public Property getMappedForm() {
                    return (Property)identity;
                }
            };
        }

        protected boolean allowArbitraryCustomTypes() {
            return true;
        }

        protected Class<PropertyConfig> getPropertyMappedFormType() {
            return PropertyConfig.class;
        }

        protected Class<Mapping> getEntityMappedFormType() {
            return Mapping.class;
        }
    }

    static class HibernateEmbeddedPersistentEntity
    extends EmbeddedPersistentEntity {
        private final ClassMapping<Mapping> classMapping = new ClassMapping<Mapping>(){
            Mapping mappedForm;
            {
                this.mappedForm = (Mapping)HibernateEmbeddedPersistentEntity.this.context.getMappingFactory().createMappedForm((PersistentEntity)HibernateEmbeddedPersistentEntity.this);
            }

            public PersistentEntity getEntity() {
                return HibernateEmbeddedPersistentEntity.this;
            }

            public Mapping getMappedForm() {
                return this.mappedForm;
            }

            public IdentityMapping getIdentifier() {
                return null;
            }
        };

        public HibernateEmbeddedPersistentEntity(Class type, MappingContext ctx) {
            super(type, ctx);
        }

        public ClassMapping getMapping() {
            return this.classMapping;
        }
    }
}

