/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.core.styles.table.cell;

import fr.opensagres.poi.xwpf.converter.core.TableWidth;
import fr.opensagres.poi.xwpf.converter.core.styles.table.cell.AbstractTableCellValueProvider;
import fr.opensagres.poi.xwpf.converter.core.utils.DxaUtil;
import fr.opensagres.poi.xwpf.converter.core.utils.XWPFTableUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTcPr;

public class TableCellWidthValueProvider
extends AbstractTableCellValueProvider<TableWidth> {
    public static final TableCellWidthValueProvider INSTANCE = new TableCellWidthValueProvider();

    @Override
    public TableWidth getValue(CTTcPr tcPr) {
        if (tcPr == null) {
            return null;
        }
        CTTblWidth tblWidth = tcPr.getTcW();
        return this.getTableWidth(tblWidth);
    }

    public TableWidth getTableWidth(CTTblWidth tblWidth) {
        boolean percentUnit;
        if (tblWidth == null) {
            return null;
        }
        float width = XWPFTableUtil.getTblWidthW(tblWidth).floatValue();
        boolean bl = percentUnit = 2 == tblWidth.getType().intValue();
        width = percentUnit ? (width /= 100.0f) : DxaUtil.dxa2points(width);
        return new TableWidth(width, percentUnit);
    }
}

