/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity.internal;

import fr.opensagres.xdocreport.template.FieldsExtractor;
import fr.opensagres.xdocreport.template.velocity.internal.Foreach;
import java.util.Stack;
import org.apache.velocity.runtime.parser.node.ASTDirective;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ASTprocess;
import org.apache.velocity.runtime.visitor.BaseVisitor;

public class ExtractVariablesVelocityVisitor
extends BaseVisitor {
    private final FieldsExtractor extractor;
    private Stack<Foreach> foreachStack = new Stack();

    public ExtractVariablesVelocityVisitor(FieldsExtractor extractor) {
        this.extractor = extractor;
    }

    public Object visit(ASTprocess node, Object data) {
        return super.visit(node, data);
    }

    public Object visit(ASTDirective node, Object data) {
        boolean isForeach = "foreach".equals(node.getDirectiveName());
        if (isForeach) {
            this.foreachStack.push(new Foreach());
        }
        Object o = super.visit(node, data);
        if (isForeach) {
            this.foreachStack.pop();
        }
        return o;
    }

    public Object visit(ASTReference node, Object data) {
        String variableName = node.literal();
        if (variableName.startsWith("$")) {
            variableName = variableName.substring(1, variableName.length());
        }
        if (!this.foreachStack.isEmpty()) {
            Foreach currentForeach = this.foreachStack.peek();
            if (currentForeach.getItem() == null) {
                currentForeach.setItem(variableName);
            } else if (currentForeach.getSequence() == null) {
                currentForeach.setSequence(variableName);
            } else {
                String firstToken = variableName;
                int index = firstToken.indexOf(46);
                if (index != -1) {
                    firstToken = firstToken.substring(0, index);
                }
                if (firstToken.equals(currentForeach.getItem())) {
                    String field = "";
                    if (index != -1) {
                        field = variableName.substring(index, variableName.length());
                    }
                    this.extractor.addFieldName(currentForeach.getSequence() + field, true);
                } else {
                    this.extractor.addFieldName(variableName, false);
                }
            }
        } else {
            this.extractor.addFieldName(variableName, false);
        }
        return super.visit(node, data);
    }
}

