/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.mariadb.jdbc.MariaDbClientPreparedStatement;
import org.mariadb.jdbc.MariaDbConnection;
import org.mariadb.jdbc.MariaDbServerPreparedStatement;
import org.mariadb.jdbc.internal.stream.PrepareSqlException;

public class MariaDbPrepareStatementFacade
implements PreparedStatement {
    private PreparedStatement preparedStatement;
    private boolean isPrepared = true;

    public MariaDbPrepareStatementFacade(String sql, int resultSetScrollType, MariaDbConnection connection) throws SQLException {
        this.preparedStatement = new MariaDbServerPreparedStatement(connection, sql, resultSetScrollType, false);
    }

    private void clientFailover() throws SQLException {
        MariaDbServerPreparedStatement currentPrepStmt = (MariaDbServerPreparedStatement)this.preparedStatement;
        MariaDbClientPreparedStatement newPrepStmt = new MariaDbClientPreparedStatement((MariaDbConnection)currentPrepStmt.getConnection(), currentPrepStmt.sql, currentPrepStmt.resultSetScrollType);
        newPrepStmt.initializeFallbackClient(currentPrepStmt);
        this.isPrepared = false;
        this.preparedStatement = newPrepStmt;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.preparedStatement.clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            return this.preparedStatement.execute();
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.execute();
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        try {
            return this.preparedStatement.execute(sql);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.execute(sql);
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.preparedStatement.execute(sql, autoGeneratedKeys);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.execute(sql, autoGeneratedKeys);
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.preparedStatement.execute(sql, columnIndexes);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.execute(sql, columnIndexes);
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.preparedStatement.execute(sql, columnNames);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.execute(sql, columnNames);
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            return this.preparedStatement.executeQuery();
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeQuery();
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.preparedStatement.executeQuery(sql);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeQuery(sql);
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.preparedStatement.executeUpdate(sql);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeUpdate(sql);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            return this.preparedStatement.executeUpdate();
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeUpdate();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.preparedStatement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeUpdate(sql, autoGeneratedKeys);
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.preparedStatement.executeUpdate(sql, columnIndexes);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeUpdate(sql, columnIndexes);
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.preparedStatement.executeUpdate(sql, columnNames);
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeUpdate(sql, columnNames);
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        try {
            return this.preparedStatement.executeBatch();
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.executeBatch();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.preparedStatement.addBatch();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLException("Cannot do addBatch(String) on preparedStatement");
    }

    @Override
    public void setArray(int parameterIndex, Array array) throws SQLException {
        this.preparedStatement.setArray(parameterIndex, array);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setAsciiStream(parameterIndex, inputStream);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob blob) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, blob);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.preparedStatement.setBinaryStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.preparedStatement.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean booleanValue) throws SQLException {
        this.preparedStatement.setBoolean(parameterIndex, booleanValue);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal bigDecimalValue) throws SQLException {
        this.preparedStatement.setBigDecimal(parameterIndex, bigDecimalValue);
    }

    @Override
    public void setByte(int parameterIndex, byte byteValue) throws SQLException {
        this.preparedStatement.setByte(parameterIndex, byteValue);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] bytes) throws SQLException {
        this.preparedStatement.setBytes(parameterIndex, bytes);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Clob clob) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, clob);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setDate(int parameterIndex, Date date, Calendar cal) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, date, cal);
    }

    @Override
    public void setDate(int parameterIndex, Date dateValue) throws SQLException {
        this.preparedStatement.setDate(parameterIndex, dateValue);
    }

    @Override
    public void setDouble(int parameterIndex, double doubleValue) throws SQLException {
        this.preparedStatement.setDouble(parameterIndex, doubleValue);
    }

    @Override
    public void setFloat(int parameterIndex, float floatValue) throws SQLException {
        this.preparedStatement.setFloat(parameterIndex, floatValue);
    }

    @Override
    public void setInt(int parameterIndex, int intValue) throws SQLException {
        this.preparedStatement.setInt(parameterIndex, intValue);
    }

    @Override
    public void setLong(int parameterIndex, long longValue) throws SQLException {
        this.preparedStatement.setLong(parameterIndex, longValue);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.preparedStatement.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.preparedStatement.setNCharacterStream(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.preparedStatement.setNClob(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.preparedStatement.setNString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.preparedStatement.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object object, int targetSqlType, int scaleOrLength) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, object, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object obj, int targetSqlType) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, obj, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object obj) throws SQLException {
        this.preparedStatement.setObject(parameterIndex, obj);
    }

    @Override
    public void setRowId(int parameterIndex, RowId rowid) throws SQLException {
        this.preparedStatement.setRowId(parameterIndex, rowid);
    }

    @Override
    public void setShort(int parameterIndex, short shortValue) throws SQLException {
        this.preparedStatement.setShort(parameterIndex, shortValue);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.preparedStatement.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setString(int parameterIndex, String stringValue) throws SQLException {
        this.preparedStatement.setString(parameterIndex, stringValue);
    }

    @Override
    public void setTime(int parameterIndex, Time time, Calendar cal) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, time, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time timeValue) throws SQLException {
        this.preparedStatement.setTime(parameterIndex, timeValue);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timestampValue) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, timestampValue);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp timeStamp, Calendar cal) throws SQLException {
        this.preparedStatement.setTimestamp(parameterIndex, timeStamp, cal);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream inputStream, int length) throws SQLException {
        this.preparedStatement.setUnicodeStream(parameterIndex, inputStream, length);
    }

    @Override
    public void setURL(int parameterIndex, URL url) throws SQLException {
        this.preparedStatement.setURL(parameterIndex, url);
    }

    @Override
    public void setRef(int parameterIndex, Ref ref) throws SQLException {
        this.preparedStatement.setRef(parameterIndex, ref);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.preparedStatement.getMetaData();
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.getMetaData();
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.preparedStatement.getParameterMetaData();
        }
        catch (PrepareSqlException prepareException) {
            this.clientFailover();
            return this.preparedStatement.getParameterMetaData();
        }
    }

    @Override
    public void close() throws SQLException {
        this.preparedStatement.close();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.preparedStatement.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.preparedStatement.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.preparedStatement.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.preparedStatement.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.preparedStatement.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.preparedStatement.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.preparedStatement.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.preparedStatement.cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.preparedStatement.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.preparedStatement.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.preparedStatement.setCursorName(name);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.preparedStatement.getResultSet();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.preparedStatement.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.preparedStatement.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.preparedStatement.getMoreResults(current);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.preparedStatement.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.preparedStatement.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.preparedStatement.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.preparedStatement.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.preparedStatement.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.preparedStatement.getResultSetType();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.preparedStatement.clearBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.preparedStatement.getConnection();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.preparedStatement.getGeneratedKeys();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.preparedStatement.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.preparedStatement.isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.preparedStatement.setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.preparedStatement.isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.preparedStatement.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.preparedStatement.isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.preparedStatement.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.preparedStatement.isWrapperFor(iface);
    }

    public String toString() {
        return this.preparedStatement.toString();
    }
}

